/* valaccodeblock.c generated by valac, the Vala compiler
 * generated from valaccodeblock.vala, do not modify */

/* valaccodeblock.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_STATEMENT (vala_ccode_statement_get_type ())
#define VALA_CCODE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatement))
#define VALA_CCODE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatementClass))
#define VALA_IS_CCODE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STATEMENT))
#define VALA_IS_CCODE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STATEMENT))
#define VALA_CCODE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatementClass))

typedef struct _ValaCCodeStatement ValaCCodeStatement;
typedef struct _ValaCCodeStatementClass ValaCCodeStatementClass;
typedef struct _ValaCCodeStatementPrivate ValaCCodeStatementPrivate;

#define VALA_TYPE_CCODE_BLOCK (vala_ccode_block_get_type ())
#define VALA_CCODE_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlock))
#define VALA_CCODE_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockClass))
#define VALA_IS_CCODE_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BLOCK))
#define VALA_IS_CCODE_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BLOCK))
#define VALA_CCODE_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockClass))

typedef struct _ValaCCodeBlock ValaCCodeBlock;
typedef struct _ValaCCodeBlockClass ValaCCodeBlockClass;
typedef struct _ValaCCodeBlockPrivate ValaCCodeBlockPrivate;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VALA_TYPE_CCODE_LABEL (vala_ccode_label_get_type ())
#define VALA_CCODE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_LABEL, ValaCCodeLabel))
#define VALA_CCODE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_LABEL, ValaCCodeLabelClass))
#define VALA_IS_CCODE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_LABEL))
#define VALA_IS_CCODE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_LABEL))
#define VALA_CCODE_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_LABEL, ValaCCodeLabelClass))

typedef struct _ValaCCodeLabel ValaCCodeLabel;
typedef struct _ValaCCodeLabelClass ValaCCodeLabelClass;

#define VALA_TYPE_CCODE_CASE_STATEMENT (vala_ccode_case_statement_get_type ())
#define VALA_CCODE_CASE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatement))
#define VALA_CCODE_CASE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementClass))
#define VALA_IS_CCODE_CASE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CASE_STATEMENT))
#define VALA_IS_CCODE_CASE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CASE_STATEMENT))
#define VALA_CCODE_CASE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementClass))

typedef struct _ValaCCodeCaseStatement ValaCCodeCaseStatement;
typedef struct _ValaCCodeCaseStatementClass ValaCCodeCaseStatementClass;
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

#define VALA_TYPE_CCODE_RETURN_STATEMENT (vala_ccode_return_statement_get_type ())
#define VALA_CCODE_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_RETURN_STATEMENT, ValaCCodeReturnStatement))
#define VALA_CCODE_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_RETURN_STATEMENT, ValaCCodeReturnStatementClass))
#define VALA_IS_CCODE_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_RETURN_STATEMENT))
#define VALA_IS_CCODE_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_RETURN_STATEMENT))
#define VALA_CCODE_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_RETURN_STATEMENT, ValaCCodeReturnStatementClass))

typedef struct _ValaCCodeReturnStatement ValaCCodeReturnStatement;
typedef struct _ValaCCodeReturnStatementClass ValaCCodeReturnStatementClass;

#define VALA_TYPE_CCODE_GOTO_STATEMENT (vala_ccode_goto_statement_get_type ())
#define VALA_CCODE_GOTO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GOTO_STATEMENT, ValaCCodeGotoStatement))
#define VALA_CCODE_GOTO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GOTO_STATEMENT, ValaCCodeGotoStatementClass))
#define VALA_IS_CCODE_GOTO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GOTO_STATEMENT))
#define VALA_IS_CCODE_GOTO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GOTO_STATEMENT))
#define VALA_CCODE_GOTO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GOTO_STATEMENT, ValaCCodeGotoStatementClass))

typedef struct _ValaCCodeGotoStatement ValaCCodeGotoStatement;
typedef struct _ValaCCodeGotoStatementClass ValaCCodeGotoStatementClass;

#define VALA_TYPE_CCODE_CONTINUE_STATEMENT (vala_ccode_continue_statement_get_type ())
#define VALA_CCODE_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTINUE_STATEMENT, ValaCCodeContinueStatement))
#define VALA_CCODE_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTINUE_STATEMENT, ValaCCodeContinueStatementClass))
#define VALA_IS_CCODE_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTINUE_STATEMENT))
#define VALA_IS_CCODE_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTINUE_STATEMENT))
#define VALA_CCODE_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTINUE_STATEMENT, ValaCCodeContinueStatementClass))

typedef struct _ValaCCodeContinueStatement ValaCCodeContinueStatement;
typedef struct _ValaCCodeContinueStatementClass ValaCCodeContinueStatementClass;

#define VALA_TYPE_CCODE_BREAK_STATEMENT (vala_ccode_break_statement_get_type ())
#define VALA_CCODE_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BREAK_STATEMENT, ValaCCodeBreakStatement))
#define VALA_CCODE_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BREAK_STATEMENT, ValaCCodeBreakStatementClass))
#define VALA_IS_CCODE_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BREAK_STATEMENT))
#define VALA_IS_CCODE_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BREAK_STATEMENT))
#define VALA_CCODE_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BREAK_STATEMENT, ValaCCodeBreakStatementClass))

typedef struct _ValaCCodeBreakStatement ValaCCodeBreakStatement;
typedef struct _ValaCCodeBreakStatementClass ValaCCodeBreakStatementClass;

struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeStatement {
	ValaCCodeNode parent_instance;
	ValaCCodeStatementPrivate * priv;
};

struct _ValaCCodeStatementClass {
	ValaCCodeNodeClass parent_class;
};

struct _ValaCCodeBlock {
	ValaCCodeStatement parent_instance;
	ValaCCodeBlockPrivate * priv;
};

struct _ValaCCodeBlockClass {
	ValaCCodeStatementClass parent_class;
};

struct _ValaCCodeBlockPrivate {
	gboolean _suppress_newline;
	ValaList* statements;
};


static gpointer vala_ccode_block_parent_class = NULL;

gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
void vala_value_take_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
void vala_value_take_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void) G_GNUC_CONST;
GType vala_ccode_statement_get_type (void) G_GNUC_CONST;
GType vala_ccode_block_get_type (void) G_GNUC_CONST;
#define VALA_CCODE_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockPrivate))
enum  {
	VALA_CCODE_BLOCK_DUMMY_PROPERTY
};
void vala_ccode_block_prepend_statement (ValaCCodeBlock* self, ValaCCodeNode* statement);
void vala_ccode_block_add_statement (ValaCCodeBlock* self, ValaCCodeNode* statement);
static void vala_ccode_block_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
void vala_ccode_writer_write_begin_block (ValaCCodeWriter* self);
void vala_ccode_node_write_declaration (ValaCCodeNode* self, ValaCCodeWriter* writer);
GType vala_ccode_label_get_type (void) G_GNUC_CONST;
GType vala_ccode_case_statement_get_type (void) G_GNUC_CONST;
GType vala_ccode_return_statement_get_type (void) G_GNUC_CONST;
GType vala_ccode_goto_statement_get_type (void) G_GNUC_CONST;
GType vala_ccode_continue_statement_get_type (void) G_GNUC_CONST;
GType vala_ccode_break_statement_get_type (void) G_GNUC_CONST;
void vala_ccode_node_write (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_writer_write_end_block (ValaCCodeWriter* self);
gboolean vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
ValaCCodeBlock* vala_ccode_block_new (void);
ValaCCodeBlock* vala_ccode_block_construct (GType object_type);
ValaCCodeStatement* vala_ccode_statement_construct (GType object_type);
void vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self, gboolean value);
static void vala_ccode_block_finalize (ValaCCodeNode* obj);



/**
 * Prepend the specified statement to the list of statements.
 */
void vala_ccode_block_prepend_statement (ValaCCodeBlock* self, ValaCCodeNode* statement) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	vala_list_insert (self->priv->statements, 0, statement);
}


/**
 * Append the specified statement to the list of statements.
 */
void vala_ccode_block_add_statement (ValaCCodeBlock* self, ValaCCodeNode* statement) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	vala_collection_add ((ValaCollection*) self->priv->statements, statement);
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void vala_ccode_block_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeBlock * self;
	ValaCCodeNode* last_statement;
	self = (ValaCCodeBlock*) base;
	g_return_if_fail (writer != NULL);
	last_statement = NULL;
	vala_ccode_writer_write_begin_block (writer);
	{
		ValaIterator* _statement_it;
		_statement_it = vala_iterable_iterator ((ValaIterable*) self->priv->statements);
		while (TRUE) {
			ValaCCodeNode* statement;
			gboolean _tmp0_ = FALSE;
			if (!vala_iterator_next (_statement_it)) {
				break;
			}
			statement = (ValaCCodeNode*) vala_iterator_get (_statement_it);
			vala_ccode_node_write_declaration (statement, writer);
			if (VALA_IS_CCODE_LABEL (statement)) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = VALA_IS_CCODE_CASE_STATEMENT (statement);
			}
			if (_tmp0_) {
				ValaCCodeNode* _tmp1_;
				last_statement = (_tmp1_ = NULL, _vala_ccode_node_unref0 (last_statement), _tmp1_);
			} else {
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				if (VALA_IS_CCODE_RETURN_STATEMENT (statement)) {
					_tmp4_ = TRUE;
				} else {
					_tmp4_ = VALA_IS_CCODE_GOTO_STATEMENT (statement);
				}
				if (_tmp4_) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = VALA_IS_CCODE_CONTINUE_STATEMENT (statement);
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = VALA_IS_CCODE_BREAK_STATEMENT (statement);
				}
				if (_tmp2_) {
					ValaCCodeNode* _tmp5_;
					last_statement = (_tmp5_ = _vala_ccode_node_ref0 (statement), _vala_ccode_node_unref0 (last_statement), _tmp5_);
				}
			}
			_vala_ccode_node_unref0 (statement);
		}
		_vala_collection_object_unref0 (_statement_it);
	}
	{
		ValaIterator* _statement_it;
		_statement_it = vala_iterable_iterator ((ValaIterable*) self->priv->statements);
		while (TRUE) {
			ValaCCodeNode* statement;
			if (!vala_iterator_next (_statement_it)) {
				break;
			}
			statement = (ValaCCodeNode*) vala_iterator_get (_statement_it);
			vala_ccode_node_write (statement, writer);
			if (statement == last_statement) {
				_vala_ccode_node_unref0 (statement);
				break;
			}
			_vala_ccode_node_unref0 (statement);
		}
		_vala_collection_object_unref0 (_statement_it);
	}
	vala_ccode_writer_write_end_block (writer);
	if (!self->priv->_suppress_newline) {
		vala_ccode_writer_write_newline (writer);
	}
	_vala_ccode_node_unref0 (last_statement);
}


ValaCCodeBlock* vala_ccode_block_construct (GType object_type) {
	ValaCCodeBlock* self = NULL;
	self = (ValaCCodeBlock*) vala_ccode_statement_construct (object_type);
	return self;
}


ValaCCodeBlock* vala_ccode_block_new (void) {
	return vala_ccode_block_construct (VALA_TYPE_CCODE_BLOCK);
}


gboolean vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_suppress_newline;
	return result;
}


void vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_suppress_newline = value;
}


static void vala_ccode_block_class_init (ValaCCodeBlockClass * klass) {
	vala_ccode_block_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_block_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBlockPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_block_real_write;
}


static void vala_ccode_block_instance_init (ValaCCodeBlock * self) {
	self->priv = VALA_CCODE_BLOCK_GET_PRIVATE (self);
	self->priv->statements = (ValaList*) vala_array_list_new (VALA_TYPE_CCODE_NODE, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_block_finalize (ValaCCodeNode* obj) {
	ValaCCodeBlock * self;
	self = VALA_CCODE_BLOCK (obj);
	_vala_collection_object_unref0 (self->priv->statements);
	VALA_CCODE_NODE_CLASS (vala_ccode_block_parent_class)->finalize (obj);
}


/**
 * Represents a C code block.
 */
GType vala_ccode_block_get_type (void) {
	static volatile gsize vala_ccode_block_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBlock), 0, (GInstanceInitFunc) vala_ccode_block_instance_init, NULL };
		GType vala_ccode_block_type_id;
		vala_ccode_block_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeBlock", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_block_type_id__volatile, vala_ccode_block_type_id);
	}
	return vala_ccode_block_type_id__volatile;
}




