/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dita.dost.module.Content;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DitaWriter
extends AbstractWriter
implements ContentHandler,
LexicalHandler {
    private XMLReader reader;
    private OutputStreamWriter output;
    private HashMap counterMap;
    private String filename;
    private String absolutePath;
    private String tempDir;
    private boolean exclude = false;
    private boolean needResolveEntity;
    private Set filterSet;
    private HashMap filterMap = new HashMap();
    private int level;
    private int columnNumber = 0;

    public DitaWriter() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean check(String attName, Attributes atts) {
        String action;
        String value = atts.getValue(attName);
        boolean ret = false;
        if (value == null) {
            return false;
        }
        int index = value.indexOf(32);
        while (index != -1) {
            action = (String)this.filterMap.get(attName + "=" + value.substring(0, index));
            if (action != null && action.equals("exclude")) {
                ret = true;
            } else if (action != null) {
                return false;
            }
            value = value.substring(index + 1);
            index = value.indexOf(32);
        }
        action = (String)this.filterMap.get(attName + "=" + value);
        if (action != null && action.equals("exclude")) {
            ret = true;
        } else if (action != null) {
            return false;
        }
        return ret;
    }

    public void setContent(Content content) {
        this.filterSet = (Set)content.getCollection();
        if (this.filterSet != null) {
            Iterator i = this.filterSet.iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                this.filterMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.tempDir = (String)content.getObject();
    }

    public void write(String filename) {
        this.exclude = false;
        this.needResolveEntity = true;
        System.out.println(filename);
        int index = filename.indexOf(124);
        try {
            File outputFile;
            if (index != -1) {
                this.filename = filename.replace('|', File.separatorChar).replace('/', File.separatorChar).replace('\\', File.separatorChar);
                outputFile = new File(this.tempDir + File.separatorChar + filename.substring(index + 1));
            } else {
                this.filename = filename;
                outputFile = new File(this.tempDir + File.separatorChar + filename);
            }
            this.counterMap = new HashMap();
            File dirFile = outputFile.getParentFile();
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            this.absolutePath = dirFile.getCanonicalPath();
            FileOutputStream fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            if (index != -1) {
                this.reader.parse(this.filename);
            } else {
                this.reader.parse(filename);
            }
            this.output.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        block2: {
            if (this.exclude || !this.needResolveEntity) break block2;
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.exclude) {
            try {
                this.output.write("</" + qName + ">");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        } else if (this.level > 0) {
            --this.level;
        } else {
            this.exclude = false;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        block2: {
            if (this.exclude) break block2;
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        block2: {
            if (this.exclude) break block2;
            try {
                String pi = data != null ? target + " " + data : target;
                this.output.write("<?" + pi + "?>");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
        block2: {
            if (this.exclude) break block2;
            try {
                this.output.write(name);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.output.write(System.getProperty("line.separator"));
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") == -1) {
                this.output.write("<?workdir " + this.absolutePath + "?>");
            } else {
                this.output.write("<?workdir /" + this.absolutePath + "?>");
            }
            this.output.write(System.getProperty("line.separator"));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String nextValue;
        if (this.counterMap.containsKey(qName)) {
            String value = (String)this.counterMap.get(qName);
            nextValue = Integer.toString(Integer.parseInt(value) + 1);
            this.counterMap.put(qName, nextValue);
        } else {
            this.counterMap.put(qName, "1");
            nextValue = "1";
        }
        if (!this.exclude) {
            if (!(this.check("audience", atts) || this.check("platform", atts) || this.check("product", atts) || this.check("otherprops", atts))) {
                try {
                    if (qName.equals("tgroup") || qName.equals("row")) {
                        this.columnNumber = 0;
                    }
                    this.output.write("<" + qName);
                    int i = 0;
                    while (i < atts.getLength()) {
                        String attValue;
                        String attQName = atts.getQName(i);
                        if (attQName.equals("colname")) {
                            ++this.columnNumber;
                            attValue = "col" + Integer.toString(this.columnNumber);
                        } else {
                            attValue = atts.getValue(i);
                        }
                        this.output.write(" " + attQName + "=\"" + attValue + "\"");
                        ++i;
                    }
                    this.output.write(" xtrf=\"" + this.filename + "\"");
                    this.output.write(" xtrc=\"" + qName + ":" + nextValue + "\"");
                    this.output.write(">");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            } else {
                this.exclude = true;
                this.level = 0;
            }
        } else {
            ++this.level;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    public void startCDATA() throws SAXException {
        try {
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
        block3: {
            if (this.exclude) break block3;
            try {
                this.needResolveEntity = StringUtils.checkEntity(name);
                if (!this.needResolveEntity) {
                    this.output.write(StringUtils.getEntity(name));
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

