/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax2.SAXTwoOMBuilder;
import com.jclark.xsl.tr.LoadContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXTwoOMBuilderImpl
implements SAXTwoOMBuilder {
    char[] _dataBuf = new char[1024];
    int _dataBufUsed = 0;
    RootNodeImpl _rootNode = null;
    ContainerNodeImpl _currentNode;
    int _currentIndex = 1;
    boolean _includeProcessingInstructions;
    boolean _includeComments;
    LoadContext _context;
    InputSource _input;
    Locator _locator = new NullLocator();
    Hashtable _pendingNamespaces = new Hashtable();

    SAXTwoOMBuilderImpl() {
    }

    SAXTwoOMBuilderImpl(LoadContext context, String systemId, int documentIndex, NamespacePrefixMap nsMap, InputSource input) {
        this.init(context, systemId, documentIndex, nsMap, input);
    }

    public void init(LoadContext context, String systemId, int documentIndex, NamespacePrefixMap nsMap, InputSource input) {
        this._context = context;
        this._input = input;
        this._includeProcessingInstructions = this._context.getIncludeProcessingInstructions();
        this._includeComments = this._context.getIncludeComments();
        this._rootNode = new RootNodeImpl(systemId, documentIndex, nsMap);
        this._currentNode = this._rootNode;
    }

    public void startDocument() {
        if (this._rootNode.getURL() == null && this._input != null) {
            String newSysId = this._input.getSystemId();
            this._rootNode.setSystemId(newSysId);
        }
    }

    public void endDocument() {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this._pendingNamespaces.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ElementNodeImpl element;
        String havelocator;
        this.flushData();
        String space = atts.getValue("xml:space");
        String string = havelocator = this._locator == null ? "n" : "y";
        boolean preserve = space == null ? this._currentNode.preserveSpace() : (space.equals("default") ? false : (space.equals("preserve") ? true : this._currentNode.preserveSpace()));
        try {
            element = preserve ? new PreserveElementNodeImpl(namespaceURI, qName, atts, this._locator, this._currentIndex++, this._currentNode, this._pendingNamespaces) : new ElementNodeImpl(namespaceURI, qName, atts, this._locator, this._currentIndex++, this._currentNode, this._pendingNamespaces);
        }
        catch (XSLException e) {
            throw new SAXException(e);
        }
        this._currentIndex += atts.getLength();
        this._currentNode = element;
        this._pendingNamespaces.clear();
    }

    public void characters(char[] ch, int start, int length) {
        int need = length + this._dataBufUsed;
        if (need > this._dataBuf.length) {
            int newLength;
            for (newLength = this._dataBuf.length << 1; need > newLength; newLength <<= 1) {
            }
            char[] tem = this._dataBuf;
            this._dataBuf = new char[newLength];
            if (this._dataBufUsed > 0) {
                System.arraycopy(tem, 0, this._dataBuf, 0, this._dataBufUsed);
            }
        }
        while (length > 0) {
            this._dataBuf[this._dataBufUsed++] = ch[start++];
            --length;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this._dataBufUsed > 0 || this._currentNode.preserveSpace() || !this._context.getStripSource(this._currentNode.getName())) {
            this.characters(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localname, String qName) {
        this.flushData();
        this._currentNode = this._currentNode.parent;
    }

    public void skippedEntity(String entityName) {
    }

    public void processingInstruction(String target, String data) {
        if (target == null) {
            this.comment(data);
        } else if (this._includeProcessingInstructions) {
            this.flushData();
            int n = this._currentIndex++;
            new ProcessingInstructionNodeImpl(target, data, this._locator, n, this._currentNode);
        }
    }

    public void comment(String contents) {
        if (this._includeComments) {
            this.flushData();
            int n = this._currentIndex++;
            new CommentNodeImpl(contents, n, this._currentNode);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        this._rootNode.unparsedEntityURITable.put(name, systemId);
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public Node getRootNode() {
        return this._rootNode;
    }

    private static boolean isWhitespace(char[] buf, int len) {
        block3: for (int i = 0; i < len; ++i) {
            switch (buf[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private final void flushData() {
        if (this._dataBufUsed > 0) {
            if (!SAXTwoOMBuilderImpl.isWhitespace(this._dataBuf, this._dataBufUsed) || this._currentNode.preserveSpace() || !this._context.getStripSource(this._currentNode.getName())) {
                int n = this._currentIndex++;
                new TextNodeImpl(this._dataBuf, 0, this._dataBufUsed, n, this._currentNode);
            }
            this._dataBufUsed = 0;
        }
    }

    private static class ProcessingInstructionNodeImpl
    extends NodeImpl {
        private Name name;
        private String data;
        private String systemId;

        public ProcessingInstructionNodeImpl(String name, String data, Locator loc, int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.systemId = loc.getSystemId();
            this.name = parent.getNamespacePrefixMap().getNameTable().createName(name);
            this.data = data;
        }

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 4;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class CommentNodeImpl
    extends NodeImpl {
        private String data;

        public CommentNodeImpl(String data, int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.data = data;
        }

        public byte getType() {
            return 5;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }
    }

    private static class StripTextNodeImpl
    extends TextNodeImpl {
        public StripTextNodeImpl(char[] buf, int off, int len, int index, ContainerNodeImpl parent) {
            super(buf, off, len, index, parent);
        }

        boolean canStrip() {
            return true;
        }
    }

    private static class TextNodeImpl
    extends NodeImpl {
        private String data;

        public TextNodeImpl(char[] buf, int off, int len, int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.data = new String(buf, off, len);
        }

        public byte getType() {
            return 1;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }
    }

    private static class AttributeNodeImpl
    extends NodeImpl {
        private Name name;
        private String value;

        AttributeNodeImpl(int index, ContainerNodeImpl parent, Name name, String value) {
            this.index = index;
            this.parent = parent;
            this.root = parent.root;
            this.name = name;
            this.value = value;
        }

        public byte getType() {
            return 2;
        }

        public String getData() {
            return this.value;
        }

        public Name getName() {
            return this.name;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof AttributeNodeImpl && ((AttributeNodeImpl)obj).index == this.index;
        }
    }

    private static class PreserveElementNodeImpl
    extends ElementNodeImpl {
        PreserveElementNodeImpl(String namespaceURI, String name, Attributes atts, Locator loc, int index, ContainerNodeImpl parent, Hashtable namespaces) throws XSLException {
            super(namespaceURI, name, atts, loc, index, parent, namespaces);
        }

        boolean preserveSpace() {
            return true;
        }
    }

    private static class ElementNodeImpl
    extends ContainerNodeImpl {
        private Name name;
        private Object[] atts;
        private int lineNumber;
        private String systemId;

        ElementNodeImpl(String namespaceURI, String name, Attributes attList, Locator loc, int index, ContainerNodeImpl parent, Hashtable namespaces) throws XSLException {
            super(index, parent);
            int pix;
            this.lineNumber = loc.getLineNumber();
            this.systemId = loc.getSystemId();
            int nAtts = attList.getLength();
            if (namespaces.size() > 0) {
                Enumeration keys = namespaces.keys();
                while (keys.hasMoreElements()) {
                    String prefix = (String)keys.nextElement();
                    String ns = (String)namespaces.get(prefix);
                    if (prefix.length() == 0) {
                        if (ns.length() == 0) {
                            this.nsMap = this.nsMap.unbindDefault();
                            continue;
                        }
                        this.nsMap = this.nsMap.bindDefault(ns);
                        continue;
                    }
                    if ("xmlns".equals(prefix)) {
                        throw new XSLException("atttempting to bind xmlns");
                    }
                    this.nsMap = this.nsMap.bind(prefix, (String)namespaces.get(prefix));
                }
            }
            if (nAtts > 0) {
                int nNsAtts = 0;
                for (int i = 0; i < nAtts; ++i) {
                    String tem = attList.getQName(i);
                    if (!tem.startsWith("xmlns")) continue;
                    ++nNsAtts;
                    if (tem.length() == 5) {
                        String ns = attList.getValue(i);
                        if (ns.length() == 0) {
                            this.nsMap = this.nsMap.unbindDefault();
                            continue;
                        }
                        this.nsMap = this.nsMap.bindDefault(ns);
                        continue;
                    }
                    if (tem.charAt(5) != ':') continue;
                    if ("xmlns".equals(tem.substring(6))) {
                        throw new XSLException("atttempting to bind xmlns 2");
                    }
                    this.nsMap = this.nsMap.bind(tem.substring(6), attList.getValue(i));
                }
                int n = nAtts - nNsAtts;
                if (n > 0) {
                    Object[] vec = new Object[n * 2];
                    int j = 0;
                    for (int i = 0; i < nAtts; ++i) {
                        String tem = attList.getQName(i);
                        if (!tem.startsWith("xmlns")) {
                            String namespace = attList.getURI(i);
                            int pix2 = tem.indexOf(58);
                            if (pix2 == -1) {
                                if (namespace.length() > 0) {
                                    this.nsMap = this.nsMap.bindDefault(namespace);
                                }
                            } else if (pix2 != 3 || !tem.regionMatches(0, "xml", 0, 3)) {
                                this.nsMap = this.nsMap.bind(tem.substring(0, pix2), namespace);
                            }
                            vec[j++] = this.nsMap.expandAttributeName(tem, this);
                            vec[j++] = attList.getValue(i);
                        }
                        if (attList.getType(i) == null || attList.getType(i).length() != 2) continue;
                        parent.addId(attList.getValue(i), this);
                    }
                    this.atts = vec;
                }
            }
            if ((pix = name.indexOf(58)) == -1) {
                if (namespaceURI != null && namespaceURI.length() > 0) {
                    this.nsMap = this.nsMap.bindDefault(namespaceURI);
                }
            } else if (pix != 3 || !name.regionMatches(0, "xml", 0, 3)) {
                this.nsMap = this.nsMap.bind(name.substring(0, pix), namespaceURI);
            }
            this.name = this.nsMap.expandElementTypeName(name, this);
        }

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 0;
        }

        public SafeNodeIterator getAttributes() {
            return new SafeNodeIterator(this){
                private int i;
                private final /* synthetic */ ElementNodeImpl this$0;
                {
                    this.this$0 = this$0;
                    this.i = 0;
                }

                public Node next() {
                    if (ElementNodeImpl.access$200(this.this$0) == null) {
                        return null;
                    }
                    int i2 = this.i * 2;
                    if (i2 == ElementNodeImpl.access$200(this.this$0).length) {
                        return null;
                    }
                    return new AttributeNodeImpl(this.this$0.index + ++this.i, this.this$0, (Name)ElementNodeImpl.access$200(this.this$0)[i2], (String)ElementNodeImpl.access$200(this.this$0)[i2 + 1]);
                }
            };
        }

        public SafeNodeIterator getNamespaces() {
            return new NamespaceNodeIterator(this.getNamespacePrefixMap(), this);
        }

        public Node getAttribute(Name name) {
            if (this.atts != null) {
                for (int i = 0; i < this.atts.length; i += 2) {
                    if (!this.atts[i].equals(name)) continue;
                    return new AttributeNodeImpl(this.index + (i >> 1) + 1, this, name, (String)this.atts[i + 1]);
                }
            }
            return null;
        }

        public String getAttributeValue(Name name) {
            if (this.atts != null) {
                for (int i = 0; i < this.atts.length; i += 2) {
                    if (!this.atts[i].equals(name)) continue;
                    return (String)this.atts[i + 1];
                }
            }
            return null;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public boolean isId(String name) {
            return this.equals(this.getElementWithId(name));
        }

        static /* synthetic */ Object[] access$200(ElementNodeImpl x0) {
            return x0.atts;
        }
    }

    private static class NullLocator
    implements Locator {
        private NullLocator() {
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }
    }

    private static class RootNodeImpl
    extends ContainerNodeImpl {
        private String systemId;
        private int documentIndex;
        private Hashtable idTable = new Hashtable();
        private Hashtable unparsedEntityURITable = new Hashtable();

        RootNodeImpl(String systemId, int documentIndex, NamespacePrefixMap nsMap) {
            super(nsMap);
            this.systemId = systemId;
            this.documentIndex = documentIndex;
            this.root = this;
        }

        public byte getType() {
            return 3;
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void setSystemId(String sysId) {
            this.systemId = sysId;
        }

        public int getLineNumber() {
            return 1;
        }

        public Node getElementWithId(String name) {
            return (Node)this.idTable.get(name);
        }

        void addId(String id, NodeImpl node) {
            if (this.idTable.get(id) == null) {
                this.idTable.put(id, node);
            }
        }

        public String getUnparsedEntityURI(String name) {
            return (String)this.unparsedEntityURITable.get(name);
        }

        int compareRootTo(RootNodeImpl r) {
            if (this.systemId == null) {
                if (r.systemId == null) {
                    return this.documentIndex - r.documentIndex;
                }
                return -1;
            }
            if (r.systemId == null) {
                return 1;
            }
            int n = this.systemId.compareTo(r.systemId);
            if (n != 0) {
                return n;
            }
            return this.documentIndex - r.documentIndex;
        }

        int getDocumentIndex() {
            return this.documentIndex;
        }
    }

    private static abstract class ContainerNodeImpl
    extends NodeImpl {
        NodeImpl firstChild;
        NodeImpl lastChild;
        NamespacePrefixMap nsMap;

        ContainerNodeImpl(NamespacePrefixMap nsMap) {
            this.nsMap = nsMap;
        }

        ContainerNodeImpl(int index, ContainerNodeImpl parent) {
            super(index, parent);
            this.nsMap = parent.nsMap;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(this.firstChild);
        }

        public String getData() {
            return null;
        }

        boolean preserveSpace() {
            return false;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.nsMap;
        }

        void addId(String id, NodeImpl node) {
            this.parent.addId(id, node);
        }
    }

    private static class NamespaceNode
    extends NodeImpl {
        String _prefix;
        String _uri;

        public byte getType() {
            return 6;
        }

        NamespaceNode(String prefix, String uri, ContainerNodeImpl parent) {
            this._prefix = prefix;
            this._uri = uri;
            this.parent = parent;
        }

        public Name getName() {
            return new Name(){

                public String getNamespace() {
                    return null;
                }

                public String getLocalPart() {
                    return _prefix;
                }

                public String getPrefix() {
                    return null;
                }

                public Object getCreator() {
                    return null;
                }

                public String toString() {
                    return _prefix;
                }
            };
        }

        public String getData() {
            return this._uri;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }
    }

    private static class NamespaceNodeIterator
    implements SafeNodeIterator {
        private NamespacePrefixMap _namespaces;
        private int _index = 0;
        private ContainerNodeImpl _parent;

        NamespaceNodeIterator(NamespacePrefixMap map, ContainerNodeImpl parent) {
            this._namespaces = map;
            this._parent = parent;
            this._index = map.getSize();
        }

        public Node next() {
            NamespaceNode ns = null;
            if (this._index > 0) {
                --this._index;
                ns = new NamespaceNode(this._namespaces.getPrefix(this._index), this._namespaces.getNamespace(this._index), this._parent);
            }
            return ns;
        }
    }

    private static class NodeIteratorImpl
    implements SafeNodeIterator {
        private NodeImpl nextNode;

        NodeIteratorImpl(NodeImpl nextNode) {
            this.nextNode = nextNode;
        }

        public Node next() {
            NodeImpl tem = this.nextNode;
            if (tem != null) {
                this.nextNode = tem.nextSibling;
            }
            return tem;
        }
    }

    private static abstract class NodeImpl
    implements Node {
        ContainerNodeImpl parent;
        RootNodeImpl root;
        int index;
        NodeImpl nextSibling;

        NodeImpl() {
            this.index = 0;
            this.parent = null;
            this.nextSibling = null;
        }

        NodeImpl(int index, ContainerNodeImpl parent) {
            this.index = index;
            this.parent = parent;
            this.root = parent.root;
            this.nextSibling = null;
            if (parent.lastChild == null) {
                parent.firstChild = parent.lastChild = this;
            } else {
                parent.lastChild.nextSibling = this;
                parent.lastChild = this;
            }
        }

        public Node getParent() {
            return this.parent;
        }

        public SafeNodeIterator getFollowingSiblings() {
            return new NodeIteratorImpl(this.nextSibling);
        }

        public URL getURL() {
            return this.parent.getURL();
        }

        boolean canStrip() {
            return false;
        }

        public Node getAttribute(Name name) {
            return null;
        }

        public String getAttributeValue(Name name) {
            return null;
        }

        public SafeNodeIterator getAttributes() {
            return new NodeIteratorImpl(null);
        }

        public SafeNodeIterator getNamespaces() {
            return new NodeIteratorImpl(null);
        }

        public Name getName() {
            return null;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.parent.nsMap;
        }

        public int compareTo(Node node) {
            NodeImpl ni = (NodeImpl)node;
            if (this.root == ni.root) {
                return this.index - ((NodeImpl)node).index;
            }
            return this.root.compareRootTo(ni.root);
        }

        public Node getElementWithId(String name) {
            return this.root.getElementWithId(name);
        }

        public String getUnparsedEntityURI(String name) {
            return this.root.getUnparsedEntityURI(name);
        }

        public boolean isId(String name) {
            return false;
        }

        public String getGeneratedId() {
            int d = this.root.getDocumentIndex();
            if (d == 0) {
                return "N" + String.valueOf(this.index);
            }
            return "N" + String.valueOf(d) + "_" + String.valueOf(this.index);
        }

        public Node getRoot() {
            return this.root;
        }

        public int getLineNumber() {
            return this.parent.getLineNumber();
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId() {
            return this.getURL().toString();
        }

        public String getPublicId() {
            return null;
        }
    }
}

