/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.expr.CloneableNodeIteratorImpl;
import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

abstract class Relation {
    Relation() {
    }

    abstract boolean relate(String var1, String var2);

    abstract boolean relate(boolean var1, boolean var2);

    abstract boolean relate(double var1, double var3);

    boolean relate(NodeIterator iter1, NodeIterator iter2) throws XSLException {
        Node node1;
        if (!(iter2 instanceof CloneableNodeIterator)) {
            iter2 = new CloneableNodeIteratorImpl(iter2);
        }
        while ((node1 = iter1.next()) != null) {
            Node node2;
            String s1 = Converter.toString(node1);
            NodeIterator tem = (NodeIterator)((CloneableNodeIterator)iter2).clone();
            while ((node2 = tem.next()) != null) {
                if (!this.relate(s1, Converter.toString(node2))) continue;
                return true;
            }
        }
        return false;
    }

    boolean relate(NodeIterator iter, boolean b) throws XSLException {
        return this.relate(iter.next() != null, b);
    }

    boolean relate(NodeIterator iter, double d) throws XSLException {
        Node node;
        while ((node = iter.next()) != null) {
            if (!this.relate(Converter.toNumber(Converter.toString(node)), d)) continue;
            return true;
        }
        return false;
    }

    boolean relate(NodeIterator iter, String s) throws XSLException {
        Node node;
        while ((node = iter.next()) != null) {
            if (!this.relate(Converter.toString(node), s)) continue;
            return true;
        }
        return false;
    }

    boolean relate(boolean b, NodeIterator iter) throws XSLException {
        return this.relate(b, iter.next() != null);
    }

    boolean relate(double d, NodeIterator iter) throws XSLException {
        Node node;
        while ((node = iter.next()) != null) {
            if (!this.relate(d, Converter.toNumber(Converter.toString(node)))) continue;
            return true;
        }
        return false;
    }

    boolean relate(String s, NodeIterator iter) throws XSLException {
        Node node;
        while ((node = iter.next()) != null) {
            if (!this.relate(s, Converter.toString(node))) continue;
            return true;
        }
        return false;
    }

    boolean relate(Variant obj1, Variant obj2) throws XSLException {
        if (obj1.isNodeSet()) {
            if (obj2.isNodeSet()) {
                return this.relate(obj1.convertToNodeSet(), obj2.convertToNodeSet());
            }
            if (obj2.isNumber()) {
                return this.relate(obj1.convertToNodeSet(), obj2.convertToNumber());
            }
            if (obj2.isBoolean()) {
                return this.relate(obj1.convertToNodeSet(), obj2.convertToBoolean());
            }
            return this.relate(obj1.convertToNodeSet(), obj2.convertToString());
        }
        if (obj2.isNodeSet()) {
            if (obj1.isNumber()) {
                return this.relate(obj1.convertToNumber(), obj2.convertToNodeSet());
            }
            if (obj1.isBoolean()) {
                return this.relate(obj1.convertToBoolean(), obj2.convertToNodeSet());
            }
            return this.relate(obj1.convertToString(), obj2.convertToNodeSet());
        }
        return this.relateAtomic(obj1, obj2);
    }

    boolean relateAtomic(Variant obj1, Variant obj2) throws XSLException {
        if (obj1.isBoolean() || obj2.isBoolean()) {
            return this.relate(obj1.convertToBoolean(), obj2.convertToBoolean());
        }
        if (obj1.isNumber() || obj2.isNumber()) {
            return this.relate(obj1.convertToNumber(), obj2.convertToNumber());
        }
        return this.relate(obj1.convertToString(), obj2.convertToString());
    }
}

