/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.DOMExtensions;
import com.jclark.xsl.dom.ElementNode;
import com.jclark.xsl.dom.NullNodeIterator;
import com.jclark.xsl.dom.SiblingNodeIterator;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.tr.LoadContext;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;

class RootNode
extends ContainerNode {
    private Document document;
    Document ownerDocument;
    private NamedNodeMap entities;
    private DOMExtensions extend;
    NameTable nameTable;
    int documentIndex;
    URL baseURL;
    LoadContext loadContext;
    boolean includeComments;
    boolean includeProcessingInstructions;

    RootNode(org.w3c.dom.Node node, DOMExtensions extend, LoadContext loadContext, NameTable nameTable, String baseURL, int documentIndex) {
        super(node);
        this.extend = extend;
        this.nameTable = nameTable;
        this.parent = null;
        this.root = this;
        this.prefixMap = nameTable.getEmptyNamespacePrefixMap();
        this.loadContext = loadContext;
        this.includeProcessingInstructions = loadContext.getIncludeProcessingInstructions();
        this.includeComments = loadContext.getIncludeComments();
        try {
            this.baseURL = new URL(baseURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (node.getNodeType() == 9) {
            this.ownerDocument = this.document = (Document)node;
            DocumentType doctype = this.document.getDoctype();
            if (doctype != null) {
                this.entities = doctype.getEntities();
            }
        } else {
            this.ownerDocument = node.getOwnerDocument();
        }
    }

    int compareRootTo(RootNode node) {
        return this.documentIndex - node.documentIndex;
    }

    public byte getType() {
        return 3;
    }

    public URL getURL() {
        return this.baseURL;
    }

    public String getUnparsedEntityURI(String name) {
        if (this.entities == null) {
            return null;
        }
        Entity entity = (Entity)this.entities.getNamedItem(name);
        if (entity == null || entity.getNotationName() == null) {
            return null;
        }
        String systemId = entity.getSystemId();
        try {
            return new URL(this.baseURL, systemId).toString();
        }
        catch (MalformedURLException e) {
            return systemId;
        }
    }

    boolean isId(org.w3c.dom.Node node, String id) {
        if (this.document == null) {
            return false;
        }
        return node.equals(this.extend.getElementById(this.document, id));
    }

    public Node getElementWithId(String id) {
        if (this.document == null) {
            return null;
        }
        Element node = this.extend.getElementById(this.document, id);
        if (node == null) {
            return null;
        }
        return this.createElement(node);
    }

    private ContainerNode createElement(org.w3c.dom.Node node) {
        org.w3c.dom.Node domParent = node.getParentNode();
        while (domParent.getNodeType() == 5) {
            domParent = domParent.getParentNode();
        }
        ContainerNode tem = domParent.equals(this.domNode) ? this : this.createElement(domParent);
        return new ElementNode(node, tem, SiblingNodeIterator.computeChildIndex(tem, node));
    }

    public String getGeneratedId() {
        return "N" + Integer.toString(this.documentIndex);
    }

    public SafeNodeIterator getFollowingSiblings() {
        return NullNodeIterator.getInstance();
    }
}

