/*
 *  @(#)IChainableException.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.util.throwable.v1;


import java.io.PrintStream;
import java.io.PrintWriter;


/**
 * Marker interface to tell the <tt>ChainableExceptionHelper</tt> not to use
 * this class's getCause method.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:38 $
 * @since      July 7, 2002
 */
public interface IChainableException
{
    // list all methods that must be re-implemented in the exception.
    
    /**
     * JDK 1.4 compatible method.
     * <P>
     * <i>from the JDK 1.4 documentation:</i>
     * <BLOCKQUOTE>
     * Returns the cause of this throwable or <tt>null</tt> if the cause is
     * nonexistent or unknown. (The cause is the throwable that caused this
     * throwable to get thrown.)
     * <P>
     * This implementation returns the cause that was supplied via one of the
     * constructors requiring a <tt>Throwable</tt>, or that was set after
     * creation with the <tt>initCause( Throwable )</tt> method. While it is
     * typically unnecessary to override this method, a subclass can override
     * it to return a cause set by some other means. This is appropriate for a
     * "legacy chained throwable" that predates the addition of chained
     * exceptions to <tt>Throwable</tt>. Note that it is not necessary to
     * override any of the <tt>PrintStackTrace</tt> methods, all of which
     * invoke the getCause method to determine the cause of a throwable.
     * </BLOCKQUOTE>
     *
     * @return the cause of this throwable or <tt>null</tt> if the cause is
     *      nonexistent or unknown.
     */
    public Throwable getCause();
    
    
    /**
     * JDK 1.4 compatible method.
     * <P>
     * <i>from the JDK 1.4 documentation:</i>
     * <BLOCKQUOTE>
     * Initializes the cause of this throwable to the specified value.
     * (The cause is the throwable that caused this throwable to get thrown.)
     * <P>
     * This method can be called at most once. It is generally called from
     * within the constructor, or immediately after creating the throwable.
     * If this throwable was created with Throwable(Throwable) or
     * Throwable(String,Throwable), this method cannot be called even once.
     * </BLOCKQUOTE>
     *
     * @param cause the cause (which is saved for later retrieval by the
     *      getCause() method). (A null value is permitted, and indicates
     *      that the cause is nonexistent or unknown.)
     * @return a reference to this Throwable instance.
     * @exception IllegalArgumentException if cause is this throwable.
     *      (A throwable cannot be its own cause.)
     * @exception IllegalStateException if this throwable was created with
     *      Throwable(Throwable) or Throwable(String,Throwable), or this
     *      method has already been called on this throwable.
     */
    public Throwable initCause( Throwable cause );
    
    
    /**
     * For non-JDK 1.4 compatible VMs, this overrides the original behavior
     * to describe the underlying cause.  Special logic is performed to ensure
     * that no JDK 1.4 VM is being used when the inner exception is displayed
     * (in order to prevent double printing).
     */
    public void printStackTrace( PrintStream ps );
    
    
    
    /**
     * For non-JDK 1.4 compatible VMs, this overrides the original behavior
     * to describe the underlying cause.  Special logic is performed to ensure
     * that no JDK 1.4 VM is being used when the inner exception is displayed
     * (in order to prevent double printing).
     */
    public void printStackTrace( PrintWriter pw );
}

