/*
 * @(#)CaptureEventIUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1.event;

import java.awt.Robot;
import java.awt.Component;
import java.awt.Button;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the CaptureEvent class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     Jan 6, 2002
 * @version   $Date: 2003/02/10 22:52:33 $
 */
public class CaptureEventIUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = CaptureEventIUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public CaptureEventIUTest( String name )
    {
        super( name );
    }



    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testNoEventConstructor()
    {
        CaptureEvent ce = createCaptureEvent();
        assertEquals(
            "Null event in creation must have null event returned.",
            ce.getInputEvent(),
            null );
        assertEquals(
            "Must return the passed-in event type.",
            ce.getEventType(),
            this.eventType );
        assertEquals(
            "Must not have a valid time of event.",
            ce.getTimeOfEvent(),
            -1 );
    }
    
    public void testNullEventConstructor()
    {
        InputEvent ie = null;
        CaptureEvent ce = createCaptureEvent( ie );
        assertEquals(
            "Event passed in creation must be the same event returned.",
            ce.getInputEvent(),
            ie );
        assertEquals(
            "Must return the passed-in event type.",
            ce.getEventType(),
            this.eventType );
        assertEquals(
            "Must not have a valid time of event.",
            ce.getTimeOfEvent(),
            -1 );
    }
    
    public void testEventConstructor()
    {
        InputEvent ie = createInputEvent();
        CaptureEvent ce = createCaptureEvent( ie );
        assertEquals(
            "Event passed in creation must be the same event returned.",
            ce.getInputEvent(),
            ie );
        assertEquals(
            "Must return the passed-in event type.",
            ce.getEventType(),
            this.eventType );
        assertEquals(
            "Must not have a valid time of event.",
            ce.getTimeOfEvent(),
            ie.getWhen() );
    }
    
    
    
    protected int eventType = -3;
    protected CaptureEvent createCaptureEvent( InputEvent ie )
    {
        return new CaptureEvent( this.eventType, ie ) {
                public void performEvent( Robot r )
                {
                    // do nothing
                }
            };
    }
    protected CaptureEvent createCaptureEvent()
    {
        return new CaptureEvent( this.eventType ) {
                public void performEvent( Robot r )
                {
                    // do nothing
                }
            };
    }
    protected InputEvent createInputEvent()
    {
        return new KeyEvent( createComponent(), 1, 2L, 0, KeyEvent.VK_S );
    }
    protected Component createComponent()
    {
        return new Button();
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

