/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "description.h"

using namespace Form;

Description::Description()
{
}

Description::~Description()
{
}

Description::Entry::List Description::entries() const
{
  return Entry::List();
}

Description::Entry::Entry( Type type )
  : mEntryType( type )
{
}

void Description::Entry::setName( const QString &name )
{
  mName = name;
}

QString Description::Entry::name() const
{
  return mName;
}

void Description::Entry::setType( const QString &type )
{
  mType = type;
}

QString Description::Entry::type() const
{
  return mType;
}

void Description::Entry::setValidator( const QString &validator )
{
  mValidator = validator;
}

QString Description::Entry::validator() const
{
  return mValidator;
}

void Description::Entry::setLabel( const QString &label )
{
  mLabel = label;
}

QString Description::Entry::label() const
{
  return mLabel;
}

void Description::Entry::setHeader( const QString &header )
{
  mHeader = header;
}

QString Description::Entry::header() const
{
  return mHeader;
}

void Description::Entry::setComment( const QString &comment )
{
  mComment = comment;
}

QString Description::Entry::comment() const
{
  return mComment;
}

void Description::Entry::setDefaultValue( const QString &value )
{
  mDefaultValue = value;
}

QString Description::Entry::defaultValue() const
{
  return mDefaultValue;
}

bool Description::Entry::isGroup() const
{
  return ( mEntryType == GroupType );
}

