/* WorksheetWindowMenuHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.main;

import javax.swing.JMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import org.grinvin.worksheet.WorksheetWindow;
import org.grinvin.worksheet.WorksheetWindowListModel;
import org.grinvin.main.actions.ActivateWindow;

/**
 * Handles the dynamic menu of currently available worksheet windows
 */
public class WorksheetWindowMenuHandler implements ListDataListener {

    //
    private WorksheetWindowListModel model;
    //
    private final JMenu menu;
    //
    private final int originalCount;

    public WorksheetWindowMenuHandler(JMenu menu) {
        this.menu = menu;
        this.originalCount = menu.getMenuComponentCount();
    }

    private void rebuildGroupContent() {

        // remove current window list menu items
        for (int count = menu.getMenuComponentCount() - 1; count >= originalCount; count--) {
            menu.remove(count);
        }

        // voeg (nieuwe) acties toe voor elk bestaand venster
        if (model != null && model.size() > 0) {
            menu.addSeparator();

            for (WorksheetWindow w : model) {
                menu.add(new ActivateWindow(w));
            }
        }
    }

    public void setWorksheetWindowListModel(WorksheetWindowListModel newModel) {
        if (model != null) {
            model.removeListDataListener(this);
        }
        model = newModel;
        if (model != null) {
            model.addListDataListener(this);
        }
        rebuildGroupContent();
    }

    public void intervalAdded(ListDataEvent e) {
        rebuildGroupContent();
    }

    public void intervalRemoved(ListDataEvent e) {
        rebuildGroupContent();
    }

    public void contentsChanged(ListDataEvent e) {
        rebuildGroupContent();
    }
}
