/* ListOfIntegersValue.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.values;

import java.util.ResourceBundle;

import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantType;

/**
 * Represents an invariant which is a list of integers.
 */
public class ListOfIntegersValue extends AbstractInvariantValue {
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.invariants.resources";
    
    //
    private int[] values;
    
    //
    public ListOfIntegersValue(int[] values, InvariantComputer computer) {
        super(InvariantType.LISTOFINTEGERS, computer);
        this.values = values;
    }
    
    //
    ListOfIntegersValue(int[] values, Invariant invariant, String computerId, String computerVersion) {
        super(InvariantType.LISTOFINTEGERS, invariant, computerId, computerVersion);
        this.values = values;
    }
    
    //
    public int[] getValues() {
        return values;
    }
    
    //
    public String toText() {
        if (values.length == 0)
            return ResourceBundle.getBundle(BUNDLE_NAME).getString("empty");
        else {
            StringBuilder sb = new StringBuilder(Integer.toString(values[0]));
            for (int i=1; i < values.length; i++) {
                sb.append(", ");
                sb.append(Integer.toString(values[i]));
            }
            return sb.toString();
        }
    }
    
}
