/* GraphFactoryMap.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.grinvin.factories.FactoryManager;
import org.grinvin.factories.graphs.GraphFactory;

/**
 * Provides the mapping of the context-sensitive help ID of graphfactories and
 * the URL for their help page.
 */
public class GraphFactoryMap extends DefaultMap {
    
    private static final GraphFactoryMap SINGLETON = new GraphFactoryMap();
    
    public static GraphFactoryMap getInstance() {
        return SINGLETON;
    }
    
    /**
     * Maps an graph factory identifier to the corresponding name of the graph factory.
     */
    private final java.util.Map<String, String> graphfactorynames;
    
    public String getGraphFactoryNameForID(String id) {
        return graphfactorynames.get(id);
    }
    
    private GraphFactoryMap(){
        List<String> graphfactoryids = new ArrayList<String>();
        graphfactorynames = new HashMap<String, String>();
        for (String id: FactoryManager.getGraphFactoryBroker().getIds()) {
            GraphFactory factory = FactoryManager.getGraphFactoryBroker().get(id);
            graphfactoryids.add(id);
            graphfactorynames.put(id, factory.getLongName());
        }
        setIDList(graphfactoryids);
        setURLPrefix("graphfactory:");
    }
}
