/* GraphPropertiesComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import org.grinvin.graphs.GraphURI;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.GraphPropertiesTableModel;

/**
 * Displays a graph element and its properties in a single panel.
 */
public class GraphPropertiesComponent extends JPanel {
    
    // component displaying the graph and its name.
    private GraphComponent graphComponent;
    
    //
    private JSplitPane splitPane;
    
    // model for the table of properties
    private GraphPropertiesTableModel model;
    
    // cached
    private GraphListElement element;
    
    /** Default constructor */
    public GraphPropertiesComponent() {
        super(new BorderLayout(0, 12));

        graphComponent = new NamedGraphComponent();
        element = null;
        model = new GraphPropertiesTableModel(null);
        GraphPropertiesTableComponent table = new GraphPropertiesTableComponent(model);
        
        splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, false);  //TODO: maybe change to true
        splitPane.setLeftComponent(graphComponent);
        splitPane.setRightComponent(new JScrollPane(table));
        add(splitPane);
        splitPane.setOpaque(true);
        splitPane.setVisible(false);
    }
    
    /**
     * Display information for the given element.
     */
    public void setElement(GraphListElement element) {
        if (element == this.element) {
            return;
        } else {
            this.element = element;
        }
        if (element == null) {
            splitPane.setVisible(false);
            splitPane.setBackground(Color.WHITE); // TODO: use standard background color
        } else {
            graphComponent.setElement(element);
            splitPane.setVisible(true);
            splitPane.setBackground(GraphURI.getType(element.getURI()).getIconBackgroundColor());
        }
        model.setElement(element);
        revalidate();
    }
    
    public void setDividerLocation(int location){
        splitPane.setDividerLocation(location);
    }
    
    public int getDividerLocation(){
        return splitPane.getDividerLocation();
    }
}
