/* InvariantListGeneratorSink.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.generators.graphs;

import java.util.ArrayList;
import java.util.List;

import org.grinvin.graphs.GraphBundle;
import org.grinvin.graphs.LightweightGraphBundle;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantManager;
import org.grinvin.invariants.InvariantValue;

/**
 * Graph generator sink which computes invariants for all graph bundles handed
 * to it.
 */
public class InvariantListGeneratorSink implements GraphGeneratorSink {
    
    //
    protected final List<InvariantValue[]> result;
    
    /**
     * Return the results of computing all invariants.
     */
    public List<InvariantValue[]> getListOfInvariantValues() {
        return result;
    }
    
    //
    protected final InvariantComputer[] computers;
    
    /**
     * Create a sink which computes the values of all given invariants
     * for all graph bundles handed to it.
     */
    public InvariantListGeneratorSink(Invariant[] invariants) {
        result = new ArrayList<InvariantValue[]>();
        int count = invariants.length;
        this.computers = new InvariantComputer[count];
        for (int i = 0; i < count; i++) {
            computers[i] = InvariantManager.getInstance().getInvariantComputerFor(invariants[i]);
        }
    }
    
    public GraphBundle createGraphBundle() {
        return new LightweightGraphBundle();
    }
    
    public void receiveGraphBundle(GraphBundle bundle) {
        int count = computers.length;
        InvariantValue[] values = new InvariantValue[count];
        try {
            for (int i = 0; i < count; i++){
                values[i] = computers[i].compute(bundle);
            }
            result.add(values);
        } catch (Exception ex) {
            // TODO: implement this
            // ignored for now
        }
    }
    
}
