/*
  File: sshcipher.h

  Authors:
        Tero T Mononen <tmo@ssh.fi>

  Description:


  Copyright:
        Copyright (c) 2000 SSH Communications Security Corp, Finland.
        All rights reserved.
*/


#ifndef SSHCRYPTI_H
#define SSHCRYPTI_H

/* Definition structure for cipher functions. */
typedef struct SshCipherDefRec
{
  const char *name;

  /* Block length is 1 for stream ciphers. */
  size_t block_length;

  /* Key length is 0 if supports any length. XXX this is adequate for
     most uses but possibly not suitable always. Might be better to
     have some fixed sized versions of the cipher, rather than
     variable length key version. */
  size_t key_length;
  size_t (*ctxsize)(void);

  /* Basic initialization without explicit key checks. */
  Boolean (*init)(void *context, const unsigned char *key,
                  size_t keylen, Boolean for_encryption);
  /* Initialization with key checks. */
  Boolean (*init_with_check)(void *context, const unsigned char *key,
                             size_t keylen, Boolean for_encryption);

  /* encryption and decryption. If src == dest, then this works
     inplace. */
  void (*transform)(void *context, unsigned char *dest,
                    const unsigned char *src, size_t len,
                    unsigned char *iv);

} *SshCipherDef, SshCipherDefStruct;

#endif /* SSHCRYPTI_H */
