/*
    Author: Mika Kojo <mkojo@ssh.fi>

    Copyright (C) 1996-2002 SSH Communications Security Oy, Espoo, Finland
    All rights reserved.

    Created: Mon Oct 28 06:41:24 1996 [mkojo]

    */

/*
 * $Id: genciph.c,v 1.4 2002/04/09 17:03:34 sjl Exp $
 * $Log: genciph.c,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */


#include "sshincludes.h"
#include "sshcrypt.h"
#include "sshcipher.h"
#include "sshbuffer.h"
#include "nociph.h"

#include "sshhash/sshhash.h"

#ifdef SSHDIST_CRYPT_MD5
#include "sshhash/md5.h"
#endif /* SSHDIST_CRYPT_MD5 */

#ifdef SSHDIST_CRYPT_SHA
#include "sshhash/sha.h"
#endif /* SSHDIST_CRYPT_SHA */

#ifdef SSHDIST_CRYPT_DES
#include "des.h"
#endif /* SSHDIST_CRYPT_DES */

#ifdef SSHDIST_CRYPT_BLOWFISH
#include "blowfish.h"
#endif /* SSHDIST_CRYPT_BLOWFISH */

#ifdef SSHDIST_CRYPT_CAST
#include "cast.h"
#endif /* SSHDIST_CRYPT_CAST */







#ifdef SSHDIST_CRYPT_TWOFISH
#include "twofish.h"
#endif /* SSHDIST_CRYPT_TWOFISH */

















#ifdef SSHDIST_CRYPT_RIJNDAEL
#include "rijndael.h"
#endif /* SSHDIST_CRYPT_RIJNDAEL */





#ifndef KERNEL
/* These ciphers can only be used in user-mode code, not in the kernel.
   To add a cipher to be used in the kernel, you must add its object
   file to CRYPT_LNOBJS in src/ipsec/engine/Makefile.am, and move it
   outside the #ifndef KERNEL directive both here and later in this file. */

#ifdef SSHDIST_CRYPT_ARCFOUR
#include "arcfour.h"
#endif /* SSHDIST_CRYPT_ARCFOUR */













#endif /* !KERNEL */

#define SSH_DEBUG_MODULE "SshGenCiph"

/* Algorithm definitions */
/* XXX Remove ifdef's for SSHDIST_SSH2, and make a mapping in the ssh2
   protocol library instead. This stuff was committed because there was
   no time for extensive changes before ssh-3.2.0 release. //sjl */
static const SshCipherDefStruct ssh_cipher_algorithms[] =
{
#ifdef SSHDIST_CRYPT_DES









#ifdef SSHDIST_SSH2
  { "3des-cbc", 8, 24, ssh_des3_ctxsize, ssh_des3_init,
    ssh_des3_init_with_key_check, ssh_des3_cbc },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_DES */

#ifdef SSHDIST_CRYPT_RIJNDAEL


















#ifdef SSHDIST_SSH2
  { "aes256-cbc", 16, 32, ssh_rijndael_ctxsize, ssh_rijndael_init,
    ssh_rijndael_init, ssh_rijndael_cbc },
  { "aes192-cbc", 16, 24, ssh_rijndael_ctxsize, ssh_rijndael_init,
    ssh_rijndael_init, ssh_rijndael_cbc },
  { "aes128-cbc", 16, 16, ssh_rijndael_ctxsize, ssh_rijndael_init,
    ssh_rijndael_init, ssh_rijndael_cbc },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_RIJNDAEL */

#ifdef SSHDIST_CRYPT_BLOWFISH













#ifdef SSHDIST_SSH2
  { "blowfish-cbc", 8, 0,
    ssh_blowfish_ctxsize, ssh_blowfish_init, ssh_blowfish_init,
    ssh_blowfish_cbc },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_BLOWFISH */

#ifdef SSHDIST_CRYPT_TWOFISH









#ifdef SSHDIST_SSH2
  { "twofish-cbc", 16, 32,
    ssh_twofish_ctxsize, ssh_twofish_init, ssh_twofish_init, ssh_twofish_cbc },
  { "twofish256-cbc", 16, 32,
    ssh_twofish_ctxsize, ssh_twofish_init, ssh_twofish_init, ssh_twofish_cbc },
  { "twofish192-cbc", 16, 24,
    ssh_twofish_ctxsize, ssh_twofish_init, ssh_twofish_init, ssh_twofish_cbc },
  { "twofish128-cbc", 16, 16,
    ssh_twofish_ctxsize, ssh_twofish_init, ssh_twofish_init, ssh_twofish_cbc },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_TWOFISH */

#ifdef SSHDIST_CRYPT_DES









#ifdef SSHDIST_SSH2
  { "des-cbc@ssh.com", 8, 8, ssh_des_ctxsize, ssh_des_init,
    ssh_des_init_with_key_check, ssh_des_cbc },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_DES */

#ifdef SSHDIST_CRYPT_CAST
  /* CAST is patented by Nortel, but they've said it can be freely used. */


















#ifdef SSHDIST_SSH2
  { "cast128-cbc", 8, 16,
    ssh_cast_ctxsize, ssh_cast_init, ssh_cast_init, ssh_cast_cbc },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_CAST */










































































































#ifndef KERNEL
  /* The ciphers below can only be used in user-level code.  See
     the comments above for adding ciphers to the kernel. */







































#ifdef SSHDIST_CRYPT_ARCFOUR
  { "arcfour", 1, 0, ssh_arcfour_ctxsize, ssh_arcfour_init, ssh_arcfour_init,
    ssh_arcfour_transform },
#endif /* SSHDIST_CRYPT_ARCFOUR */


















#endif /* !KERNEL */

  { "none", 1, 0, NULL_FNPTR, NULL_FNPTR, NULL_FNPTR, ssh_none_cipher },

  { NULL }
};

/* Mapping from common cipher names to `canonical' ones. */
struct SshCipherAliasRec {
  const char *name;
  const char *real_name;
};

/* Common cipher names. */
const struct SshCipherAliasRec ssh_cipher_aliases[] =
{
#ifdef SSHDIST_CRYPT_DES


#ifdef SSHDIST_SSH2
  { "des", "des-cbc@ssh.com" },
  { "des-cbc", "des-cbc@ssh.com" },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_DES */
#ifdef SSHDIST_CRYPT_DES
  { "3des", "3des-cbc" },
#endif /* SSHDIST_CRYPT_DES */
#ifdef SSHDIST_CRYPT_CAST
  { "cast", "cast128-cbc" },
#endif /* SSHDIST_CRYPT_CAST */
#ifdef SSHDIST_CRYPT_BLOWFISH
  { "blowfish", "blowfish-cbc" },
#endif /* SSHDIST_CRYPT_BLOWFISH */






#ifdef SSHDIST_CRYPT_TWOFISH
  { "twofish", "twofish-cbc" },
#ifdef SSHDIST_SSH2
  { "twofish128", "twofish128-cbc" },
  { "twofish192", "twofish192-cbc" },
  { "twofish256", "twofish256-cbc" },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_TWOFISH */









#ifdef SSHDIST_CRYPT_RIJNDAEL









#ifdef SSHDIST_SSH2
  { "rijndael", "aes128-cbc" },
  { "aes", "aes128-cbc" },
  { "aes128", "aes128-cbc" },
  { "aes192", "aes192-cbc" },
  { "aes256", "aes256-cbc" },
#endif /* SSHDIST_SSH2 */
#endif /* SSHDIST_CRYPT_RIJNDAEL */
#ifdef SSHDIST_SSH2



#endif /* SSHDIST_SSH2 */






  { NULL, NULL }
};

struct SshCipherRec {
  const SshCipherDefStruct *ops;
  unsigned char iv[SSH_CIPHER_MAX_IV_SIZE];
  void *context;
};

/* Get corresponding cipher def record by cipher name */
static const SshCipherDefStruct *
ssh_cipher_get_cipher_def_internal(const char *name)
{
  int i, j;

  if (name == NULL)
    return NULL;

  for (i = 0; ssh_cipher_algorithms[i].name; i++)
    {
      if (strcmp(ssh_cipher_algorithms[i].name, name) == 0)
        {
          return &(ssh_cipher_algorithms[i]);
        }
    }
  for (i = 0; ssh_cipher_aliases[i].name; i++)
    {
      if (strcmp(ssh_cipher_aliases[i].name, name) == 0)
        {
          name = ssh_cipher_aliases[i].real_name;
          for (j = 0; ssh_cipher_algorithms[j].name; j++)
            {
              if (strcmp(ssh_cipher_algorithms[j].name, name) == 0)
                {
                  return &(ssh_cipher_algorithms[j]);
                }
            }
        }
    }
  return NULL;
}

/* Get the native name of the cipher. */

char *
ssh_cipher_get_native_name(const char *name)
{
  const SshCipherDefStruct * cipher_def;

  cipher_def = ssh_cipher_get_cipher_def_internal(name);

  if (cipher_def == NULL)
    return NULL;

  return ssh_strdup(cipher_def->name);
}

/* Check if given cipher name belongs to the set of supported ciphers
   and is not an alias. */

static Boolean ssh_cipher_supported_native(const char *name)
{
  const SshCipherDefStruct * cipher_def;

  cipher_def = ssh_cipher_get_cipher_def_internal(name);

  if (cipher_def == NULL)
    return FALSE;


  if (strcmp(name, cipher_def->name) != 0)
    return FALSE;

  return TRUE;
}

/* Check if given cipher name belongs to the set of supported ciphers
   aliases included. */

Boolean
ssh_cipher_supported(const char *name)
{
  if (ssh_cipher_get_cipher_def_internal(name) != NULL)
    return TRUE;

  return FALSE;
}

/* Return a comma-separated list of supported native cipher algorithm
   names. */

char *
ssh_cipher_get_supported_native(void)
{
  char *list, *tmp;
  int i;
  size_t offset, list_len;

  list = NULL;
  offset = list_len = 0;

  for (i = 0; ssh_cipher_algorithms[i].name != NULL; i++)
    {
      size_t newsize;

      newsize = offset + 1 + !!offset + strlen(ssh_cipher_algorithms[i].name);

      if (list_len < newsize)
        {
          newsize *= 2;

          if ((tmp = ssh_realloc(list, list_len, newsize)) == NULL)
            {
              ssh_free(list);
              return NULL;
            }
          list = tmp;
          list_len = newsize;
        }

      SSH_ASSERT(list_len > 0);
      SSH_ASSERT(list != NULL);

      offset += ssh_snprintf(list + offset, list_len - offset, "%s%s",
                             offset ? "," : "",
                             ssh_cipher_algorithms[i].name);

    }
  return list;
}

/* Return a comma-separated list of supported cipher algorithm names
   alias names included. */

char *
ssh_cipher_get_supported(void)
{
  int i;
  char *list, *tmp;
  size_t offset, list_len;

  list = NULL;
  offset = list_len = 0;

  if (!(list = ssh_cipher_get_supported_native()))
    return NULL;

  offset = strlen(list);
  list_len = offset + 1;

  for (i = 0; ssh_cipher_aliases[i].name != NULL; i++)
    {
      size_t newsize;
      newsize = offset + 1 + !!offset + strlen(ssh_cipher_aliases[i].name);

      if (!ssh_cipher_supported_native(ssh_cipher_aliases[i].name))
        continue;

      if (list_len < newsize)
        {
          newsize *= 2;

          if ((tmp = ssh_realloc(list, list_len, newsize)) == NULL)
            {
              ssh_free(list);
              return NULL;
            }

          list_len = newsize;
        }

      offset += ssh_snprintf(list + offset, list_len - offset, "%s%s",
                             offset ? "," : "",
                             ssh_cipher_aliases[i].name);

    }
  return list;
}

/* Allocates and initializes a cipher of the specified name. */

SshCryptoStatus
ssh_cipher_allocate_internal(const char *name,
                             const unsigned char *key,
                             size_t keylen,
                             Boolean for_encryption,
                             SshCipher *cipher,
                             Boolean expand,
                             Boolean test_weak_keys)
{
  unsigned char *expanded_key;
  unsigned int expanded_key_len;
  const SshCipherDefStruct *cipher_def;
  Boolean rv;

  cipher_def = ssh_cipher_get_cipher_def_internal(name);
  if (cipher_def == NULL)
    return SSH_CRYPTO_UNSUPPORTED;

  if (keylen == 0)
    {
      /* Allow zero key length for cipher `none'. */
      if ((strcmp(name, "none") != 0) && expand == FALSE)
        return SSH_CRYPTO_KEY_TOO_SHORT;
    }

  /* This portion handles the key expansion computation. It uses the
     expansion function defined in the genhash.c. It basically just
     recomputes the hash function of choice until enough key material
     is available. */

  if (expand)
    {
      expanded_key_len = cipher_def->key_length;
      if (expanded_key_len == 0)
        expanded_key_len = SSH_CIPHER_MINIMAL_KEY_LENGTH;

      /* XXX: Is this proper error code to return on memory allocation
         failure? */
      if (!(expanded_key = ssh_malloc(expanded_key_len)))
        return SSH_CRYPTO_OPERATION_FAILED;

      ssh_hash_expand_key_internal(expanded_key, expanded_key_len,
                                   key, keylen,
                                   NULL, 0,
#ifdef SSHDIST_CRYPT_SHA
                                   /* Use SHA-1 hash function. Any other
                                      hash function defined in this manner
                                      is allowed. The application cannot
                                      currently change the function! XXX */
                                   &ssh_hash_sha_def
#endif /* SSHDIST_CRYPT_SHA */







                                   );
    }
  else
    {
      /* No need to expand the key. */

      expanded_key_len = keylen;
      expanded_key = (unsigned char *)key;
    }

  /* Check for error in key expansion. No keys shorter than the key length
     of the cipher is allowed. Longer are allowed, but only the first
     bytes are used. */
  if (expanded_key_len < cipher_def->key_length)
    {
      if (expand)
        ssh_fatal("internal error: key expansion corrupted.");

      return SSH_CRYPTO_KEY_TOO_SHORT;
    }

  /* Initialize the cipher. */

  if (!(*cipher = ssh_malloc(sizeof(**cipher))))
    {
      ssh_free(expanded_key);

      /* XXX: Correct return value on memory allocation failure? */
      return SSH_CRYPTO_OPERATION_FAILED;
    }

  /* Set up the cipher definition. */
  (*cipher)->ops = cipher_def;
  /* Clean the IV. */
  memset((*cipher)->iv, 0, sizeof((*cipher)->iv));

  /* Set return value (rv) to default. */
  rv = TRUE;

  /* The "ctxsize" can be NULL if and only if the cipher is the none cipher. */
  if (cipher_def->ctxsize)
    {
      /* Allocate the context of the cipher. */
      if (!((*cipher)->context = ssh_malloc((*cipher_def->ctxsize)())))
        {
          ssh_free(*cipher);
          *cipher = NULL;

          if (expand)
            ssh_free(expanded_key);

          /* XXX: again, correct code? */
          return SSH_CRYPTO_OPERATION_FAILED;
        }

      if (test_weak_keys == FALSE)
        {
          /* Initialize the cipher without weak key checks. */
          rv = (*cipher_def->init)((*cipher)->context,
                                   expanded_key,
                                   expanded_key_len,
                                   for_encryption);
        }
      else
        {
          /* Initialize the cipher with a weak key check performed first.
             Not all ciphers have key classes that are easy or practical to
             test for. For those ciphers this function may perform
             as the plain initialization.
             */
          rv = (*cipher_def->init_with_check)((*cipher)->context,
                                              expanded_key,
                                              expanded_key_len,
                                              for_encryption);
        }
    }
  else
    (*cipher)->context = NULL;

  /* Free memory of the expanded key if necessary. */
  if (expand)
    ssh_free(expanded_key);

  if (rv == FALSE)
    {
      ssh_free((*cipher)->context);
      ssh_free(*cipher);
      *cipher = NULL;
      return SSH_CRYPTO_OPERATION_FAILED;
    }
  return SSH_CRYPTO_OK;
}

SshCryptoStatus
ssh_cipher_allocate(const char *name,
                    const unsigned char *key,
                    size_t keylen,
                    Boolean for_encryption,
                    SshCipher *cipher)
{
  return ssh_cipher_allocate_internal(name, key, keylen, for_encryption,
                                      cipher, FALSE, FALSE);
}

SshCryptoStatus
ssh_cipher_allocate_with_passphrase(const char *name,
                                    const char *passphrase,
                                    Boolean for_encryption,
                                    SshCipher *cipher)
{
  return ssh_cipher_allocate_internal(name, (unsigned char *) passphrase,
                                      strlen(passphrase),
                                      for_encryption, cipher, TRUE, FALSE);
}

SshCryptoStatus
ssh_cipher_allocate_and_test_weak_keys(const char *name,
                                       const unsigned char *key,
                                       size_t keylen,
                                       Boolean for_encryption,
                                       SshCipher *cipher)
{
  return ssh_cipher_allocate_internal(name, key, keylen,
                                      for_encryption, cipher,
                                      FALSE, TRUE);
}

/* Free the cipher context */

void
ssh_cipher_free(SshCipher cipher)
{
  ssh_free(cipher->context);
  ssh_free(cipher);
}

char *
ssh_cipher_get_name(SshCipher cipher)
{
  return ssh_strdup(cipher->ops->name);
}

size_t
ssh_cipher_get_key_length(const char *name)
{
  const SshCipherDefStruct *cipher_def;

  cipher_def = ssh_cipher_get_cipher_def_internal(name);
  if (cipher_def == NULL)
    return 0;

  return cipher_def->key_length;
}

size_t
ssh_cipher_get_block_length_by_name(const char *name)
{
  const SshCipherDefStruct *cipher_def;

  cipher_def = ssh_cipher_get_cipher_def_internal(name);
  if (cipher_def == NULL)
    return 0;

  return cipher_def->block_length;
}

size_t
ssh_cipher_get_block_length(SshCipher cipher)
{
  return cipher->ops->block_length;
}

size_t
ssh_cipher_get_iv_length(SshCipher cipher)
{
  /* XXX Currently just returns the block length. */
  return cipher->ops->block_length;
}

SshCryptoStatus
ssh_cipher_set_iv(SshCipher cipher,
                  const unsigned char *iv)
{
  memcpy(cipher->iv, iv, cipher->ops->block_length);

  return SSH_CRYPTO_OK;
}

SshCryptoStatus
ssh_cipher_get_iv(SshCipher cipher,
                  unsigned char *iv)
{
  memcpy(iv, cipher->iv, cipher->ops->block_length);
  return SSH_CRYPTO_OK;
}

SshCryptoStatus
ssh_cipher_transform(SshCipher cipher,
                     unsigned char *dest,
                     const unsigned char *src,
                     size_t len)
{
  /* Check that the src length is divisible by block length of the cipher. */
  if (len % cipher->ops->block_length == 0)
    (*cipher->ops->transform)(cipher->context, dest, src, len, cipher->iv);
  else
    return SSH_CRYPTO_BLOCK_SIZE_ERROR;

  return SSH_CRYPTO_OK;
}

SshCryptoStatus
ssh_cipher_transform_with_iv(SshCipher cipher,
                             unsigned char *dest,
                             const unsigned char *src,
                             size_t len,
                             unsigned char *iv)
{
  /* Check that the src length is divisible by block length of the cipher. */
  if (len % cipher->ops->block_length == 0)
    (*cipher->ops->transform)(cipher->context, dest, src, len, iv);
  else
    return SSH_CRYPTO_BLOCK_SIZE_ERROR;

  return SSH_CRYPTO_OK;
}
