/*

  Authors: Timo J. Rinne <tri@ssh.com>
           Sami Lehtinen <sjl@ssh.com>
           
  Copyright (C) 1996,2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Simple Namelist. Compute the section between two namelists, SSHv2
  style. Doesn't handle trees (see namelist.h in
  lib/sshcrypto/sshcryptocore).

  Inspired by namelist in sshcrypto.

*/
#ifndef _SSHSNLIST_H_
#define _SSHSNLIST_H_

/* Get the name following to 'namelist' pointer and ending with the
   next comma separator. Name string returned is zero terminated and
   is to be freed by caller with ssh_xfree.  Returns NULL if there are
   no more names or namelist is NULL. */
char *ssh_snlist_get_name(const char *namelist);

/* Step over to the next name. Returns the pointer to the next name, or NULL
   if there are no more names in the list. */
const char *ssh_snlist_step_forward(const char *namelist);

/* Compute the intersection between string `src1' and `src2'.
   Format for inputs and output is "name1,name2,...,namen".
   The caller must free the returned string with ssh_xfree.
   The output list will contain the names in the order in which they
   are listed in the first list. */
char *ssh_snlist_intersection(const char *src1, const char *src2);

/* Specialized functions for computing the intersection between `src' and
   the list of supported algorithms.  All lists are comma-separated lists
   of algorithm names.  The caller is responsible for freeing the result
   with ssh_xfree.  The output will contain the nams in the order in which
   they are listed in the argument list. */
#ifdef SSHDIST_CRYPT_GENCIPH
char *ssh_snlist_intersection_cipher(const char *src);
#endif /* SSHDIST_CRYPT_GENCIPH */
#ifdef SSHDIST_CRYPT_GENMAC
char *ssh_snlist_intersection_mac(const char *src);
#endif /* SSHDIST_CRYPT_GENMAC */
#ifdef SSHDIST_CRYPT_GENHASH
char *ssh_snlist_intersection_hash(const char *src);
#endif /* SSHDIST_CRYPT_GENHASH */
#ifdef SSHDIST_CRYPT_COMPRESS
char *ssh_snlist_intersection_compression(const char *src);
#endif /* SSHDIST_CRYPT_COMPRESS */

#endif /* _SSHSNLIST_H_ */
