/*

  sshcipherlist.c

  Authors:
        Tatu Ylonen <ylo@ssh.fi>
        Markku-Juhani Saarinen <mjos@ssh.fi>
        Timo J. Rinne <tri@ssh.fi>
        Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 1998-2000 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Canonialize comma-separated cipher lists.

*/

#ifndef SSHCIPHERLIST_H
#define SSHCIPHERLIST_H

/* list of ciphers in secsh draft */
#define SSH_STD_CIPHERS                                         \
        "aes128-cbc,3des-cbc,twofish128-cbc,cast128-cbc,"       \
        "twofish-cbc,blowfish-cbc,idea-cbc,aes192-cbc,"         \
        "aes256-cbc,twofish192-cbc,twofish256-cbc,arcfour,none"
/* list of macs in secsh draft */
#define SSH_STD_MACS \
        "hmac-sha1,hmac-sha1-96,hmac-md5,hmac-md5-96,none"

/* Appends the second list to the first list. */
void ssh_cipher_list_append(char **list, char *item);

/*
   TRUE if list `list' contains item `item'.
*/
Boolean ssh_cipher_list_contains(char *list, char *item);

/*
   Canonialize cipher names.  Unsupported algorithms are excluded
   and names of the supported ones are always replaced with the
   `native' one.
*/
char *ssh_cipher_list_canonicalize(char *str);

/*
   Canonialize hash algorithm names.  Unsupported algorithms are 
   excluded and names of the supported ones are always replaced 
   with the `native' one.
*/
char *ssh_hash_list_canonicalize(char *str);

/* 
   Return a name list that contains items in list `original'
   so that items in list `excluded' are excluded. 
*/
char *ssh_cipher_list_exclude(char *original, char *excluded);

/*
   Convert between canonical cryptolib names and
   names in secsh draft.
 */
char *ssh_public_key_name_ssh_to_cryptolib(char *str);
char *ssh_public_key_name_cryptolib_to_ssh(char *str);

/* When given a list of public key algorithms (ssh-dsa,...)
   constructs an xmallocated list of corresponding X509 versions
   (x509v3-sign-dss,...) and returns it. */
char *ssh_cipher_list_x509_from_pk_algorithms(char *alglist);

#endif /* SSHCIPHERLIST_H */

/* eof (sshcipherlist.h) */
