/*

  sshunixuserfiles.c

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Simple functions that update user's files. These are unix-spesific.

*/

/* 
 * $Log: sshunixuserfiles.c,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#include "sshincludes.h"
#include "sshuserfiles.h"
#include "sshencode.h"
#include "ssh2pubkeyencode.h"
#include "sshuser.h"
#include "sshuserfile.h"
#include "sshconfig.h"
#include "sshmiscstring.h"
#include "sshappcommon.h"





#define SSH_DEBUG_MODULE "SshUnixUserFiles"



/* Make sure that the random seed file exists and return a pointer to it. 
   return NULL on failure. The file name is found from `config'. 
   If `config->random_seed_file' is NULL, use the standard SSH_RANDSEED_FILE.

   The caller is responsible for freeing the returned value with ssh_xfree 
   when no longer needed. */

char *ssh_randseed_file(SshUser user, SshConfig config, Boolean create)
{
  SshUserFile f;
  char *sshdir, *sshseed;
  size_t sshseedlen;
  struct stat st;
  int flags = O_RDWR | O_CREAT;
  char *random_seed_file;
  Boolean client;





  ssh_userfile_init(ssh_user_name(user), ssh_user_uid(user),
                    ssh_user_gid(user), NULL_FNPTR, NULL);
  
  /* get the rand seed file name if available */
  if (config == NULL)
    {
      /* config is NULL, so assume we're the client and default filename.
         this situation occurs when using ssh-keygen */
      random_seed_file = ssh_xstrdup(SSH_RANDSEED_FILE);
      client = TRUE;
    }
  else if (config->random_seed_file == NULL)
    {
      /* normally shouldn't happen, since file defaults to SSH_RANDSEED_FILE */
      random_seed_file = ssh_xstrdup(SSH_RANDSEED_FILE);
      client = config->client;
    }
  else if (strlen(config->random_seed_file) <= 0)
    {
      /* may as well be safe and make sure the file name the
         user gave is long enough */
      random_seed_file = ssh_xstrdup(SSH_RANDSEED_FILE);
      client = config->client;
    }
  else
    {
      /* config struct ok, so use the those values*/
      random_seed_file = ssh_xstrdup(config->random_seed_file);
      client = config->client;
    }

  /* random seed file now defined.. we can continue */

  if (ssh_app_is_file_name_absolute(random_seed_file))
    {
      /* the random seed is an absolute path so use that without
         modification. */
      sshseed = ssh_xstrdup(random_seed_file);
    }
  else if (client == FALSE)
    {
      /* the random seed file name is without an absolute path, and
         the server called this, so the random_seed should be in
         SSH_SERVER_DIR*/


      sshseedlen = strlen(random_seed_file) +
                   sizeof(SSH_SERVER_DIR) + 4;
      sshseed = ssh_xmalloc(sshseedlen);
      ssh_snprintf(sshseed, sshseedlen, "%s/%s",
                   SSH_SERVER_DIR, random_seed_file);











    }
  else
    {
      /* the client called this so the random_seed should be in $HOME/.ssh2
         since there isn't a absolute path in the file name */
      /* See if the random seed directory exists */

      if ((sshdir = ssh_userdir(user, config, TRUE)) == NULL)
        {
          ssh_xfree(random_seed_file);
          ssh_userfile_uninit();
          return NULL;
        }

      sshseedlen = strlen(random_seed_file) + strlen(sshdir) + 4;
      sshseed = ssh_xmalloc(sshseedlen);
      ssh_snprintf(sshseed, sshseedlen, "%s/%s", sshdir, random_seed_file);

      ssh_xfree(sshdir);
    }

  /* the sshseed variable is now set, so we don't
     need random seed file anymore */
   ssh_xfree(random_seed_file);

  /* If seed doesn't exist, create it. */
  if (create && ssh_userfile_stat(ssh_user_uid(user), sshseed, &st) < 0)
    {
      if ((f = ssh_userfile_open(ssh_user_uid(user), sshseed, 
                                 flags, 0600)) == NULL)
        {
          SSH_DEBUG(2, ("Could not create random seed file %s.", sshseed));
          ssh_xfree(sshseed);
          ssh_userfile_uninit();
          return NULL;
        }
      ssh_userfile_close(f);
    }

  ssh_userfile_uninit();
  return sshseed;
}

/* Get the random state from the file.  This loads and merges any data
   in the seed file into the generator. */

void ssh_randseed_load(SshUser user, SshConfig config)
{
  int i;
  SshUserFile f;
  unsigned char randbuf[16];
  char *sshseed;
  size_t nbytes;
  int flags = O_RDONLY;





  ssh_userfile_init(ssh_user_name(user), ssh_user_uid(user),
                    ssh_user_gid(user), NULL_FNPTR, NULL);

  /* Stir a bit.  This will add a couple of bits of new randomness to the 
     pool. */
  for (i = 0; i < 3; i++)
    ssh_random_stir();
  
  /* Stir the seed file in, if possible. */
  sshseed = ssh_randseed_file(user, config, TRUE);
  if ((f = ssh_userfile_open(ssh_user_uid(user), sshseed, flags, 0)) != 
      NULL)
    {
      while ((nbytes = ssh_userfile_read(f, randbuf, sizeof(randbuf))) > 0)
        ssh_random_add_noise(randbuf, nbytes);
      ssh_userfile_close(f);
    }
  ssh_xfree(sshseed); 
  
  /* Stir a bit.  This will add a few bits of new randomness to the pool. */
  for (i = 0; i < 3; i++)
    ssh_random_stir();
  ssh_userfile_uninit();
}

/* Updates the random seed file with information from the random
   number generator.  Information from the old random seed file and
   the generator is mixed, so that the new random seed file will
   contain traces of both the generator state and the old seed
   file. */

void ssh_randseed_update(SshUser user, SshConfig config)
{
  size_t i;
  SshUserFile f;
  char *sshseed;
  unsigned char seed[SSH_RANDSEED_LEN];
  int flags = O_CREAT | O_WRONLY;





  ssh_userfile_init(ssh_user_name(user), ssh_user_uid(user),
                    ssh_user_gid(user), NULL_FNPTR, NULL);

  /* Load the old random seed file and mix it into the generator. */
  ssh_randseed_load(user, config);
  
  /* Write data from the generator into the random seed file. */
  sshseed = ssh_randseed_file(user, config, TRUE);
  if ((f = ssh_userfile_open(ssh_user_uid(user), sshseed, flags, 
                         0600)) == NULL)
    {
      SSH_DEBUG(2, ("unable to write the random seed file!"));
      goto error;
    }
  for (i = 0; i < SSH_RANDSEED_LEN; i++)
    seed[i] = ssh_random_get_byte();
  if (ssh_userfile_write(f, seed, SSH_RANDSEED_LEN) != SSH_RANDSEED_LEN)
    ssh_warning("unable to write to the random seed file %s.", sshseed);

  memset(seed, 0, SSH_RANDSEED_LEN);
  ssh_userfile_close(f);

error:
  ssh_xfree(sshseed);
  ssh_userfile_uninit();
}

/* build a list of private key files that should be tried when
   logging into `host'.  The list's last entry will be NULL.
   The caller should free the array and all strings in it when no longer
   needed. */

struct SshConfigPrivateKey **ssh_privkey_list(SshUser user, 
                                              char *host, 
                                              SshConfig config)
{
  int i, j, n;
  char *udir, **vars, **vals, buf[1024];
  struct SshConfigPrivateKey **prkey;
#ifdef WITH_PGP
  char *pgp_secret_key_file;
#endif /* WITH_PGP */

  if ((udir = ssh_userdir(user, config, TRUE)) == NULL)
    {
      SSH_DEBUG(2, ("no user directory."));
      return NULL;
    }

  /* read and sort the names */

  if (config != NULL && config->identity_file != NULL &&
      *(config->identity_file) == '/')
    ssh_snprintf(buf, sizeof(buf)-1, "%s", config->identity_file);
  else
    ssh_snprintf(buf, sizeof(buf)-1, "%s/%s", udir, 
                 config == NULL || config->identity_file == NULL ?
                 SSH_IDENTIFICATION_FILE : config->identity_file);
  
  /* XXX metaconfig */
  n = ssh2_parse_config(user, host, buf, &vars, &vals, NULL, TRUE);

  if (n < 0)
    {      
      ssh_xfree(udir);
      return NULL;
    }

  /* construct a name list with complete file paths */

  prkey = ssh_xcalloc(n + 1, sizeof (struct SshConfigPrivateKey *));

#ifdef WITH_PGP
  pgp_secret_key_file = ssh_xstrdup(config->pgp_secret_key_file);
#endif /* WITH_PGP */

  j = 0;
  for (i = 0; i < n; i++)
    {
      if (strcasecmp(vars[i], "idkey") == 0)
        {
          if (*vals[i] == '/')
            ssh_snprintf(buf, sizeof(buf), "%s", vals[i]);
          else
            ssh_snprintf(buf, sizeof(buf), "%s/%s",
                         udir, vals[i]);
              
          prkey[j] = ssh_xcalloc(1, sizeof (struct SshConfigPrivateKey));
          prkey[j]->keyfile = ssh_xstrdup(buf);
          prkey[j]->type = SSH_PRIVKEY_PLAIN;
          j++;
        }
#ifdef WITH_PGP
      else if (strcasecmp(vars[i], "pgpsecretkeyfile") == 0)
        {
          ssh_xfree(pgp_secret_key_file);
          pgp_secret_key_file = ssh_xstrdup(vals[i]);
        }
      else if (strcasecmp(vars[i], "idpgpkeyid") == 0)
        {
          unsigned long id;
          char *endptr = NULL;

          id = strtoul(vals[i], &endptr, 0);
          if (((*(vals[0])) != '\0') && ((*endptr) == '\0'))
            {
              if (*pgp_secret_key_file == '/')
                ssh_snprintf(buf, sizeof(buf), "%s", pgp_secret_key_file);
              else
                ssh_snprintf(buf, sizeof(buf), "%s/%s",
                             udir, pgp_secret_key_file);
              
              prkey[j] = ssh_xcalloc(1, sizeof (struct SshConfigPrivateKey));
              prkey[j]->pgp_keyring = ssh_xstrdup(buf);
              prkey[j]->pgp_id = id;
              prkey[j]->type = SSH_PRIVKEY_PGP;
              j++;
            }
          else
            {
              ssh_warning("invalid pgp key id number \"%s\"", vals[i]);
            }
        }
      else if (strcasecmp(vars[i], "idpgpkeyname") == 0)
        {
          if (*pgp_secret_key_file == '/')
            ssh_snprintf(buf, sizeof(buf), "%s", pgp_secret_key_file);
          else
            ssh_snprintf(buf, sizeof(buf), "%s/%s",
                         udir, pgp_secret_key_file);
              
          prkey[j] = ssh_xcalloc(1, sizeof (struct SshConfigPrivateKey));
          prkey[j]->pgp_keyring = ssh_xstrdup(buf);
          prkey[j]->pgp_name = ssh_xstrdup(vals[i]);
          prkey[j]->type = SSH_PRIVKEY_PGP;
          j++;
        }
      else if (strcasecmp(vars[i], "idpgpkeyfingerprint") == 0)
        {
          if (*pgp_secret_key_file == '/')
            ssh_snprintf(buf, sizeof(buf), "%s", pgp_secret_key_file);
          else
            ssh_snprintf(buf, sizeof(buf), "%s/%s",
                         udir, pgp_secret_key_file);
              
          prkey[j] = ssh_xcalloc(1, sizeof (struct SshConfigPrivateKey));
          prkey[j]->pgp_keyring = ssh_xstrdup(buf);
          prkey[j]->pgp_fingerprint = ssh_xstrdup(vals[i]);
          prkey[j]->type = SSH_PRIVKEY_PGP;
          j++;
        }
#endif /* WITH_PGP */
















#if 0
      /* XXX Warn about malformed keywords.  */
#endif
    }
  prkey[j++] = NULL;
  ssh_free_varsvals(n, vars, vals);
  ssh_xfree(udir);
#ifdef WITH_PGP
  ssh_xfree(pgp_secret_key_file);
#endif /* WITH_PGP */

  return prkey;
}
