/*

  sshftpfilter.h

  Authors:
        Tomi Salo <ttsalo@ssh.com>
        Timo J. Rinne <tri@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

*/

/*

  This module implements ftp protocol forwarding.

*/

#ifndef SSHFTPFILTER_H
#define SSHFTPFILTER_H

#include "sshfilterstream.h"
#include "sshchtcpfwd.h"
#include "sshcommon.h"

typedef struct SshFtpFilterRec {
  SshCommon common;
  SshLocalTcpForward local_fwd;
  SshRemoteTcpForward remote_fwd;
  /* Necessary data for the creation of the remote forwarding */
  unsigned char connect_to_host[32];
  unsigned char connect_to_port[16];
  unsigned int local_port;
  SshBuffer buffer;
  void *filter_context;
  Boolean remote_fwd_creation_in_progress;
  size_t input_offset;
  void *input_filter_internal_context;
  SshFilterCompletionCB input_filter_completion;
} *SshFtpFilter;

/* Function for handling the data entering the ftp command connection tunnel.
   (output from the ftp client). */
void ssh_ftp_output_filter(void *context,
                           SshFilterGetCB get_data,
                           SshFilterCompletionCB completed,
                           void *internal_context);

/* Function for handling the data coming from the ftp command connection tunnel.
   (input for the ftp client). */
void ssh_ftp_input_filter(void *context,
                          SshFilterGetCB get_data,
                          SshFilterCompletionCB completed,
                          void *internal_context);

void ssh_ftp_filter_destroy(void *context);

#endif /* ! SSHFTPFILTER_H */
