/*

sshauthmethods.h

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  This file defines the interfaces for authentication method handling for
  ssh2.

*/

#ifndef SSHAUTHMETHODS_H
#define SSHAUTHMETHODS_H

#include "sshauth.h"
#include "sshadt_list.h"

/* The ssh_{server,client}_authentication_uninitialize() functions
   expect to get this type of context or NULL. */
typedef struct SshAuthUninitMethodCtxRec
{
  /* This is called by the respective function. */
  void (*notify_callback)(void *context);
  /* This is given as argument. */
  void *notify_context;
} SshAuthUninitCtxStruct, *SshAuthUninitCtx;

/* Initializes the authentication methods array for the server. */
SshAuthServerMethod 
ssh_server_authentication_initialize(SshADTContainer conf_methods);

/* Frees the returned authentication method array. */
void ssh_server_authentication_uninitialize(SshAuthServerMethod methods,
                                            void *context);

/* Initializes the authentication methods array for the client. */
SshAuthClientMethod 
ssh_client_authentication_initialize(SshADTContainer conf_methods);

/* Frees the returned authentication method array. */
void ssh_client_authentication_uninitialize(SshAuthClientMethod methods,
                                            void *context);

#endif /* SSHAUTHMETHODS_H */
