/*

sshauthmethods.c

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  SSH2 authentication methods for the server.

*/

#include "ssh2includes.h"
#include "sshauth.h"
#include "sshauthmethods.h"
#include "sshauthmethodsi.h"
#include "auths-passwd.h"
#include "auths-pubkey.h"
#include "auths-hostbased.h"
#ifdef DAEMON_WITH_PAM
#include "auths-pam.h"
#endif /* DAEMON_WITH_PAM */
#ifdef KERBEROS
#include "auths-kerberos.h"
#include "auths-kerberos-tgt.h"
#endif /* KERBEROS */
#ifdef SSH_SERVER_WITH_SECURID
#include "auths-securid.h"
#endif /* SSH_SERVER_WITH_SECURID */
#ifdef SSHDIST_SSH2_AUTH_KBDINTERACTIVE
#ifdef SSH_SERVER_WITH_KEYBOARD_INTERACTIVE
#include "auths-kbd-interactive.h"
#endif /* SSH_SERVER_WITH_KEYBOARD_INTERACTIVE */
#endif /* SSHDIST_SSH2_AUTH_KBDINTERACTIVE */

#define SSH_DEBUG_MODULE "SshAuthMethodServer"

static SshAuthServerMethodStruct all_methods[] =
{

  { SSH_AUTH_HOSTBASED, ssh_server_auth_hostbased },
#ifdef DAEMON_WITH_PAM
  { SSH_AUTH_PAM, ssh_server_auth_pam },
#endif /* DAMON_WITH_PAM */
#ifdef KERBEROS
  { SSH_AUTH_KERBEROS_TGT, ssh_server_auth_kerberos_tgt },
  { SSH_AUTH_KERBEROS, ssh_server_auth_kerberos },
#endif /* KERBEROS */

  { SSH_AUTH_PUBKEY, ssh_server_auth_pubkey },
  { SSH_AUTH_PASSWD, ssh_server_auth_passwd },
#ifdef SSH_SERVER_WITH_SECURID

  { SSH_AUTH_SECURID, ssh_server_auth_securid },

#endif /* SSH_SERVER_WITH_SECURID */
#ifdef SSHDIST_SSH2_AUTH_KBDINTERACTIVE
#ifdef SSH_SERVER_WITH_KEYBOARD_INTERACTIVE
  { SSH_AUTH_KBD_INTERACTIVE, ssh_server_auth_kbd_interact },
#endif /* SSH_SERVER_WITH_KEYBOARD_INTERACTIVE */
#endif /* SSHDIST_SSH2_AUTH_KBDINTERACTIVE */
  { NULL, NULL_FNPTR }
};

/* Initializes the authentication methods array for the server. */
SSH_AUTH_METHOD_INIT(SshAuthServerMethod,
                     ssh_server_authentication_initialize,
                     TRUE);

/* Frees the returned authentication method array. */
SSH_AUTH_METHOD_UNINIT(SshAuthServerMethod,
                       ssh_server_authentication_uninitialize);
