/*

  ssh1packet.h

  Author:
        Timo J. Rinne <tri@ssh.com>

  Copyright (C) 1999-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Ssh1 protocol packet types and {en|de}coding.

*/

#ifndef SSH1PACKET_H
#define SSH1PACKET_H 1

/* Definition of ssh1 message types.  The maximum value is 254; value
   255 is reserved for future extension.  Even though this protocol 
   should not be neither extended nor modified.  These definitions 
   correspond to the implementation of SSH Communications Security Ltd.
   Secure Shell version 1.2.27. */

typedef enum {
  /* Message name = code */                        /* arguments */
  SSH1_PACKET_MSG_NONE = 0,                        /* no message */
  SSH1_PACKET_MSG_DISCONNECT = 1,                  /* cause (string) */
  SSH1_PACKET_SMSG_PUBLIC_KEY = 2,                 /* ck,msk,srvk,hostk */
  SSH1_PACKET_CMSG_SESSION_KEY = 3,                /* key (MP_INT) */
  SSH1_PACKET_CMSG_USER = 4,                       /* user (string) */
  SSH1_PACKET_CMSG_AUTH_RHOSTS = 5,                /* user (string) */
  SSH1_PACKET_CMSG_AUTH_RSA = 6,                   /* modulus (MP_INT) */
  SSH1_PACKET_SMSG_AUTH_RSA_CHALLENGE = 7,         /* int (MP_INT) */
  SSH1_PACKET_CMSG_AUTH_RSA_RESPONSE = 8,          /* int (MP_INT) */
  SSH1_PACKET_CMSG_AUTH_PASSWORD = 9,              /* pass (string) */
  SSH1_PACKET_CMSG_REQUEST_PTY = 10,               /* TERM, tty modes */
  SSH1_PACKET_CMSG_WINDOW_SIZE = 11,               /* row,col,xpix,ypix */
  SSH1_PACKET_CMSG_EXEC_SHELL = 12,                /* */
  SSH1_PACKET_CMSG_EXEC_CMD = 13,                  /* cmd (string) */
  SSH1_PACKET_SMSG_SUCCESS = 14,                   /* */
  SSH1_PACKET_SMSG_FAILURE = 15,                   /* */
  SSH1_PACKET_CMSG_STDIN_DATA = 16,                /* data (string) */
  SSH1_PACKET_SMSG_STDOUT_DATA = 17,               /* data (string) */
  SSH1_PACKET_SMSG_STDERR_DATA = 18,               /* data (string) */
  SSH1_PACKET_CMSG_EOF = 19,                       /* */
  SSH1_PACKET_SMSG_EXITSTATUS = 20,                /* status (int) */
  SSH1_PACKET_MSG_CHANNEL_OPEN_CONFIRMATION = 21,  /* channel (int) */
  SSH1_PACKET_MSG_CHANNEL_OPEN_FAILURE = 22,       /* channel (int) */
  SSH1_PACKET_MSG_CHANNEL_DATA = 23,               /* ch,data (int,str) */
#if 0
  SSH1_PACKET_MSG_CHANNEL_CLOSE = 24,              /* channel (int) */
  SSH1_PACKET_MSG_CHANNEL_CLOSE_CONFIRMATION = 25, /* channel (int) */
#endif /* 0 */

  /* new channel protocol */
  SSH1_PACKET_MSG_CHANNEL_INPUT_EOF = 24,          /* */
  SSH1_PACKET_MSG_CHANNEL_OUTPUT_CLOSED = 25,      /* */

  SSH1_PACKET_SMSG_X11_OPEN = 27,                  /* channel (int) */
  SSH1_PACKET_CMSG_PORT_FORWARD_REQUEST = 28,      /* p,host,hp (i,s,i) */
  SSH1_PACKET_MSG_PORT_OPEN = 29,                  /* ch,h,p (i,s,i) */
  SSH1_PACKET_CMSG_AGENT_REQUEST_FORWARDING = 30,  /* */
  SSH1_PACKET_SMSG_AGENT_OPEN = 31,                /* port (int) */
  SSH1_PACKET_MSG_IGNORE = 32,                     /* string */
  SSH1_PACKET_CMSG_EXIT_CONFIRMATION = 33,         /* */
  SSH1_PACKET_CMSG_X11_REQUEST_FORWARDING = 34,    /* proto,data (s,s) */
  SSH1_PACKET_CMSG_AUTH_RHOSTS_RSA = 35,           /* user,mod (s,mpi) */
  SSH1_PACKET_MSG_DEBUG = 36,                      /* string */
  SSH1_PACKET_CMSG_REQUEST_COMPRESSION = 37,       /* level 1-9 (int) */
  SSH1_PACKET_CMSG_MAX_PACKET_SIZE = 38,           /* max_size (int) */

  /* Support for TIS authentication server
     Contributed by Andre April <Andre.April@cediti.be>. */
  SSH1_PACKET_CMSG_AUTH_TIS = 39,      /* */
  SSH1_PACKET_SMSG_AUTH_TIS_CHALLENGE = 40,        /* string */
  SSH1_PACKET_CMSG_AUTH_TIS_RESPONSE = 41,         /* pass (string) */

  /* Support for kerberos authentication by Glenn Machin and Dug Song
     <dugsong@umich.edu> */
  SSH1_PACKET_CMSG_AUTH_KERBEROS = 42,             /* string (KTEXT) */
  SSH1_PACKET_SMSG_AUTH_KERBEROS_RESPONSE = 43,    /* string (KTEXT) */
  SSH1_PACKET_CMSG_HAVE_KERBEROS_TGT = 44,         /* string (credentials) */

  /* Reserved for official extensions, do not use these */
  SSH1_PACKET_CMSG_RESERVED_START = 45,            /* ? */
  SSH1_PACKET_CMSG_RESERVED_END = 63,              /* ? */

  SSH1_PACKET_MSG_EXTENSION = 255
} Ssh1PacketType;

/* Protocol flags.  These are bit masks. */
#define SSH1_PROTOFLAG_SCREEN_NUMBER    1 /* X11 forwarding includes screen */
#define SSH1_PROTOFLAG_HOST_IN_FWD_OPEN 2 /* forwarding opens contain host */

#endif /* ! SSH1PACKET_H */
