/*

  sftphelp.c

  Authors: Tomi Salo <ttsalo@ssh.com>
           Sami Lehtinen <sjl@ssh.com>

  Copyright (c) 1999-2002 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Feb  3 16:39:33 2000.

  Help-command implementation for sftp2.
  
  */

#include "sshincludes.h"

char *main_help =
"SFTP client Sftp2\r\n"
"Copyright (c) 1999, 2000, 2002 SSH Communications Security, Finland.\r\n\r\n"
"Type 'help <topic>', where <topic> is one of the following commands:\r\n\r\n"
"open            lopen           close           quit            cd\r\n"
"lcd             pwd             lpwd            ls              lls\r\n"
"get             mget            put             mput            rm\r\n"
"lrm             mkdir           lmkdir          rmdir           lrmdir\r\n"
"rename          lrename         readlink        lreadlink       symlink\r\n"
"lsymlink        ascii           binary          auto            setext\r\n"
"getext          lsroots         "



"debug           verbose"



"         "

"help\r\n"
"\r\n";

char *helps[][2] = {
  { "open",
    "open [ <hostname> | -l ]\r\n"
    "Tries to connect to the host <hostname>. Or with the -l option,\r\n"
    "connects the remote side to the local filesystem (which doesn't\r\n"
    "require a server).\r\n" },
  { "lopen",
    "lopen [ <hostname> | -l ]\r\n"
    "Tries to connect the local side to the host <hostname>. If\r\n"
    "successful, \"lls\" and friends will show the contents of the\r\n"
    "filesystem on that host. With the -l option, connects to the local\r\n"
    "filesystem (which doesn't require a server).\r\n" },
  { "close",
    "close\r\n"
    "Closes the current session.\r\n" },
  { "quit",
    "quit\r\n"
    "Quits the application.\r\n" },
  { "cd",
    "cd <directory>\r\n"
    "Changes the current remote working directory.\r\n" },
  { "lcd",
    "lcd <directory>\r\n"
    "Changes the current local working directory.\r\n" },
  { "pwd",
    "pwd\r\n"
    "Prints the name of the current remote working directory.\r\n" },
  { "lpwd",
    "lpwd\r\n"
    "Prints the name of the current local working directory.\r\n" },
  { "ls",
    "ls [ -R ] [ -l ] [ <file> ... ]\r\n"
    "Lists the names of files on the remote server. For directories,\r\n"
    "contents are listed. When the -R is given, directory trees are\r\n"
    "listed recursively. (By default, subdirectories of the arguments\r\n"
    "are not visited.) When the -l option is given, permissions, owners,\r\n"
    "sizes and modification times are also shown. When given no\r\n"
    "arguments, assumes that the contents of . are being listed.\r\n"
    "Currently the options -R and -l are mutually incompatible.\r\n" },
  { "lls",
    "lls [ -R ] [ -l ] [ <file> ... ]\r\n"
    "Same as ls, but operates on the local files.\r\n" },
  { "get",
    "get [ <file> ... ]\r\n"
    "Transfers the specified files from the remote end to the local end.\r\n"
    "Directories are recursively copied with their contents.\r\n" },
  { "mget",
    "mget [ <file> ... ]\r\n"
    "Synonymous to get.\r\n" },
  { "put",
    "put [ <file> ... ]\r\n"
    "Transfers the specified files from the local end to the remote end.\r\n"
    "Directories are recursively copied with their contents.\r\n" },
  { "mput",
    "mput [ <file> ... ]\r\n"
    "Synonymous to put.\r\n" },
  { "rm",
    "rm <file>\r\n"
    "Tries to delete the file specified in <file>\r\n." },
  { "lrm",
    "lrm <file>\r\n"
    "Same as rm, but operates on the local files.\r\n" },
  { "mkdir",
    "mkdir <directory>\r\n"
    "Tries to create the directory specified in <directory>\r\n" },
  { "lmkdir",
    "Same as mkdir, but operates on the local files.\r\n" },
  { "rmdir",
    "rmdir <directory>\r\n"
    "Tries to delete the directory specified in <directory>\r\n" },
  { "lrmdir",
    "Same as rmdir, but operates on the local files.\r\n" },
  { "rename",
    "rename <oldfile> <newfile>\r\n"
    "Tries to rename the <oldfile> to <newfile>. If <newfile> already\r\n"
    "exists, the files are left intact.\r\n" },
  { "lrename",
    "Same as rename, but operates on the local files.\r\n" },
  { "readlink",
    "readlink <path>\r\n"
    "Provided that <path> is a symbolic link, shows where the link is\r\n"
    "pointing to.\r\n" },
  { "lreadlink",
    "Same as readlink, but operates on the local files.\r\n"},
  { "symlink",
    "symlink <targetpath> <linkpath>\r\n"
    "Creates symbolic link <linkpath>, which will point to <targetpath>.\r\n"
  },
  { "lsymlink",
    "Same as symlink, but operates on the local files.\r\n"},
  { "ascii",
    "ascii [-s] [-f] [<remote_nl_conv>] [<local_nl_conv>]\r\n"
    "With -s option, shows current newline convention. With \"-f\" option,\r\n"
    "favors this configuration over what server notifies during connection\r\n"
    "(this option mainly for testing). <remote_nl_conv> sets remote\r\n"
    "newline convention. <local_nl_conv> operates on local side, but is\r\n"
    "not as useful (the correct local newline convention is usually\r\n"
    "compiled in, so this is mainly for testing). You can set either of\r\n"
    "these to \"ask\", which will cause sftp to prompt you for the\r\n"
    "newline convention when needed. With the exception of \"-s\" option,\r\n"
    "this command sets transfer mode to ascii. Available conventions are\r\n"
    "\"dos\", \"unix\" or \"mac\", using \"\\r\\n\", \"\\n\" and \"\\r\"\r\n"
    "as newlines, respectively.\r\n" },
  { "binary",
    "binary\r\n"
    "Files will be transfered in binary mode.\r\n" },
  { "auto",
    "auto\r\n"
    "File transfer mode will be selected automatically from the file\r\n"
    "extension.\r\n" },
  { "setext",
    "setext [ <extension> ... ]\r\n"
    "Sets the file extensions that will be ascii in the auto transfer\r\n"
    "mode. Normal zsh-fileglob regexs can be used in the file "
    "extensions.\r\n" },
  { "getext",
    "getext\r\n"
    "Displays the extensions that will be ascii in the auto transfer\r\n"
    "mode.\r\n" },
  { "lsroots",
    "lsroots\r\n"
    "Dumps the virtual roots of the server (this is a VShell extension.\r\n"
    "Without this you can't know the filesystem structure of a VShell\r\n"
    "server).\r\n"},
  { "setmask",
    "setmask <umask>\r\n"
    "Set the default file permission mask for upload.\r\n" },
  { "debug",
    "debug [disable | no | <debuglevel>]\r\n"
    "With \"disable\" or \"no\", disables debugging. Otherwise,\r\n"
    "sets <debuglevel> as debug level string, as per command-line\r\n"
    "option \"-D\".\r\n" },
  { "verbose",
    "verbose\r\n"
    "Enables verbose mode (identical to \"-D 2\" command-line option).\r\n"
    "You may later disable verbose mode by 'debug disable'.\r\n" },
  { "help",
    "help [ <topic> ]\r\n"
    "If <topic> is not given, lists the available topics. If <topic> is\r\n"
    "given, outputs available online help about the topic.\r\n" },
  { NULL, NULL }
};

void
ssh_sftp_print_help(char *topic)
{
  int i = 0;
  if (topic == NULL)
    {
      printf(main_help);
      return;
    }
  do {
    if (!strcmp(topic, helps[i][0]))
    {
      printf(helps[i][1]);
      return;
    }
    i++;
  } while (helps[i][0] != NULL);
  printf("Sorry, no help about topic '%s' available.\r\n", topic);
}
