/*
  auths-pubkey.h

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.
                  
  Public key authentication, server-side.
*/

#ifndef AUTHS_PUBKEY_H
#define AUTHS_PUBKEY_H

#include "sshuser.h"

/* Public key authentication for the server side. */

void ssh_server_auth_pubkey(SshAuthServerOperation op,
                            const char *user,
                            SshUser uc,
                            SshBuffer packet,
                            const unsigned char *session_id,
                            size_t session_id_len,
                            void **state_placeholder,
                            void **longtime_placeholder,
                            SshAuthServerCompletionProc completion_proc,
                            void *completion_context,
                            void *method_context);
#endif /* AUTHS_PUBKEY_H */
