/*

  auths-pam.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  PAM (Pluggable Authentication Modules) authentication, server side.
  
*/

#ifndef AUTHS_PAM_H
#define AUTHS_PAM_H
#ifdef DAEMON_WITH_PAM

/* Function used to represent an authentication method.  This function
   performs all processing by the authentication method.  An authentication
   method is policy-independent.
     `user'         user name from the (original) authentication request
     `packet'       method-specific remaining part of the packet
     `session_id'   session identifier
     `session_id_len' length of session identifier
     `state_placeholder' place to store context data between packets
     `longtime_placeholder'  can hold data between authentications
                    (this is per-method)
     `completion_proc'  callback, that notifies the authentication protocol
                        on the result of the authentication method.
     `completion_context' context for `completion_proc'
     `method_context'   passed to the method function */
void ssh_server_auth_pam(SshAuthServerOperation op,
                         const char *user,
                         SshUser uc,
                         SshBuffer packet,
                         const unsigned char *session_id,
                         size_t session_id_len,
                         void **state_placeholder,
                         void **longtime_placeholder,
                         SshAuthServerCompletionProc completion_proc,
                         void *completion_context, 
                         void *method_context);

#endif /* DAEMON_WITH_PAM */
#endif /* AUTHS_PAM_H */
