#!/bin/sh

# New value every 5 mins
# Storing 1 year of data
#
# Traffic from the outside world:
# 	- External bytes in
#	- External bytes out
#
# Traffic sourced from ourselves:
# 	- Internal bytes in
#	- Internal bytes out

for f in all ssh pop imap smtp http ftp im mysql dns misc
	do
	
		# Store taffic in 5 minute chunks, with a historical
		# 5-minute maximum for one year
		echo "Creating: flowd_$f.rrd"
		rrdtool create \
				flowd_$f.rrd \
				--start=1145356200 \
				--step=300 \
				DS:ext_bytes_in:GAUGE:300:0:9999999999 \
				DS:ext_bytes_out:GAUGE:300:0:9999999999 \
				DS:int_bytes_in:GAUGE:300:0:9999999999 \
				DS:int_bytes_out:GAUGE:300:0:9999999999 \
				RRA:MAX:0.5:1:105120
	done