%{
#include "mapix.h"
#include <atlbase.h>
#include "PythonCOM.h"

%}

typedef long HRESULT;	// This will raise COM Exception.
%typedef long HRESULT_KEEP; // This will keep HRESULT, and return
typedef long FLAGS;


%typemap(python,out) HRESULT {
	$target = Py_None;
	Py_INCREF(Py_None);
}

%typemap(python,except) HRESULT {
      Py_BEGIN_ALLOW_THREADS
      $function
      Py_END_ALLOW_THREADS
      if (FAILED($source))  {
           $cleanup
           return OleSetOleError($source);
      }
}

%typemap(python,in) IID *INPUT(IID temp)
{
	$target = &temp;
	if (!PyCom_CLSIDFromPyObject($source, $target))
		return NULL;
}

%typemap(python,in) IID *INPUT_NULLOK(IID temp)
{
	if ($source==Py_None)
		$target = NULL;
	else {
		$target = &temp;
		if (!PyCom_CLSIDFromPyObject($source, $target))
			return NULL;
	}
}

%typemap(python,ignore) IUnknown **OUTPUT(IUnknown *temp)
{
  $target = &temp;
}

%{
#define MAKE_OUTPUT_INTERFACE(source, target, iid) \
{ \
    PyObject *o; \
    o = PyCom_PyObjectFromIUnknown(*source, iid, FALSE /* bAddRef */); \
    if ((!target) || (target == Py_None)) { \
      target = o; \
    } else { \
      if (!PyList_Check(target)) { \
        PyObject *o2 = target; \
        target = PyList_New(0); \
        PyList_Append(target,o2); \
        Py_XDECREF(o2); \
      } \
      PyList_Append(target,o); \
      Py_XDECREF(o); \
    } \
}
%}

%typemap(python,argout) IUnknown **OUTPUT {
	MAKE_OUTPUT_INTERFACE($source, $target, IID_IUnknown)
//	$target = PyCom_PyObjectFromIUnknown(*$source, IID_IUnknown, FALSE /* bAddRef */);
}

%typemap(python,in) IUnknown *INPUT {
	if (!PyCom_InterfaceFromPyInstanceOrObject($source, IID_IUnknown, (void **)&$target, 0))
		return NULL;
}

%typemap(python,in) IUnknown *INPUT_NULLOK {
	if (!PyCom_InterfaceFromPyInstanceOrObject($source, IID_IUnknown, (void **)&$target, 1))
		return NULL;
}

%typemap(python,freearg) IUnknown *INPUT,
                         IUnknown *INPUT_NULLOK,
                         IMessage *INPUT,
                         IMessage *INPUT_NULLOK,
                         IMAPITable *INPUT,
                         IMAPITable *INPUT_NULLOK,
						 IMAPISession *INPUT,
						 IMAPISession *INPUT_NULLOK,
						 IMAPIFolder *INPUT,
						 IMAPIFolder *INPUT_NULLOK,
						 IMAPIProp *INPUT,
						 IMAPIProp *INPUT_NULLOK,
						 IMAPIProgress *INPUT,
						 IMAPIProgress *INPUT_NULLOK,
						 IAttach *INPUT,
						 IAttach *INPUT_NULLOK
{
	if ($source) $source->Release();
}

%typemap(python,arginit) IUnknown *,
                         IMAPISession *,
                         IMAPITable *,
                         IMAPIFolder *,
                         IMessage *,
                         IMAPIProp *,
						 IMAPIProgress *,
						 IAttach *
{
	$target = NULL;
}

