/* File : mapi.i */

%module mapi // An COM interface to MAPI

//%{
//#define UNICODE
//%}


%include "typemaps.i"
%include "pywin32.i"
%include "pythoncom.i"
%include "mapilib.i"

%{
#include <mapiutil.h>
#include "PyIMAPIProp.h"
#include "PyIMAPITable.h"
#include "PyIMAPISession.h"
#include "PyIMAPIContainer.h"
#include "PyIMAPIFolder.h"
#include "PyIMessage.h"
#include "PyIMsgStore.h"
#include "PyIAttach.h"
#include "PyIProfAdmin.h"
#include "PyIAddrBook.h"

#include "EDKMDB.H"
#include "EDKMAPI.H"
#include "EDKCFG.H"
#include "EDKUTILS.H"
#include "MBLOGON.H"
%}

%{
int AddIID(PyObject *dict, const char *key, REFGUID guid)
{
	PyObject *obiid = PyCom_PyIIDObjectFromIID(guid);
	if (!obiid) return 1;
	int rc = PyDict_SetItemString(dict, (char*)key, obiid);
	PyTS_DECREF(obiid);
	return rc;
}

#define ADD_CONSTANT(tok) AddConstant(dict, #tok, tok)
#define ADD_IID(tok) AddIID(d, #tok, tok)

// @pyswig string|HrMAPIFindDefaultMsgStore|
static PyObject *PyHrMAPIFindDefaultMsgStore(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	ULONG entryStrLen;
	ENTRYID *pID;
    IMAPISession * pS = NULL;
	PyObject *obSession;

	// @pyparm <o PyIMAPISession>|session||
    if(!PyArg_ParseTuple(args,"O:HrMAPIFindDefaultMsgStore",&obSession)) 
        return NULL;

	if (!PyCom_InterfaceFromPyInstanceOrObject(obSession, IID_IMAPISession, (void **)&pS, 0))
		return NULL;

     _result = (HRESULT )HrMAPIFindDefaultMsgStore(pS, &entryStrLen, &pID);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 PyObject *rc = PyString_FromStringAndSize((char *)pID, entryStrLen);
	 MAPIFreeBuffer(pID);
	 return rc;
}

// @pyswig string|HrMAPIFindIPMSubtree|
static PyObject *PyHrMAPIFindIPMSubtree(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	ULONG entryStrLen;
	ENTRYID *pID;
    IMsgStore * pS = NULL;
	PyObject *obStore;

	// @pyparm <o PyIMsgStore>|msgStore||
    if(!PyArg_ParseTuple(args,"O:HrMAPIFindIPMSubtree",&obStore)) 
        return NULL;

	if (!PyCom_InterfaceFromPyInstanceOrObject(obStore, IID_IMsgStore, (void **)&pS, 0))
		return NULL;

     _result = (HRESULT )HrMAPIFindIPMSubtree(pS, &entryStrLen, &pID);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 PyObject *rc = PyString_FromStringAndSize((char *)pID, entryStrLen);
	 MAPIFreeBuffer(pID);
	 return rc;
}

// @pyswig string|HrMAPIFindInbox|
static PyObject *PyHrMAPIFindInbox(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	ULONG entryStrLen;
	ENTRYID *pID;
    IMsgStore * pS = NULL;
	PyObject *obStore;

	// @pyparm <o PyIMsgStore>|msgStore||
    if(!PyArg_ParseTuple(args,"O:HrMAPIFindInbox",&obStore)) 
        return NULL;

	if (!PyCom_InterfaceFromPyInstanceOrObject(obStore, IID_IMsgStore, (void **)&pS, 0))
		return NULL;

     _result = (HRESULT )HrMAPIFindInbox(pS, &entryStrLen, &pID);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 PyObject *rc = PyString_FromStringAndSize((char *)pID, entryStrLen);
	 MAPIFreeBuffer(pID);
	 return rc;
}

// @pyswig <o PyUnicode>|HrCreateProfileName|Creates a profile name
static PyObject *PyHrCreateProfileName(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	PyObject *obPrefix;
	TCHAR *prefix;
	// @pyparm string/<o PyUnicode>|profPrefix||A prefix for the new profile.
	if (!PyArg_ParseTuple(args, "O:HrCreateProfileName", &obPrefix))
		return NULL;
	if (!PyWinObject_AsTCHAR(obPrefix, &prefix))
		return NULL;
	const int bufSize = MAX_PATH + 1;
	TCHAR buf[bufSize];
	_result = HrCreateProfileName(prefix, bufSize, buf);
	if (FAILED(_result))
		return OleSetOleError(_result);
	PyObject *rc = PyWinObject_FromTCHAR(buf);
	PyWinObject_FreeTCHAR(prefix);
	return rc;
}

// @pyswig <o PyUnicode>|HexFromBin|converts a binary number into a string representation of a hexadecimal number.
// @comm Note: This function may not be supported in future versions of MAPI.
static PyObject *PyHexFromBin(PyObject *self, PyObject *args) 
{
	char *szData;
	int dataSize;
	if (!PyArg_ParseTuple(args, "s#:HexFromBix", &szData, &dataSize))
		return NULL;
	TCHAR *buf = (TCHAR *)malloc(((dataSize*sizeof(TCHAR))*2)+1);
	HexFromBin((LPBYTE)szData, dataSize, buf);
	PyObject *result;
	result = PyWinObject_FromTCHAR(buf);
	free(buf);
	return result;
}

// @pyswig <o PyUnicode>|BinFromHex|converts a hexadecimal number into a binary string
static PyObject *PyBinFromHex(PyObject *self, PyObject *args) 
{
	PyObject *obHex;
	if (!PyArg_ParseTuple(args, "O:BinFromHex", &obHex))
		return NULL;
	DWORD strSize;
	TCHAR *tchar;
	if (!PyWinObject_AsTCHAR( obHex, &tchar, FALSE, &strSize ))
		return NULL;

	BYTE *buf = (BYTE *)malloc(((strSize*sizeof(TCHAR))/2)+1);
	if (!FBinFromHex(tchar, buf)) {
		PyErr_SetString(PyExc_ValueError, "FBinFromHex failed - input data is invalid");
		return NULL;
	}
	PyObject *rc = PyString_FromStringAndSize((char *)buf, strSize/2);
	free(buf);
	PyWinObject_FreeTCHAR(tchar);
	return rc;
}

static PyObject *PyMAPIUninitialize(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":MAPIUninitialize"))
		return NULL;
	PyObject *rc;
	__try {
		MAPIUninitialize();
		rc = Py_None;
		Py_INCREF(Py_None);
	}
	__except (GetExceptionCode() == STATUS_INVALID_HANDLE) {
		PyWin_SetAPIError("MAPIUninitialize", ERROR_INVALID_HANDLE);
		rc = NULL;
	}
	return rc;
}

%}

%init %{
	if ( PyCom_RegisterClientType(&PyIMAPISession::type, &IID_IMAPISession) != 0 ) return;
	ADD_IID(IID_IMAPISession);

	if ( PyCom_RegisterClientType(&PyIMAPITable::type, &IID_IMAPITable) != 0 ) return;
	ADD_IID(IID_IMAPITable);

	if ( PyCom_RegisterClientType(&PyIMAPIProp::type, &IID_IMAPIProp) != 0 ) return;
	ADD_IID(IID_IMAPIProp);

	if ( PyCom_RegisterClientType(&PyIMAPIFolder::type, &IID_IMAPIFolder) != 0 ) return;
	ADD_IID(IID_IMAPIFolder);

	if ( PyCom_RegisterClientType(&PyIMAPIContainer::type, &IID_IMAPIContainer) != 0 ) return;
	ADD_IID(IID_IMAPIContainer);

	if ( PyCom_RegisterClientType(&PyIMessage::type, &IID_IMessage) != 0 ) return;
	ADD_IID(IID_IMessage);

	if ( PyCom_RegisterClientType(&PyIMsgStore::type, &IID_IMsgStore) != 0 ) return;
	ADD_IID(IID_IMsgStore);

	if ( PyCom_RegisterClientType(&PyIAttach::type, &IID_IAttachment) != 0 ) return;
	ADD_IID(IID_IAttachment);

	if ( PyCom_RegisterClientType(&PyIProfAdmin::type, &IID_IProfAdmin) != 0 ) return;
	ADD_IID(IID_IProfAdmin);

	if ( PyCom_RegisterClientType(&PyIAddrBook::type, &IID_IAddrBook) != 0 ) return;
	ADD_IID(IID_IAddrBook);

	ADD_IID(PS_PUBLIC_STRINGS);
	ADD_IID(PS_MAPI);
	ADD_IID(PS_ROUTING_EMAIL_ADDRESSES);
	ADD_IID(PS_ROUTING_ADDRTYPE);
	ADD_IID(PS_ROUTING_DISPLAY_NAME);
	ADD_IID(PS_ROUTING_ENTRYID);
	ADD_IID(PS_ROUTING_SEARCH_KEY);

%}

#define MAPI_DIALOG MAPI_DIALOG 

#define MAPI_ASSOCIATED MAPI_ASSOCIATED // The containers associated contents table should be returned rather than the standard contents table. This flag is used only with folders. The messages that are included in the associated contents table were created with the MAPI_ASSOCIATED flag set in the call to IMAPIFolder::CreateMessage. Clients typically use the associated contents table to retrieve forms and views. 

#define MAPI_ALLOW_OTHERS MAPI_ALLOW_OTHERS // The shared session should be returned, allowing subsequent clients to acquire the session without providing any user credentials. 

#define MAPI_EXPLICIT_PROFILE MAPI_EXPLICIT_PROFILE // The default profile should not be used, and the user should be required to supply a profile. 

#define MAPI_EXTENDED MAPI_EXTENDED // Log on with extended capabilities. This flag should always be set. The older MAPILogon function is no longer available. 

#define MAPI_FORCE_DOWNLOAD MAPI_FORCE_DOWNLOAD // An attempt should be made to download all of the users messages before returning. If the MAPI_FORCE_DOWNLOAD flag is not set, messages can be downloaded in the background after the call to MAPILogonExreturns. 

#define MAPI_LOGON_UI MAPI_LOGON_UI // A dialog box should be displayed to prompt the user for logon information if required. When the MAPI_LOGON_UI flag is not set, the calling client does not display a logon dialog box and returns an error value if the user is not logged on. MAPI_LOGON_UI and MAPI_PASSWORD_UI are mutually exclusive. 

#define MAPI_NEW_SESSION MAPI_NEW_SESSION // An attempt should be made to create a new MAPI session rather than acquire the shared session. If the MAPI_NEW_SESSION flag is not set, MAPILogonEx uses an existing shared session even if the lpszprofileNameparameter is not NULL. 

#define MAPI_NO_MAIL MAPI_NO_MAIL // MAPI should not inform the MAPI spooler of the sessions existence. The result is that no messages can be sent or received within the session except through a tightly coupled store and transport pair. A calling client sets this flag if it is acting as an agent, if configuration work must be done, or if the client is browsing the available message stores. 

#define MAPI_MULTITHREAD_NOTIFICATIONS MAPI_MULTITHREAD_NOTIFICATIONS // MAPI should generate notifications using a thread dedicated to notification handling rather than the first thread used to call <om mapi.MAPIInitialize>.

#define MAPI_NT_SERVICE MAPI_NT_SERVICE // The caller is running as a Windows NT service. Callers that are not running as a Windows NT service should not set this flag; callers that are running as a service must set this flag. 

#define MAPI_PASSWORD_UI MAPI_PASSWORD_UI // A dialog box should be displayed to prompt the user for the profile password. MAPI_PASSWORD_UI cannot be set if MAPI_LOGON_UI is set because the calling client can only present one of the two dialog boxes. This dialog box does not allow the profile name to be changed; the lpszProfileNameparameter must be non-NULL. 

#define MAPI_SERVICE_UI_ALWAYS MAPI_SERVICE_UI_ALWAYS // MAPILogonExshould display a configuration dialog box for each message service in the profile. The dialog boxes are displayed after the profile has been chosen but before any message service is logged on. The MAPI common dialog box for logon also contains a check box that requests the same operation. 

#define MAPI_TIMEOUT_SHORT MAPI_TIMEOUT_SHORT // The logon should fail if blocked for more than a few seconds. 

#define MAPI_UNICODE MAPI_UNICODE // The passed-in strings are in Unicode format. If the MAPI_UNICODE flag is not set, the strings are in ANSI format. 

#define MAPI_USE_DEFAULT MAPI_USE_DEFAULT // The messaging subsystem should substitute the profile name of the default profilefor the lpszProfileNameparameter. The MAPI_EXPLICIT_PROFILE flag is ignored unless lpszProfileNameis NULL or empty. 

#define FORCE_SAVE FORCE_SAVE // Changes should be written to the object, overriding any previous changes made to the object, and the object closed. Read/write access must have been set for the operation to succeed. The FORCE_SAVE flag is used after a previous call to SaveChangesreturned MAPI_E_OBJECT_CHANGED. 

#define KEEP_OPEN_READONLY KEEP_OPEN_READONLY // Changes should be committed and the object should be kept open for reading. No further changes will be made. 

#define KEEP_OPEN_READWRITE KEEP_OPEN_READWRITE // Changes should be committed and the object should be kept open for read/write access. This flag is usually set when the object was initially opened for read/write access. Subsequent changes to the object are allowed. 

#define MAPI_DEFERRED_ERRORS MAPI_DEFERRED_ERRORS // Allows a methodto return successfully, possibly before the changes have been fully committed. 

#define FOLDER_GENERIC FOLDER_GENERIC // A generic folder should be created. 

#define FOLDER_SEARCH FOLDER_SEARCH // A search-results folder should be created. 

#define CONVENIENT_DEPTH CONVENIENT_DEPTH // Fills the hierarchy table with containers from multiple levels. If CONVENIENT_DEPTH is not set, the hierarchy table contains only the containers immediate child containers. 

#define MAPI_BEST_ACCESS MAPI_BEST_ACCESS

#define MAPI_MODIFY MAPI_MODIFY

#define MDB_NO_DIALOG MDB_NO_DIALOG // Prevents the display of logon dialog boxes. If this flag is set, and OpenMsgStore does not have enough configuration information to open the message store without the users help, it returns MAPI_E_LOGON_FAILED. If this flag is not set, the message store provider can prompt the user to correct a name or password, to insert a disk, or to perform other actions necessary to establish connection to the message store. 

#define MDB_NO_MAIL MDB_NO_MAIL // The message store should not be used for sending or receiving mail. When this flag is set, MAPI does not notify the MAPI spooler that this message store is being opened. 

#define MDB_TEMPORARY MDB_TEMPORARY // Instructs MAPI that the message store is not permanent and should not be added to the message store table. This flag is used to log on the message store so that information can be retrieved programmatically from the profile section. 

#define MDB_WRITE MDB_WRITE // Requests read/write access to the message store. 

#define OPEN_IF_EXISTS OPEN_IF_EXISTS // Does not fail if the specified folder already exists.

#define MAPI_INIT_VERSION MAPI_INIT_VERSION

#define RTF_SYNC_BODY_CHANGED RTF_SYNC_BODY_CHANGED // The plain text version of the message has changed. 

#define RTF_SYNC_RTF_CHANGED RTF_SYNC_RTF_CHANGED // The RTF version of the message has changed. 

#define MAPI_CREATE MAPI_CREATE // The object will be created if necessary.

#define MAPI_E_CALL_FAILED								
#define MAPI_E_NOT_ENOUGH_MEMORY MAPI_E_NOT_ENOUGH_MEMORY
#define MAPI_E_INVALID_PARAMETER MAPI_E_INVALID_PARAMETER
#define MAPI_E_INTERFACE_NOT_SUPPORTED MAPI_E_INTERFACE_NOT_SUPPORTED
#define MAPI_E_NO_ACCESS MAPI_E_NO_ACCESS

#define MAPI_E_NO_SUPPORT MAPI_E_NO_SUPPORT
#define	MAPI_E_BAD_CHARWIDTH MAPI_E_BAD_CHARWIDTH
#define MAPI_E_STRING_TOO_LONG MAPI_E_STRING_TOO_LONG
#define MAPI_E_UNKNOWN_FLAGS MAPI_E_UNKNOWN_FLAGS
#define MAPI_E_INVALID_ENTRYID MAPI_E_INVALID_ENTRYID
#define MAPI_E_INVALID_OBJECT MAPI_E_INVALID_OBJECT
#define MAPI_E_OBJECT_CHANGED MAPI_E_OBJECT_CHANGED
#define MAPI_E_OBJECT_DELETED MAPI_E_OBJECT_DELETED
#define MAPI_E_BUSY MAPI_E_BUSY
#define MAPI_E_NOT_ENOUGH_DISK MAPI_E_NOT_ENOUGH_DISK
#define MAPI_E_NOT_ENOUGH_RESOURCES MAPI_E_NOT_ENOUGH_RESOURCES
#define MAPI_E_NOT_FOUND MAPI_E_NOT_FOUND
#define MAPI_E_VERSION MAPI_E_VERSION
#define MAPI_E_LOGON_FAILED MAPI_E_LOGON_FAILED
#define MAPI_E_SESSION_LIMIT MAPI_E_SESSION_LIMIT
#define MAPI_E_USER_CANCEL MAPI_E_USER_CANCEL
#define MAPI_E_UNABLE_TO_ABORT MAPI_E_UNABLE_TO_ABORT
#define MAPI_E_NETWORK_ERROR MAPI_E_NETWORK_ERROR
#define MAPI_E_DISK_ERROR MAPI_E_DISK_ERROR
#define MAPI_E_TOO_COMPLEX MAPI_E_TOO_COMPLEX
#define MAPI_E_BAD_COLUMN MAPI_E_BAD_COLUMN
#define MAPI_E_EXTENDED_ERROR MAPI_E_EXTENDED_ERROR
#define MAPI_E_COMPUTED MAPI_E_COMPUTED
#define MAPI_E_CORRUPT_DATA MAPI_E_CORRUPT_DATA
#define MAPI_E_UNCONFIGURED MAPI_E_UNCONFIGURED
#define MAPI_E_FAILONEPROVIDER MAPI_E_FAILONEPROVIDER
#define MAPI_E_UNKNOWN_CPID MAPI_E_UNKNOWN_CPID
#define MAPI_E_UNKNOWN_LCID MAPI_E_UNKNOWN_LCID

/* Flavors of E_ACCESSDENIED, used at logon */

#define MAPI_E_PASSWORD_CHANGE_REQUIRED MAPI_E_PASSWORD_CHANGE_REQUIRED
#define MAPI_E_PASSWORD_EXPIRED MAPI_E_PASSWORD_EXPIRED
#define MAPI_E_INVALID_WORKSTATION_ACCOUNT MAPI_E_INVALID_WORKSTATION_ACCOUNT
#define MAPI_E_INVALID_ACCESS_TIME MAPI_E_INVALID_ACCESS_TIME
#define MAPI_E_ACCOUNT_DISABLED MAPI_E_ACCOUNT_DISABLED

/* MAPI base function and status object specific errors and warnings */

#define MAPI_E_END_OF_SESSION MAPI_E_END_OF_SESSION
#define MAPI_E_UNKNOWN_ENTRYID MAPI_E_UNKNOWN_ENTRYID
#define MAPI_E_MISSING_REQUIRED_COLUMN MAPI_E_MISSING_REQUIRED_COLUMN
#define MAPI_W_NO_SERVICE MAPI_W_NO_SERVICE

/* Property specific errors and warnings */

#define MAPI_E_BAD_VALUE MAPI_E_BAD_VALUE
#define MAPI_E_INVALID_TYPE MAPI_E_INVALID_TYPE
#define MAPI_E_TYPE_NO_SUPPORT MAPI_E_TYPE_NO_SUPPORT
#define MAPI_E_UNEXPECTED_TYPE MAPI_E_UNEXPECTED_TYPE
#define MAPI_E_TOO_BIG MAPI_E_TOO_BIG
#define MAPI_E_DECLINE_COPY MAPI_E_DECLINE_COPY
#define MAPI_E_UNEXPECTED_ID MAPI_E_UNEXPECTED_ID

#define MAPI_W_ERRORS_RETURNED MAPI_W_ERRORS_RETURNED

/* Table specific errors and warnings */

#define MAPI_E_UNABLE_TO_COMPLETE MAPI_E_UNABLE_TO_COMPLETE
#define MAPI_E_TIMEOUT MAPI_E_TIMEOUT
#define MAPI_E_TABLE_EMPTY MAPI_E_TABLE_EMPTY
#define MAPI_E_TABLE_TOO_BIG MAPI_E_TABLE_TOO_BIG

#define MAPI_E_INVALID_BOOKMARK MAPI_E_INVALID_BOOKMARK

#define MAPI_W_POSITION_CHANGED MAPI_W_POSITION_CHANGED
#define MAPI_W_APPROX_COUNT MAPI_W_APPROX_COUNT

/* Transport specific errors and warnings */

#define MAPI_E_WAIT MAPI_E_WAIT
#define MAPI_E_CANCEL MAPI_E_CANCEL
#define MAPI_E_NOT_ME MAPI_E_NOT_ME

#define MAPI_W_CANCEL_MESSAGE MAPI_W_CANCEL_MESSAGE

/* Message Store, Folder, and Message specific errors and warnings */

#define MAPI_E_CORRUPT_STORE MAPI_E_CORRUPT_STORE
#define MAPI_E_NOT_IN_QUEUE MAPI_E_NOT_IN_QUEUE
#define MAPI_E_NO_SUPPRESS MAPI_E_NO_SUPPRESS
#define MAPI_E_COLLISION MAPI_E_COLLISION
#define MAPI_E_NOT_INITIALIZED MAPI_E_NOT_INITIALIZED
#define MAPI_E_NON_STANDARD MAPI_E_NON_STANDARD
#define MAPI_E_NO_RECIPIENTS MAPI_E_NO_RECIPIENTS
#define MAPI_E_SUBMITTED MAPI_E_SUBMITTED
#define MAPI_E_HAS_FOLDERS MAPI_E_HAS_FOLDERS
#define MAPI_E_HAS_MESSAGES MAPI_E_HAS_MESSAGES
#define MAPI_E_FOLDER_CYCLE MAPI_E_FOLDER_CYCLE

#define MAPI_W_PARTIAL_COMPLETION MAPI_W_PARTIAL_COMPLETION

/* Address Book specific errors and warnings */

#define MAPI_E_AMBIGUOUS_RECIP MAPI_E_AMBIGUOUS_RECIP

#define MODRECIP_ADD MODRECIP_ADD // The recipients should be added to the recipient list. 

#define MODRECIP_MODIFY MODRECIP_MODIFY // The recipients should replace existing recipients. All of the existing properties are replaced by those in the corresponding ADRENTRYstructure. 

#define MODRECIP_REMOVE MODRECIP_REMOVE // Existing recipients should be removed from the recipient list using as an index the PR_ROWIDproperty included in the property value array of each recipient entry in the modsparameter.

#define MAPI_TO MAPI_TO // The recipient is a primary (To) recipient. Clients are required to handle primary recipients; all other types are optional. 

#define MAPI_CC MAPI_CC // The recipient is a carbon copy (CC) recipient, a recipient that receives a message in addition to the primary recipients. 

#define MAPI_BCC MAPI_BCC // The recipient is a blind carbon copy (BCC) recipient. Primary and carbon copy recipients are unaware of the existence of BCC recipients. 

#define MAPI_P1 MAPI_P1 // The recipient did not successfully receive the message on the previous attempt. This is a resend of an earlier transmission. 

#define MAPI_SUBMITTED MAPI_SUBMITTED // The recipient has already received the message and does not need to receive it again. This is a resend of an earlier transmission. This flag is set in conjunction with the MAPI_TO, MAPI_CC, and MAPI_BCC values. 

#define AB_NO_DIALOG AB_NO_DIALOG 

#define BOOKMARK_BEGINNING BOOKMARK_BEGINNING // Starts the seek operation from the beginning of the table. 
#define BOOKMARK_CURRENT BOOKMARK_CURRENT // Starts the seek operation from the row in the table where the cursor is located. 
#define BOOKMARK_END BOOKMARK_END // Starts the seek operation from the end of the table.

HRESULT MAPIInitialize( MAPIINIT_0 *INPUT);

// @pyswig <o PyIMAPISession>|MAPILogonEx|
HRESULT MAPILogonEx( 
	ULONG INPUT, // @pyparm int|flags||
	TCHAR *inNullString, // @pyparm <o PyUnicode>|profileName||
	TCHAR *inNullString, // @pyparm <o PyUnicode>|password||
	FLAGS flFlags, // @pyparm int|uiFlags||
	IMAPISession **OUTPUT 
);

// @pyswig <o PyIProfAdmin>|MAPIAdminProfiles|
HRESULT MAPIAdminProfiles( 
	unsigned long ulFlags, // @pyparm int|fFlags||
	IProfAdmin **OUTPUT
);

// @pyswig |MAPIUninitialize|
%native (MAPIUninitialize) PyMAPIUninitialize;

// @pyswig <o PyIMAPIFolder>|HrMAPIOpenFolderEx|
%name(HrMAPIOpenFolderEx) HRESULT HrMAPIOpenFolderExW( 
	IMsgStore *INPUT_NULLOK, // @pyparm <o PyIMsgStore>|msgStore||
	WCHAR INPUT, // @pyparm string/<o PyUnicode>|sep||The folder seperator character.
	WCHAR *INPUT, // @pyparm string/<o PyUnicode>|name||The folder name
	IMAPIFolder **OUTPUT 
);

// @pyswig |HrMAPISetPropBoolean|Sets a boolean property.
HRESULT HrMAPISetPropBoolean(
	IMAPIProp *INPUT, // @pyparm <o PyIMAPIProp>|obj||The object to set
	unsigned long ulPropTag, // @pyparm int|tag||The property tag
	int INPUT // int|val||The boolean property value.
);

// @pyswig |HrMAPISetPropLong|Sets a long property.
HRESULT HrMAPISetPropLong(
	IMAPIProp *INPUT, // @pyparm <o PyIMAPIProp>|obj||The object to set
	unsigned long ulPropTag, // @pyparm int|tag||The property tag
	long INPUT // int|val||The property value.
);

%native(HrMAPIFindDefaultMsgStore) PyHrMAPIFindDefaultMsgStore;

%native(HrMAPIFindIPMSubtree) PyHrMAPIFindIPMSubtree;

%native (HrMAPIFindInbox) PyHrMAPIFindInbox;

%native (HexFromBin) PyHexFromBin;
%native (BinFromHex) PyBinFromHex;

// @pyswig <o PyIMsgStore>|HrOpenExchangePublicStore|
HRESULT HrOpenExchangePublicStore(
	IMAPISession *INPUT,  // @pyparm <o PyIMAPISession>|session||The MAPI session object
	IMsgStore **OUTPUT
);

// @pyswig <o PyIMsgStore>|HrOpenExchangePrivateStore|
HRESULT HrOpenExchangePrivateStore( 
	IMAPISession *INPUT,  // @pyparm <o PyIMAPISession>|session||The MAPI session object
	IMsgStore **OUTPUT
);

// @pyswig <o PyIMAPIFolder>|HrOpenExchangePublicFolders|
HRESULT HrOpenExchangePublicFolders( 
	IMsgStore *INPUT,  // @pyparm <o PyIMsgStore>|store||
	IMAPIFolder **OUTPUT
);

// @pyswig <o PyIMAPIProp>|HrOpenSessionObject|
HRESULT HrOpenSessionObject( 
	IMAPISession *INPUT,  // @pyparm <o PyIMAPISession>|session||The MAPI session object
	IMAPIProp **OUTPUT );

// @pyswig <o PyIMAPIProp>|HrOpenSiteContainer|
HRESULT HrOpenSiteContainer( 
	IMAPISession *INPUT,  // @pyparm <o PyIMAPISession>|session||The MAPI session object
	IMAPIProp **OUTPUT );

// @pyswig <o PyIMAPIProp>|HrOpenSiteContainerAddressing|
HRESULT HrOpenSiteContainerAddressing( 
	IMAPISession *INPUT, // @pyparm <o PyIMAPISession>|session||The MAPI session object
	IMAPIProp **OUTPUT 
);

// @pyswig <o SRowSet>|HrQueryAllRows|
HRESULT HrQueryAllRows( 
	IMAPITable *INPUT, // @pyparm <o PyIMAPITable>|table||
	SPropTagArray *INPUT, // @pyparm <o PySPropTagArray>|properties||
	SRestriction *INPUT, // @pyparm <o PySRestriction>|restrictions||
	SSortOrderSet *INPUT, // @pyparm <o PySSortOrderSet>|sortOrderSet||
	long crowsMax, // @pyparm int|rowsMax||
	SRowSet **OUTPUT);

// @pyswig int, int|HrGetExchangeStatus|
HRESULT HrGetExchangeStatus( 
	TCHAR *server, // @pyparm string/<o PyUnicode>|server||The name of the server to query.
	unsigned long *OUTPUT,
	unsigned long *OUTPUT
);

// @pyswig <o PyIMsgStore>|HrMailboxLogon|
HRESULT HrMailboxLogon(
	IMAPISession *INPUT, // @pyparm <o PyIMAPISession>|session||The session object
	IMsgStore *INPUT, // @pyparm <o PyIMsgStore>|msgStore||
	TCHAR *INPUT, // @pyparm string/<o PyUnicode>|msgStoreDN||
	TCHAR *INPUT, // @pyparm string/<o PyUnicode>|mailboxDN||
	IMsgStore **OUTPUT
);

%typemap(python,in) IMsgStore **INPUT (IMsgStore *temp) {
	$target = &temp;
	if (!PyCom_InterfaceFromPyInstanceOrObject($source, IID_IMsgStore, (void **)$target, 0))
		return NULL;
}
%typemap(python,freearg) IMsgStore **INPUT
{
	if ($source && *$source) (*$source)->Release();
}

%typemap(python,arginit) IMsgStore ** {
	$target = NULL;
}

// @pyswig |HrMailboxLogoff|Logs off a server and mailbox.
HRESULT HrMailboxLogoff(
	IMsgStore **INPUT // @pyparm <o PyIMsgStore>|inbox||The open inbox.
);

%{
PyObject *MyHrMAPIFindSubfolderEx(
	IMAPIFolder *lpRootFolder,
	TCHAR chSep,
	TCHAR *lpszName) 
{
	DWORD idSize;
	ENTRYID *id;
	HRESULT hr = HrMAPIFindSubfolderEx(lpRootFolder,chSep,lpszName,&idSize, &id);
	if (FAILED(hr))
		return OleSetOleError(hr);
	PyObject *rc = PyString_FromStringAndSize((char *)id, idSize);
	MAPIFreeBuffer(id);
	return rc;
}
%}
// @pyswig <o PyIMsgStore>|HrMAPIFindSubfolderEx|
%name(HrMAPIFindSubfolderEx) PyObject *MyHrMAPIFindSubfolderEx(
	IMAPIFolder *INPUT, // @pyparm <o PyIMAPIFolder>|rootFolder||The root folder.
	TCHAR chSep,	// @pyparm string/<o PyUnicode>|sep||The folder seperator character.
	TCHAR *INPUT // @pyparm string/<o PyUnicode>|name||The folder name
);

%typemap(python,in) IMsgStore **INPUT(IMsgStore *temp)
{
	$target = &temp;
	if (!PyCom_InterfaceFromPyInstanceOrObject($source, IID_IUnknown, (void **)&$target, 0))
		return NULL;
}

%native (HrCreateProfileName) PyHrCreateProfileName;

// @pyswig int|RTFSync|
HRESULT RTFSync(
	IMessage *INPUT, // @pyparm <o PyIMessage>|message||The message.
	unsigned long ulFlags, // @pyparm int|flags||
	int *OUTPUT // lpfMessageUpdated 
);

// @pyswig string|HrGetMailboxDN|
HRESULT HrGetMailboxDN(
	IMAPISession *INPUT, // @pyparm <o IMAPISession>|session||The root folder.
	TCHAR **OUTPUT_MAPI // mailboxDN
);

// @pyswig string|HrGetServerDN|
HRESULT HrGetServerDN(
	IMAPISession *INPUT, // @pyparm <o IMAPISession>|session||The root folder.
	TCHAR **OUTPUT_MAPI // mailboxDN
);
