/*
 * FILE : mapi.cpp
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 -3
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strncpy(temp_type,tp->name,255);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initmapi

#define SWIG_name    "mapi"

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                            
        if (!PyTuple_Check(target)) {   
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#include "windows.h"
#include "winbase.h"
#include "PyWinTypes.h"
#include "tchar.h"
typedef BOOL  BOOLAPI;

typedef HANDLE INT_HANDLE;

#include "mapix.h"
#include <atlbase.h>
#include "PythonCOM.h"

typedef long  HRESULT_KEEP;

#define MAKE_OUTPUT_INTERFACE(source, target, iid) \
{ \
    PyObject *o; \
    o = PyCom_PyObjectFromIUnknown(*source, iid, FALSE /* bAddRef */); \
    if ((!target) || (target == Py_None)) { \
      target = o; \
    } else { \
      if (!PyList_Check(target)) { \
        PyObject *o2 = target; \
        target = PyList_New(0); \
        PyList_Append(target,o2); \
        Py_XDECREF(o2); \
      } \
      PyList_Append(target,o); \
      Py_XDECREF(o); \
    } \
}

#include "pymapiutil.h"

#include <mapiutil.h>
#include "PyIMAPIProp.h"
#include "PyIMAPITable.h"
#include "PyIMAPISession.h"
#include "PyIMAPIContainer.h"
#include "PyIMAPIFolder.h"
#include "PyIMessage.h"
#include "PyIMsgStore.h"
#include "PyIAttach.h"
#include "PyIProfAdmin.h"
#include "PyIAddrBook.h"

#include "EDKMDB.H"
#include "EDKMAPI.H"
#include "EDKCFG.H"
#include "EDKUTILS.H"
#include "MBLOGON.H"

int AddIID(PyObject *dict, const char *key, REFGUID guid)
{
	PyObject *obiid = PyCom_PyIIDObjectFromIID(guid);
	if (!obiid) return 1;
	int rc = PyDict_SetItemString(dict, (char*)key, obiid);
	PyTS_DECREF(obiid);
	return rc;
}

#define ADD_CONSTANT(tok) AddConstant(dict, #tok, tok)
#define ADD_IID(tok) AddIID(d, #tok, tok)

// @pyswig string|HrMAPIFindDefaultMsgStore|
static PyObject *PyHrMAPIFindDefaultMsgStore(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	ULONG entryStrLen;
	ENTRYID *pID;
    IMAPISession * pS = NULL;
	PyObject *obSession;

	// @pyparm <o PyIMAPISession>|session||
    if(!PyArg_ParseTuple(args,"O:HrMAPIFindDefaultMsgStore",&obSession)) 
        return NULL;

	if (!PyCom_InterfaceFromPyInstanceOrObject(obSession, IID_IMAPISession, (void **)&pS, 0))
		return NULL;

     _result = (HRESULT )HrMAPIFindDefaultMsgStore(pS, &entryStrLen, &pID);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 PyObject *rc = PyString_FromStringAndSize((char *)pID, entryStrLen);
	 MAPIFreeBuffer(pID);
	 return rc;
}

// @pyswig string|HrMAPIFindIPMSubtree|
static PyObject *PyHrMAPIFindIPMSubtree(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	ULONG entryStrLen;
	ENTRYID *pID;
    IMsgStore * pS = NULL;
	PyObject *obStore;

	// @pyparm <o PyIMsgStore>|msgStore||
    if(!PyArg_ParseTuple(args,"O:HrMAPIFindIPMSubtree",&obStore)) 
        return NULL;

	if (!PyCom_InterfaceFromPyInstanceOrObject(obStore, IID_IMsgStore, (void **)&pS, 0))
		return NULL;

     _result = (HRESULT )HrMAPIFindIPMSubtree(pS, &entryStrLen, &pID);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 PyObject *rc = PyString_FromStringAndSize((char *)pID, entryStrLen);
	 MAPIFreeBuffer(pID);
	 return rc;
}

// @pyswig string|HrMAPIFindInbox|
static PyObject *PyHrMAPIFindInbox(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	ULONG entryStrLen;
	ENTRYID *pID;
    IMsgStore * pS = NULL;
	PyObject *obStore;

	// @pyparm <o PyIMsgStore>|msgStore||
    if(!PyArg_ParseTuple(args,"O:HrMAPIFindInbox",&obStore)) 
        return NULL;

	if (!PyCom_InterfaceFromPyInstanceOrObject(obStore, IID_IMsgStore, (void **)&pS, 0))
		return NULL;

     _result = (HRESULT )HrMAPIFindInbox(pS, &entryStrLen, &pID);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 PyObject *rc = PyString_FromStringAndSize((char *)pID, entryStrLen);
	 MAPIFreeBuffer(pID);
	 return rc;
}

// @pyswig <o PyUnicode>|HrCreateProfileName|Creates a profile name
static PyObject *PyHrCreateProfileName(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
	PyObject *obPrefix;
	TCHAR *prefix;
	// @pyparm string/<o PyUnicode>|profPrefix||A prefix for the new profile.
	if (!PyArg_ParseTuple(args, "O:HrCreateProfileName", &obPrefix))
		return NULL;
	if (!PyWinObject_AsTCHAR(obPrefix, &prefix))
		return NULL;
	const int bufSize = MAX_PATH + 1;
	TCHAR buf[bufSize];
	_result = HrCreateProfileName(prefix, bufSize, buf);
	if (FAILED(_result))
		return OleSetOleError(_result);
	PyObject *rc = PyWinObject_FromTCHAR(buf);
	PyWinObject_FreeTCHAR(prefix);
	return rc;
}

// @pyswig <o PyUnicode>|HexFromBin|converts a binary number into a string representation of a hexadecimal number.
// @comm Note: This function may not be supported in future versions of MAPI.
static PyObject *PyHexFromBin(PyObject *self, PyObject *args) 
{
	char *szData;
	int dataSize;
	if (!PyArg_ParseTuple(args, "s#:HexFromBix", &szData, &dataSize))
		return NULL;
	TCHAR *buf = (TCHAR *)malloc(((dataSize*sizeof(TCHAR))*2)+1);
	HexFromBin((LPBYTE)szData, dataSize, buf);
	PyObject *result;
	result = PyWinObject_FromTCHAR(buf);
	free(buf);
	return result;
}

// @pyswig <o PyUnicode>|BinFromHex|converts a hexadecimal number into a binary string
static PyObject *PyBinFromHex(PyObject *self, PyObject *args) 
{
	PyObject *obHex;
	if (!PyArg_ParseTuple(args, "O:BinFromHex", &obHex))
		return NULL;
	DWORD strSize;
	TCHAR *tchar;
	if (!PyWinObject_AsTCHAR( obHex, &tchar, FALSE, &strSize ))
		return NULL;

	BYTE *buf = (BYTE *)malloc(((strSize*sizeof(TCHAR))/2)+1);
	if (!FBinFromHex(tchar, buf)) {
		PyErr_SetString(PyExc_ValueError, "FBinFromHex failed - input data is invalid");
		return NULL;
	}
	PyObject *rc = PyString_FromStringAndSize((char *)buf, strSize/2);
	free(buf);
	PyWinObject_FreeTCHAR(tchar);
	return rc;
}

static PyObject *PyMAPIUninitialize(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":MAPIUninitialize"))
		return NULL;
	PyObject *rc;
	__try {
		MAPIUninitialize();
		rc = Py_None;
		Py_INCREF(Py_None);
	}
	__except (GetExceptionCode() == STATUS_INVALID_HANDLE) {
		PyWin_SetAPIError("MAPIUninitialize", ERROR_INVALID_HANDLE);
		rc = NULL;
	}
	return rc;
}

static PyObject *_wrap_python_const_MAPI_DIALOG;
static PyObject *_wrap_python_const_MAPI_ASSOCIATED;
static PyObject *_wrap_python_const_MAPI_ALLOW_OTHERS;
static PyObject *_wrap_python_const_MAPI_EXPLICIT_PROFILE;
static PyObject *_wrap_python_const_MAPI_EXTENDED;
static PyObject *_wrap_python_const_MAPI_FORCE_DOWNLOAD;
static PyObject *_wrap_python_const_MAPI_LOGON_UI;
static PyObject *_wrap_python_const_MAPI_NEW_SESSION;
static PyObject *_wrap_python_const_MAPI_NO_MAIL;
static PyObject *_wrap_python_const_MAPI_MULTITHREAD_NOTIFICATIONS;
static PyObject *_wrap_python_const_MAPI_NT_SERVICE;
static PyObject *_wrap_python_const_MAPI_PASSWORD_UI;
static PyObject *_wrap_python_const_MAPI_SERVICE_UI_ALWAYS;
static PyObject *_wrap_python_const_MAPI_TIMEOUT_SHORT;
static PyObject *_wrap_python_const_MAPI_UNICODE;
static PyObject *_wrap_python_const_MAPI_USE_DEFAULT;
static PyObject *_wrap_python_const_FORCE_SAVE;
static PyObject *_wrap_python_const_KEEP_OPEN_READONLY;
static PyObject *_wrap_python_const_KEEP_OPEN_READWRITE;
static PyObject *_wrap_python_const_MAPI_DEFERRED_ERRORS;
static PyObject *_wrap_python_const_FOLDER_GENERIC;
static PyObject *_wrap_python_const_FOLDER_SEARCH;
static PyObject *_wrap_python_const_CONVENIENT_DEPTH;
static PyObject *_wrap_python_const_MAPI_BEST_ACCESS;
static PyObject *_wrap_python_const_MAPI_MODIFY;
static PyObject *_wrap_python_const_MDB_NO_DIALOG;
static PyObject *_wrap_python_const_MDB_NO_MAIL;
static PyObject *_wrap_python_const_MDB_TEMPORARY;
static PyObject *_wrap_python_const_MDB_WRITE;
static PyObject *_wrap_python_const_OPEN_IF_EXISTS;
static PyObject *_wrap_python_const_MAPI_INIT_VERSION;
static PyObject *_wrap_python_const_RTF_SYNC_BODY_CHANGED;
static PyObject *_wrap_python_const_RTF_SYNC_RTF_CHANGED;
static PyObject *_wrap_python_const_MAPI_CREATE;
static PyObject *_wrap_python_const_MAPI_E_NOT_ENOUGH_MEMORY;
static PyObject *_wrap_python_const_MAPI_E_INVALID_PARAMETER;
static PyObject *_wrap_python_const_MAPI_E_INTERFACE_NOT_SUPPORTED;
static PyObject *_wrap_python_const_MAPI_E_NO_ACCESS;
static PyObject *_wrap_python_const_MAPI_E_NO_SUPPORT;
static PyObject *_wrap_python_const_MAPI_E_BAD_CHARWIDTH;
static PyObject *_wrap_python_const_MAPI_E_STRING_TOO_LONG;
static PyObject *_wrap_python_const_MAPI_E_UNKNOWN_FLAGS;
static PyObject *_wrap_python_const_MAPI_E_INVALID_ENTRYID;
static PyObject *_wrap_python_const_MAPI_E_INVALID_OBJECT;
static PyObject *_wrap_python_const_MAPI_E_OBJECT_CHANGED;
static PyObject *_wrap_python_const_MAPI_E_OBJECT_DELETED;
static PyObject *_wrap_python_const_MAPI_E_BUSY;
static PyObject *_wrap_python_const_MAPI_E_NOT_ENOUGH_DISK;
static PyObject *_wrap_python_const_MAPI_E_NOT_ENOUGH_RESOURCES;
static PyObject *_wrap_python_const_MAPI_E_NOT_FOUND;
static PyObject *_wrap_python_const_MAPI_E_VERSION;
static PyObject *_wrap_python_const_MAPI_E_LOGON_FAILED;
static PyObject *_wrap_python_const_MAPI_E_SESSION_LIMIT;
static PyObject *_wrap_python_const_MAPI_E_USER_CANCEL;
static PyObject *_wrap_python_const_MAPI_E_UNABLE_TO_ABORT;
static PyObject *_wrap_python_const_MAPI_E_NETWORK_ERROR;
static PyObject *_wrap_python_const_MAPI_E_DISK_ERROR;
static PyObject *_wrap_python_const_MAPI_E_TOO_COMPLEX;
static PyObject *_wrap_python_const_MAPI_E_BAD_COLUMN;
static PyObject *_wrap_python_const_MAPI_E_EXTENDED_ERROR;
static PyObject *_wrap_python_const_MAPI_E_COMPUTED;
static PyObject *_wrap_python_const_MAPI_E_CORRUPT_DATA;
static PyObject *_wrap_python_const_MAPI_E_UNCONFIGURED;
static PyObject *_wrap_python_const_MAPI_E_FAILONEPROVIDER;
static PyObject *_wrap_python_const_MAPI_E_UNKNOWN_CPID;
static PyObject *_wrap_python_const_MAPI_E_UNKNOWN_LCID;
static PyObject *_wrap_python_const_MAPI_E_PASSWORD_CHANGE_REQUIRED;
static PyObject *_wrap_python_const_MAPI_E_PASSWORD_EXPIRED;
static PyObject *_wrap_python_const_MAPI_E_INVALID_WORKSTATION_ACCOUNT;
static PyObject *_wrap_python_const_MAPI_E_INVALID_ACCESS_TIME;
static PyObject *_wrap_python_const_MAPI_E_ACCOUNT_DISABLED;
static PyObject *_wrap_python_const_MAPI_E_END_OF_SESSION;
static PyObject *_wrap_python_const_MAPI_E_UNKNOWN_ENTRYID;
static PyObject *_wrap_python_const_MAPI_E_MISSING_REQUIRED_COLUMN;
static PyObject *_wrap_python_const_MAPI_W_NO_SERVICE;
static PyObject *_wrap_python_const_MAPI_E_BAD_VALUE;
static PyObject *_wrap_python_const_MAPI_E_INVALID_TYPE;
static PyObject *_wrap_python_const_MAPI_E_TYPE_NO_SUPPORT;
static PyObject *_wrap_python_const_MAPI_E_UNEXPECTED_TYPE;
static PyObject *_wrap_python_const_MAPI_E_TOO_BIG;
static PyObject *_wrap_python_const_MAPI_E_DECLINE_COPY;
static PyObject *_wrap_python_const_MAPI_E_UNEXPECTED_ID;
static PyObject *_wrap_python_const_MAPI_W_ERRORS_RETURNED;
static PyObject *_wrap_python_const_MAPI_E_UNABLE_TO_COMPLETE;
static PyObject *_wrap_python_const_MAPI_E_TIMEOUT;
static PyObject *_wrap_python_const_MAPI_E_TABLE_EMPTY;
static PyObject *_wrap_python_const_MAPI_E_TABLE_TOO_BIG;
static PyObject *_wrap_python_const_MAPI_E_INVALID_BOOKMARK;
static PyObject *_wrap_python_const_MAPI_W_POSITION_CHANGED;
static PyObject *_wrap_python_const_MAPI_W_APPROX_COUNT;
static PyObject *_wrap_python_const_MAPI_E_WAIT;
static PyObject *_wrap_python_const_MAPI_E_CANCEL;
static PyObject *_wrap_python_const_MAPI_E_NOT_ME;
static PyObject *_wrap_python_const_MAPI_W_CANCEL_MESSAGE;
static PyObject *_wrap_python_const_MAPI_E_CORRUPT_STORE;
static PyObject *_wrap_python_const_MAPI_E_NOT_IN_QUEUE;
static PyObject *_wrap_python_const_MAPI_E_NO_SUPPRESS;
static PyObject *_wrap_python_const_MAPI_E_COLLISION;
static PyObject *_wrap_python_const_MAPI_E_NOT_INITIALIZED;
static PyObject *_wrap_python_const_MAPI_E_NON_STANDARD;
static PyObject *_wrap_python_const_MAPI_E_NO_RECIPIENTS;
static PyObject *_wrap_python_const_MAPI_E_SUBMITTED;
static PyObject *_wrap_python_const_MAPI_E_HAS_FOLDERS;
static PyObject *_wrap_python_const_MAPI_E_HAS_MESSAGES;
static PyObject *_wrap_python_const_MAPI_E_FOLDER_CYCLE;
static PyObject *_wrap_python_const_MAPI_W_PARTIAL_COMPLETION;
static PyObject *_wrap_python_const_MAPI_E_AMBIGUOUS_RECIP;
static PyObject *_wrap_python_const_MODRECIP_ADD;
static PyObject *_wrap_python_const_MODRECIP_MODIFY;
static PyObject *_wrap_python_const_MODRECIP_REMOVE;
static PyObject *_wrap_python_const_MAPI_TO;
static PyObject *_wrap_python_const_MAPI_CC;
static PyObject *_wrap_python_const_MAPI_BCC;
static PyObject *_wrap_python_const_MAPI_P1;
static PyObject *_wrap_python_const_MAPI_SUBMITTED;
static PyObject *_wrap_python_const_AB_NO_DIALOG;
static PyObject *_wrap_python_const_BOOKMARK_BEGINNING;
static PyObject *_wrap_python_const_BOOKMARK_CURRENT;
static PyObject *_wrap_python_const_BOOKMARK_END;

PyObject *MyHrMAPIFindSubfolderEx(
	IMAPIFolder *lpRootFolder,
	TCHAR chSep,
	TCHAR *lpszName) 
{
	DWORD idSize;
	ENTRYID *id;
	HRESULT hr = HrMAPIFindSubfolderEx(lpRootFolder,chSep,lpszName,&idSize, &id);
	if (FAILED(hr))
		return OleSetOleError(hr);
	PyObject *rc = PyString_FromStringAndSize((char *)id, idSize);
	MAPIFreeBuffer(id);
	return rc;
}
static PyObject *_wrap_MAPIInitialize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    MAPIINIT_0 * _arg0;
    MAPIINIT_0  temp;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:MAPIInitialize",&_obj0)) 
        return NULL;
{
	_arg0 = &temp;
	if (_obj0==Py_None)
		_arg0 = NULL;
	else {
		if (!PyArg_ParseTuple(_obj0, "ii:MAPIINIT_0 tuple", &(_arg0->ulVersion), &(_arg0->ulFlags))) {
			;
			return NULL;
		}
	}
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )MAPIInitialize(_arg0);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           
           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_MAPILogonEx(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    ULONG  _arg0;
    TCHAR * _arg1;
    TCHAR * _arg2;
    FLAGS  _arg3;
    IMAPISession ** _arg4;
    IMAPISession * temp;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
	_arg1 = NULL;
}
{
	_arg2 = NULL;
}
{
  _arg4 = &temp;
}
    if(!PyArg_ParseTuple(args,"lOOl:MAPILogonEx",&_arg0,&_obj1,&_obj2,&_arg3)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, TRUE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj2, &_arg2, TRUE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )MAPILogonEx(_arg0,_arg1,_arg2,_arg3,_arg4);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	PyWinObject_FreeTCHAR(_arg1);
}
{
	PyWinObject_FreeTCHAR(_arg2);
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg4, _resultobj, IID_IMAPISession)
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
{
	PyWinObject_FreeTCHAR(_arg2);
}
    return _resultobj;
}

static PyObject *_wrap_MAPIAdminProfiles(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    unsigned long  _arg0;
    IProfAdmin ** _arg1;
    IProfAdmin * temp;

    self = self;
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"l:MAPIAdminProfiles",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )MAPIAdminProfiles(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           
           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IProfAdmin)
}
    return _resultobj;
}

static PyObject *_wrap_HrMAPIOpenFolderEx(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMsgStore * _arg0;
    WCHAR * _arg1;
    WCHAR * _arg2;
    IMAPIFolder ** _arg3;
    IMAPIFolder * temp;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
	_arg1 = NULL;
}
{
	_arg2 = NULL;
}
{
  _arg3 = &temp;
}
    if(!PyArg_ParseTuple(args,"OOO:HrMAPIOpenFolderEx",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMsgStore, (void **)&_arg0, 1))
		return NULL;
}
{
	// Wide string code!
	if (!PyWinObject_AsBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
	// Wide string code!
	if (!PyWinObject_AsBstr(_obj2, &_arg2, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrMAPIOpenFolderExW(_arg0,*_arg1,_arg2,_arg3);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}
{
	// Wide string cleanup
	SysFreeString(_arg1);
}
{
	// Wide string cleanup
	SysFreeString(_arg2);
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg3, _resultobj, IID_IMAPIFolder)
}
{
	if (_arg0) _arg0->Release();
}
{
	// Wide string cleanup
	SysFreeString(_arg1);
}
{
	// Wide string cleanup
	SysFreeString(_arg2);
}
    return _resultobj;
}

static PyObject *_wrap_HrMAPISetPropBoolean(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPIProp * _arg0;
    unsigned long  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"Oli:HrMAPISetPropBoolean",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPIProp, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrMAPISetPropBoolean(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrMAPISetPropLong(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPIProp * _arg0;
    unsigned long  _arg1;
    long  _arg2;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"Oll:HrMAPISetPropLong",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPIProp, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrMAPISetPropLong(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrOpenExchangePublicStore(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    IMsgStore ** _arg1;
    IMsgStore * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrOpenExchangePublicStore",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrOpenExchangePublicStore(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IMsgStore)
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrOpenExchangePrivateStore(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    IMsgStore ** _arg1;
    IMsgStore * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrOpenExchangePrivateStore",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrOpenExchangePrivateStore(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IMsgStore)
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrOpenExchangePublicFolders(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMsgStore * _arg0;
    IMAPIFolder ** _arg1;
    IMAPIFolder * temp;
    PyObject * _obj0 = 0;

    self = self;
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrOpenExchangePublicFolders",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMsgStore, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrOpenExchangePublicFolders(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IMAPIFolder)
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrOpenSessionObject(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    IMAPIProp ** _arg1;
    IMAPIProp * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrOpenSessionObject",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrOpenSessionObject(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IMAPIProp)
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrOpenSiteContainer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    IMAPIProp ** _arg1;
    IMAPIProp * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrOpenSiteContainer",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrOpenSiteContainer(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IMAPIProp)
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrOpenSiteContainerAddressing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    IMAPIProp ** _arg1;
    IMAPIProp * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrOpenSiteContainerAddressing",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrOpenSiteContainerAddressing(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg1, _resultobj, IID_IMAPIProp)
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrQueryAllRows(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPITable * _arg0;
    SPropTagArray * _arg1;
    SRestriction * _arg2;
    SSortOrderSet * _arg3;
    long  _arg4;
    SRowSet ** _arg5;
    SRowSet * temp;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg5 = &temp;
}
    if(!PyArg_ParseTuple(args,"OOOOl:HrQueryAllRows",&_obj0,&_obj1,&_obj2,&_obj3,&_arg4)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPITable, (void **)&_arg0, 0))
		return NULL;
}
{
	if (!PyMAPIObject_AsSPropTagArray(_obj1, &_arg1))
		return NULL;
}
{
	if (!PyMAPIObject_AsSRestriction(_obj2, &_arg2))
		return NULL;
}
{
	if (!PyMAPIObject_AsSSortOrderSet(_obj3, &_arg3))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrQueryAllRows(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}
{
	PyMAPIObject_FreeSRestriction(_arg2);
}
{
	PyMAPIObject_FreeSSortOrderSet(_arg3);
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyObject *o;
	o = PyMAPIObject_FromSRowSet(*_arg5);
	if (!_resultobj) {
		_resultobj = o;
	} else if (_resultobj == Py_None) {
		Py_DECREF(Py_None);
		_resultobj = o;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *o2 = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj,o2);
			Py_XDECREF(o2);
		}
		PyList_Append(_resultobj,o);
		Py_XDECREF(o);
	}
}
{
	if (_arg0) _arg0->Release();
}
{
	PyMAPIObject_FreeSRestriction(_arg2);
}
{
	PyMAPIObject_FreeSSortOrderSet(_arg3);
}
    return _resultobj;
}

static PyObject *_wrap_HrGetExchangeStatus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    TCHAR * _arg0;
    unsigned long * _arg1;
    unsigned long  temp;
    unsigned long * _arg2;
    unsigned long  temp0;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
{
  _arg2 = &temp0;
}
    if(!PyArg_ParseTuple(args,"O:HrGetExchangeStatus",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrGetExchangeStatus(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_HrMailboxLogon(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    IMsgStore * _arg1;
    TCHAR * _arg2;
    TCHAR * _arg3;
    IMsgStore ** _arg4;
    IMsgStore * temp;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg2 = NULL;
}
{
	_arg3 = NULL;
}
{
  _arg4 = &temp;
}
    if(!PyArg_ParseTuple(args,"OOOO:HrMailboxLogon",&_obj0,&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj1, IID_IMsgStore, (void **)&_arg1, 0))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj2, &_arg2, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj3, &_arg3, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrMailboxLogon(_arg0,_arg1,_arg2,_arg3,_arg4);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}
{
	if (_arg1) _arg1->Release();
}
{
	PyWinObject_FreeTCHAR(_arg2);
}
{
	PyWinObject_FreeTCHAR(_arg3);
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	MAKE_OUTPUT_INTERFACE(_arg4, _resultobj, IID_IMsgStore)
}
{
	if (_arg0) _arg0->Release();
}
{
	if (_arg1) _arg1->Release();
}
{
	PyWinObject_FreeTCHAR(_arg2);
}
{
	PyWinObject_FreeTCHAR(_arg3);
}
    return _resultobj;
}

static PyObject *_wrap_HrMailboxLogoff(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMsgStore ** _arg0;
    IMsgStore * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"O:HrMailboxLogoff",&_obj0)) 
        return NULL;
{
	_arg0 = &temp;
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMsgStore, (void **)_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrMailboxLogoff(_arg0);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0 && *_arg0) (*_arg0)->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	if (_arg0 && *_arg0) (*_arg0)->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrMAPIFindSubfolderEx(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    IMAPIFolder * _arg0;
    TCHAR * _arg1;
    TCHAR * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg1 = NULL;
}
{
	_arg2 = NULL;
}
    if(!PyArg_ParseTuple(args,"OOO:HrMAPIFindSubfolderEx",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPIFolder, (void **)&_arg0, 0))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj2, &_arg2, FALSE))
		return NULL;
}
    _result = (PyObject *)MyHrMAPIFindSubfolderEx(_arg0,*_arg1,_arg2);
{
	if (_result==NULL) return NULL; // get out now!
	_resultobj = _result;
}
{
	if (_arg0) _arg0->Release();
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
{
	PyWinObject_FreeTCHAR(_arg2);
}
    return _resultobj;
}

static PyObject *_wrap_RTFSync(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMessage * _arg0;
    unsigned long  _arg1;
    int * _arg2;
    int  temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg2 = &temp;
}
    if(!PyArg_ParseTuple(args,"Ol:RTFSync",&_obj0,&_arg1)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMessage, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )RTFSync(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrGetMailboxDN(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    TCHAR ** _arg1;
    TCHAR * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrGetMailboxDN",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrGetMailboxDN(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	if (*_arg1==NULL) {
		_resultobj = Py_None;
		Py_INCREF(Py_None);
	} else {
		_resultobj = PyWinObject_FromTCHAR(*_arg1);
		MAPIFreeBuffer(*_arg1);
	}
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyObject *_wrap_HrGetServerDN(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    IMAPISession * _arg0;
    TCHAR ** _arg1;
    TCHAR * temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:HrGetServerDN",&_obj0)) 
        return NULL;
{
	if (!PyCom_InterfaceFromPyInstanceOrObject(_obj0, IID_IMAPISession, (void **)&_arg0, 0))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HRESULT )HrGetServerDN(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (FAILED(_result))  {
           {
	if (_arg0) _arg0->Release();
}

           return OleSetOleError(_result);
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	if (*_arg1==NULL) {
		_resultobj = Py_None;
		Py_INCREF(Py_None);
	} else {
		_resultobj = PyWinObject_FromTCHAR(*_arg1);
		MAPIFreeBuffer(*_arg1);
	}
}
{
	if (_arg0) _arg0->Release();
}
    return _resultobj;
}

static PyMethodDef mapiMethods[] = {
	 { "HrGetServerDN", _wrap_HrGetServerDN, 1 },
	 { "HrGetMailboxDN", _wrap_HrGetMailboxDN, 1 },
	 { "RTFSync", _wrap_RTFSync, 1 },
	 { "HrCreateProfileName", PyHrCreateProfileName, 1 },
	 { "HrMAPIFindSubfolderEx", _wrap_HrMAPIFindSubfolderEx, 1 },
	 { "HrMailboxLogoff", _wrap_HrMailboxLogoff, 1 },
	 { "HrMailboxLogon", _wrap_HrMailboxLogon, 1 },
	 { "HrGetExchangeStatus", _wrap_HrGetExchangeStatus, 1 },
	 { "HrQueryAllRows", _wrap_HrQueryAllRows, 1 },
	 { "HrOpenSiteContainerAddressing", _wrap_HrOpenSiteContainerAddressing, 1 },
	 { "HrOpenSiteContainer", _wrap_HrOpenSiteContainer, 1 },
	 { "HrOpenSessionObject", _wrap_HrOpenSessionObject, 1 },
	 { "HrOpenExchangePublicFolders", _wrap_HrOpenExchangePublicFolders, 1 },
	 { "HrOpenExchangePrivateStore", _wrap_HrOpenExchangePrivateStore, 1 },
	 { "HrOpenExchangePublicStore", _wrap_HrOpenExchangePublicStore, 1 },
	 { "BinFromHex", PyBinFromHex, 1 },
	 { "HexFromBin", PyHexFromBin, 1 },
	 { "HrMAPIFindInbox", PyHrMAPIFindInbox, 1 },
	 { "HrMAPIFindIPMSubtree", PyHrMAPIFindIPMSubtree, 1 },
	 { "HrMAPIFindDefaultMsgStore", PyHrMAPIFindDefaultMsgStore, 1 },
	 { "HrMAPISetPropLong", _wrap_HrMAPISetPropLong, 1 },
	 { "HrMAPISetPropBoolean", _wrap_HrMAPISetPropBoolean, 1 },
	 { "HrMAPIOpenFolderEx", _wrap_HrMAPIOpenFolderEx, 1 },
	 { "MAPIUninitialize", PyMAPIUninitialize, 1 },
	 { "MAPIAdminProfiles", _wrap_MAPIAdminProfiles, 1 },
	 { "MAPILogonEx", _wrap_MAPILogonEx, 1 },
	 { "MAPIInitialize", _wrap_MAPIInitialize, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initmapi)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("mapi", mapiMethods);
	 d = PyModule_GetDict(m);

#ifndef PYCOM_EXPORT
	 PyDict_SetItemString(d,"UNICODE", PyInt_FromLong(
#ifdef UNICODE
	1
#else
	0
#endif
	));
#endif

	if ( PyCom_RegisterClientType(&PyIMAPISession::type, &IID_IMAPISession) != 0 ) return;
	ADD_IID(IID_IMAPISession);

	if ( PyCom_RegisterClientType(&PyIMAPITable::type, &IID_IMAPITable) != 0 ) return;
	ADD_IID(IID_IMAPITable);

	if ( PyCom_RegisterClientType(&PyIMAPIProp::type, &IID_IMAPIProp) != 0 ) return;
	ADD_IID(IID_IMAPIProp);

	if ( PyCom_RegisterClientType(&PyIMAPIFolder::type, &IID_IMAPIFolder) != 0 ) return;
	ADD_IID(IID_IMAPIFolder);

	if ( PyCom_RegisterClientType(&PyIMAPIContainer::type, &IID_IMAPIContainer) != 0 ) return;
	ADD_IID(IID_IMAPIContainer);

	if ( PyCom_RegisterClientType(&PyIMessage::type, &IID_IMessage) != 0 ) return;
	ADD_IID(IID_IMessage);

	if ( PyCom_RegisterClientType(&PyIMsgStore::type, &IID_IMsgStore) != 0 ) return;
	ADD_IID(IID_IMsgStore);

	if ( PyCom_RegisterClientType(&PyIAttach::type, &IID_IAttachment) != 0 ) return;
	ADD_IID(IID_IAttachment);

	if ( PyCom_RegisterClientType(&PyIProfAdmin::type, &IID_IProfAdmin) != 0 ) return;
	ADD_IID(IID_IProfAdmin);

	if ( PyCom_RegisterClientType(&PyIAddrBook::type, &IID_IAddrBook) != 0 ) return;
	ADD_IID(IID_IAddrBook);

	ADD_IID(PS_PUBLIC_STRINGS);
	ADD_IID(PS_MAPI);
	ADD_IID(PS_ROUTING_EMAIL_ADDRESSES);
	ADD_IID(PS_ROUTING_ADDRTYPE);
	ADD_IID(PS_ROUTING_DISPLAY_NAME);
	ADD_IID(PS_ROUTING_ENTRYID);
	ADD_IID(PS_ROUTING_SEARCH_KEY);

	 _wrap_python_const_MAPI_DIALOG = PyInt_FromLong(MAPI_DIALOG);
	 PyDict_SetItemString(d,"MAPI_DIALOG", _wrap_python_const_MAPI_DIALOG);
	 _wrap_python_const_MAPI_ASSOCIATED = PyInt_FromLong(MAPI_ASSOCIATED);
	 PyDict_SetItemString(d,"MAPI_ASSOCIATED", _wrap_python_const_MAPI_ASSOCIATED);
	 _wrap_python_const_MAPI_ALLOW_OTHERS = PyInt_FromLong(MAPI_ALLOW_OTHERS);
	 PyDict_SetItemString(d,"MAPI_ALLOW_OTHERS", _wrap_python_const_MAPI_ALLOW_OTHERS);
	 _wrap_python_const_MAPI_EXPLICIT_PROFILE = PyInt_FromLong(MAPI_EXPLICIT_PROFILE);
	 PyDict_SetItemString(d,"MAPI_EXPLICIT_PROFILE", _wrap_python_const_MAPI_EXPLICIT_PROFILE);
	 _wrap_python_const_MAPI_EXTENDED = PyInt_FromLong(MAPI_EXTENDED);
	 PyDict_SetItemString(d,"MAPI_EXTENDED", _wrap_python_const_MAPI_EXTENDED);
	 _wrap_python_const_MAPI_FORCE_DOWNLOAD = PyInt_FromLong(MAPI_FORCE_DOWNLOAD);
	 PyDict_SetItemString(d,"MAPI_FORCE_DOWNLOAD", _wrap_python_const_MAPI_FORCE_DOWNLOAD);
	 _wrap_python_const_MAPI_LOGON_UI = PyInt_FromLong(MAPI_LOGON_UI);
	 PyDict_SetItemString(d,"MAPI_LOGON_UI", _wrap_python_const_MAPI_LOGON_UI);
	 _wrap_python_const_MAPI_NEW_SESSION = PyInt_FromLong(MAPI_NEW_SESSION);
	 PyDict_SetItemString(d,"MAPI_NEW_SESSION", _wrap_python_const_MAPI_NEW_SESSION);
	 _wrap_python_const_MAPI_NO_MAIL = PyInt_FromLong(MAPI_NO_MAIL);
	 PyDict_SetItemString(d,"MAPI_NO_MAIL", _wrap_python_const_MAPI_NO_MAIL);
	 _wrap_python_const_MAPI_MULTITHREAD_NOTIFICATIONS = PyInt_FromLong(MAPI_MULTITHREAD_NOTIFICATIONS);
	 PyDict_SetItemString(d,"MAPI_MULTITHREAD_NOTIFICATIONS", _wrap_python_const_MAPI_MULTITHREAD_NOTIFICATIONS);
	 _wrap_python_const_MAPI_NT_SERVICE = PyInt_FromLong(MAPI_NT_SERVICE);
	 PyDict_SetItemString(d,"MAPI_NT_SERVICE", _wrap_python_const_MAPI_NT_SERVICE);
	 _wrap_python_const_MAPI_PASSWORD_UI = PyInt_FromLong(MAPI_PASSWORD_UI);
	 PyDict_SetItemString(d,"MAPI_PASSWORD_UI", _wrap_python_const_MAPI_PASSWORD_UI);
	 _wrap_python_const_MAPI_SERVICE_UI_ALWAYS = PyInt_FromLong(MAPI_SERVICE_UI_ALWAYS);
	 PyDict_SetItemString(d,"MAPI_SERVICE_UI_ALWAYS", _wrap_python_const_MAPI_SERVICE_UI_ALWAYS);
	 _wrap_python_const_MAPI_TIMEOUT_SHORT = PyInt_FromLong(MAPI_TIMEOUT_SHORT);
	 PyDict_SetItemString(d,"MAPI_TIMEOUT_SHORT", _wrap_python_const_MAPI_TIMEOUT_SHORT);
	 _wrap_python_const_MAPI_UNICODE = PyInt_FromLong(MAPI_UNICODE);
	 PyDict_SetItemString(d,"MAPI_UNICODE", _wrap_python_const_MAPI_UNICODE);
	 _wrap_python_const_MAPI_USE_DEFAULT = PyInt_FromLong(MAPI_USE_DEFAULT);
	 PyDict_SetItemString(d,"MAPI_USE_DEFAULT", _wrap_python_const_MAPI_USE_DEFAULT);
	 _wrap_python_const_FORCE_SAVE = PyInt_FromLong(FORCE_SAVE);
	 PyDict_SetItemString(d,"FORCE_SAVE", _wrap_python_const_FORCE_SAVE);
	 _wrap_python_const_KEEP_OPEN_READONLY = PyInt_FromLong(KEEP_OPEN_READONLY);
	 PyDict_SetItemString(d,"KEEP_OPEN_READONLY", _wrap_python_const_KEEP_OPEN_READONLY);
	 _wrap_python_const_KEEP_OPEN_READWRITE = PyInt_FromLong(KEEP_OPEN_READWRITE);
	 PyDict_SetItemString(d,"KEEP_OPEN_READWRITE", _wrap_python_const_KEEP_OPEN_READWRITE);
	 _wrap_python_const_MAPI_DEFERRED_ERRORS = PyInt_FromLong(MAPI_DEFERRED_ERRORS);
	 PyDict_SetItemString(d,"MAPI_DEFERRED_ERRORS", _wrap_python_const_MAPI_DEFERRED_ERRORS);
	 _wrap_python_const_FOLDER_GENERIC = PyInt_FromLong(FOLDER_GENERIC);
	 PyDict_SetItemString(d,"FOLDER_GENERIC", _wrap_python_const_FOLDER_GENERIC);
	 _wrap_python_const_FOLDER_SEARCH = PyInt_FromLong(FOLDER_SEARCH);
	 PyDict_SetItemString(d,"FOLDER_SEARCH", _wrap_python_const_FOLDER_SEARCH);
	 _wrap_python_const_CONVENIENT_DEPTH = PyInt_FromLong(CONVENIENT_DEPTH);
	 PyDict_SetItemString(d,"CONVENIENT_DEPTH", _wrap_python_const_CONVENIENT_DEPTH);
	 _wrap_python_const_MAPI_BEST_ACCESS = PyInt_FromLong(MAPI_BEST_ACCESS);
	 PyDict_SetItemString(d,"MAPI_BEST_ACCESS", _wrap_python_const_MAPI_BEST_ACCESS);
	 _wrap_python_const_MAPI_MODIFY = PyInt_FromLong(MAPI_MODIFY);
	 PyDict_SetItemString(d,"MAPI_MODIFY", _wrap_python_const_MAPI_MODIFY);
	 _wrap_python_const_MDB_NO_DIALOG = PyInt_FromLong(MDB_NO_DIALOG);
	 PyDict_SetItemString(d,"MDB_NO_DIALOG", _wrap_python_const_MDB_NO_DIALOG);
	 _wrap_python_const_MDB_NO_MAIL = PyInt_FromLong(MDB_NO_MAIL);
	 PyDict_SetItemString(d,"MDB_NO_MAIL", _wrap_python_const_MDB_NO_MAIL);
	 _wrap_python_const_MDB_TEMPORARY = PyInt_FromLong(MDB_TEMPORARY);
	 PyDict_SetItemString(d,"MDB_TEMPORARY", _wrap_python_const_MDB_TEMPORARY);
	 _wrap_python_const_MDB_WRITE = PyInt_FromLong(MDB_WRITE);
	 PyDict_SetItemString(d,"MDB_WRITE", _wrap_python_const_MDB_WRITE);
	 _wrap_python_const_OPEN_IF_EXISTS = PyInt_FromLong(OPEN_IF_EXISTS);
	 PyDict_SetItemString(d,"OPEN_IF_EXISTS", _wrap_python_const_OPEN_IF_EXISTS);
	 _wrap_python_const_MAPI_INIT_VERSION = PyInt_FromLong(MAPI_INIT_VERSION);
	 PyDict_SetItemString(d,"MAPI_INIT_VERSION", _wrap_python_const_MAPI_INIT_VERSION);
	 _wrap_python_const_RTF_SYNC_BODY_CHANGED = PyInt_FromLong(RTF_SYNC_BODY_CHANGED);
	 PyDict_SetItemString(d,"RTF_SYNC_BODY_CHANGED", _wrap_python_const_RTF_SYNC_BODY_CHANGED);
	 _wrap_python_const_RTF_SYNC_RTF_CHANGED = PyInt_FromLong(RTF_SYNC_RTF_CHANGED);
	 PyDict_SetItemString(d,"RTF_SYNC_RTF_CHANGED", _wrap_python_const_RTF_SYNC_RTF_CHANGED);
	 _wrap_python_const_MAPI_CREATE = PyInt_FromLong(MAPI_CREATE);
	 PyDict_SetItemString(d,"MAPI_CREATE", _wrap_python_const_MAPI_CREATE);
	 _wrap_python_const_MAPI_E_NOT_ENOUGH_MEMORY = PyInt_FromLong(MAPI_E_NOT_ENOUGH_MEMORY);
	 PyDict_SetItemString(d,"MAPI_E_NOT_ENOUGH_MEMORY", _wrap_python_const_MAPI_E_NOT_ENOUGH_MEMORY);
	 _wrap_python_const_MAPI_E_INVALID_PARAMETER = PyInt_FromLong(MAPI_E_INVALID_PARAMETER);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_PARAMETER", _wrap_python_const_MAPI_E_INVALID_PARAMETER);
	 _wrap_python_const_MAPI_E_INTERFACE_NOT_SUPPORTED = PyInt_FromLong(MAPI_E_INTERFACE_NOT_SUPPORTED);
	 PyDict_SetItemString(d,"MAPI_E_INTERFACE_NOT_SUPPORTED", _wrap_python_const_MAPI_E_INTERFACE_NOT_SUPPORTED);
	 _wrap_python_const_MAPI_E_NO_ACCESS = PyInt_FromLong(MAPI_E_NO_ACCESS);
	 PyDict_SetItemString(d,"MAPI_E_NO_ACCESS", _wrap_python_const_MAPI_E_NO_ACCESS);
	 _wrap_python_const_MAPI_E_NO_SUPPORT = PyInt_FromLong(MAPI_E_NO_SUPPORT);
	 PyDict_SetItemString(d,"MAPI_E_NO_SUPPORT", _wrap_python_const_MAPI_E_NO_SUPPORT);
	 _wrap_python_const_MAPI_E_BAD_CHARWIDTH = PyInt_FromLong(MAPI_E_BAD_CHARWIDTH);
	 PyDict_SetItemString(d,"MAPI_E_BAD_CHARWIDTH", _wrap_python_const_MAPI_E_BAD_CHARWIDTH);
	 _wrap_python_const_MAPI_E_STRING_TOO_LONG = PyInt_FromLong(MAPI_E_STRING_TOO_LONG);
	 PyDict_SetItemString(d,"MAPI_E_STRING_TOO_LONG", _wrap_python_const_MAPI_E_STRING_TOO_LONG);
	 _wrap_python_const_MAPI_E_UNKNOWN_FLAGS = PyInt_FromLong(MAPI_E_UNKNOWN_FLAGS);
	 PyDict_SetItemString(d,"MAPI_E_UNKNOWN_FLAGS", _wrap_python_const_MAPI_E_UNKNOWN_FLAGS);
	 _wrap_python_const_MAPI_E_INVALID_ENTRYID = PyInt_FromLong(MAPI_E_INVALID_ENTRYID);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_ENTRYID", _wrap_python_const_MAPI_E_INVALID_ENTRYID);
	 _wrap_python_const_MAPI_E_INVALID_OBJECT = PyInt_FromLong(MAPI_E_INVALID_OBJECT);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_OBJECT", _wrap_python_const_MAPI_E_INVALID_OBJECT);
	 _wrap_python_const_MAPI_E_OBJECT_CHANGED = PyInt_FromLong(MAPI_E_OBJECT_CHANGED);
	 PyDict_SetItemString(d,"MAPI_E_OBJECT_CHANGED", _wrap_python_const_MAPI_E_OBJECT_CHANGED);
	 _wrap_python_const_MAPI_E_OBJECT_DELETED = PyInt_FromLong(MAPI_E_OBJECT_DELETED);
	 PyDict_SetItemString(d,"MAPI_E_OBJECT_DELETED", _wrap_python_const_MAPI_E_OBJECT_DELETED);
	 _wrap_python_const_MAPI_E_BUSY = PyInt_FromLong(MAPI_E_BUSY);
	 PyDict_SetItemString(d,"MAPI_E_BUSY", _wrap_python_const_MAPI_E_BUSY);
	 _wrap_python_const_MAPI_E_NOT_ENOUGH_DISK = PyInt_FromLong(MAPI_E_NOT_ENOUGH_DISK);
	 PyDict_SetItemString(d,"MAPI_E_NOT_ENOUGH_DISK", _wrap_python_const_MAPI_E_NOT_ENOUGH_DISK);
	 _wrap_python_const_MAPI_E_NOT_ENOUGH_RESOURCES = PyInt_FromLong(MAPI_E_NOT_ENOUGH_RESOURCES);
	 PyDict_SetItemString(d,"MAPI_E_NOT_ENOUGH_RESOURCES", _wrap_python_const_MAPI_E_NOT_ENOUGH_RESOURCES);
	 _wrap_python_const_MAPI_E_NOT_FOUND = PyInt_FromLong(MAPI_E_NOT_FOUND);
	 PyDict_SetItemString(d,"MAPI_E_NOT_FOUND", _wrap_python_const_MAPI_E_NOT_FOUND);
	 _wrap_python_const_MAPI_E_VERSION = PyInt_FromLong(MAPI_E_VERSION);
	 PyDict_SetItemString(d,"MAPI_E_VERSION", _wrap_python_const_MAPI_E_VERSION);
	 _wrap_python_const_MAPI_E_LOGON_FAILED = PyInt_FromLong(MAPI_E_LOGON_FAILED);
	 PyDict_SetItemString(d,"MAPI_E_LOGON_FAILED", _wrap_python_const_MAPI_E_LOGON_FAILED);
	 _wrap_python_const_MAPI_E_SESSION_LIMIT = PyInt_FromLong(MAPI_E_SESSION_LIMIT);
	 PyDict_SetItemString(d,"MAPI_E_SESSION_LIMIT", _wrap_python_const_MAPI_E_SESSION_LIMIT);
	 _wrap_python_const_MAPI_E_USER_CANCEL = PyInt_FromLong(MAPI_E_USER_CANCEL);
	 PyDict_SetItemString(d,"MAPI_E_USER_CANCEL", _wrap_python_const_MAPI_E_USER_CANCEL);
	 _wrap_python_const_MAPI_E_UNABLE_TO_ABORT = PyInt_FromLong(MAPI_E_UNABLE_TO_ABORT);
	 PyDict_SetItemString(d,"MAPI_E_UNABLE_TO_ABORT", _wrap_python_const_MAPI_E_UNABLE_TO_ABORT);
	 _wrap_python_const_MAPI_E_NETWORK_ERROR = PyInt_FromLong(MAPI_E_NETWORK_ERROR);
	 PyDict_SetItemString(d,"MAPI_E_NETWORK_ERROR", _wrap_python_const_MAPI_E_NETWORK_ERROR);
	 _wrap_python_const_MAPI_E_DISK_ERROR = PyInt_FromLong(MAPI_E_DISK_ERROR);
	 PyDict_SetItemString(d,"MAPI_E_DISK_ERROR", _wrap_python_const_MAPI_E_DISK_ERROR);
	 _wrap_python_const_MAPI_E_TOO_COMPLEX = PyInt_FromLong(MAPI_E_TOO_COMPLEX);
	 PyDict_SetItemString(d,"MAPI_E_TOO_COMPLEX", _wrap_python_const_MAPI_E_TOO_COMPLEX);
	 _wrap_python_const_MAPI_E_BAD_COLUMN = PyInt_FromLong(MAPI_E_BAD_COLUMN);
	 PyDict_SetItemString(d,"MAPI_E_BAD_COLUMN", _wrap_python_const_MAPI_E_BAD_COLUMN);
	 _wrap_python_const_MAPI_E_EXTENDED_ERROR = PyInt_FromLong(MAPI_E_EXTENDED_ERROR);
	 PyDict_SetItemString(d,"MAPI_E_EXTENDED_ERROR", _wrap_python_const_MAPI_E_EXTENDED_ERROR);
	 _wrap_python_const_MAPI_E_COMPUTED = PyInt_FromLong(MAPI_E_COMPUTED);
	 PyDict_SetItemString(d,"MAPI_E_COMPUTED", _wrap_python_const_MAPI_E_COMPUTED);
	 _wrap_python_const_MAPI_E_CORRUPT_DATA = PyInt_FromLong(MAPI_E_CORRUPT_DATA);
	 PyDict_SetItemString(d,"MAPI_E_CORRUPT_DATA", _wrap_python_const_MAPI_E_CORRUPT_DATA);
	 _wrap_python_const_MAPI_E_UNCONFIGURED = PyInt_FromLong(MAPI_E_UNCONFIGURED);
	 PyDict_SetItemString(d,"MAPI_E_UNCONFIGURED", _wrap_python_const_MAPI_E_UNCONFIGURED);
	 _wrap_python_const_MAPI_E_FAILONEPROVIDER = PyInt_FromLong(MAPI_E_FAILONEPROVIDER);
	 PyDict_SetItemString(d,"MAPI_E_FAILONEPROVIDER", _wrap_python_const_MAPI_E_FAILONEPROVIDER);
	 _wrap_python_const_MAPI_E_UNKNOWN_CPID = PyInt_FromLong(MAPI_E_UNKNOWN_CPID);
	 PyDict_SetItemString(d,"MAPI_E_UNKNOWN_CPID", _wrap_python_const_MAPI_E_UNKNOWN_CPID);
	 _wrap_python_const_MAPI_E_UNKNOWN_LCID = PyInt_FromLong(MAPI_E_UNKNOWN_LCID);
	 PyDict_SetItemString(d,"MAPI_E_UNKNOWN_LCID", _wrap_python_const_MAPI_E_UNKNOWN_LCID);
	 _wrap_python_const_MAPI_E_PASSWORD_CHANGE_REQUIRED = PyInt_FromLong(MAPI_E_PASSWORD_CHANGE_REQUIRED);
	 PyDict_SetItemString(d,"MAPI_E_PASSWORD_CHANGE_REQUIRED", _wrap_python_const_MAPI_E_PASSWORD_CHANGE_REQUIRED);
	 _wrap_python_const_MAPI_E_PASSWORD_EXPIRED = PyInt_FromLong(MAPI_E_PASSWORD_EXPIRED);
	 PyDict_SetItemString(d,"MAPI_E_PASSWORD_EXPIRED", _wrap_python_const_MAPI_E_PASSWORD_EXPIRED);
	 _wrap_python_const_MAPI_E_INVALID_WORKSTATION_ACCOUNT = PyInt_FromLong(MAPI_E_INVALID_WORKSTATION_ACCOUNT);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_WORKSTATION_ACCOUNT", _wrap_python_const_MAPI_E_INVALID_WORKSTATION_ACCOUNT);
	 _wrap_python_const_MAPI_E_INVALID_ACCESS_TIME = PyInt_FromLong(MAPI_E_INVALID_ACCESS_TIME);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_ACCESS_TIME", _wrap_python_const_MAPI_E_INVALID_ACCESS_TIME);
	 _wrap_python_const_MAPI_E_ACCOUNT_DISABLED = PyInt_FromLong(MAPI_E_ACCOUNT_DISABLED);
	 PyDict_SetItemString(d,"MAPI_E_ACCOUNT_DISABLED", _wrap_python_const_MAPI_E_ACCOUNT_DISABLED);
	 _wrap_python_const_MAPI_E_END_OF_SESSION = PyInt_FromLong(MAPI_E_END_OF_SESSION);
	 PyDict_SetItemString(d,"MAPI_E_END_OF_SESSION", _wrap_python_const_MAPI_E_END_OF_SESSION);
	 _wrap_python_const_MAPI_E_UNKNOWN_ENTRYID = PyInt_FromLong(MAPI_E_UNKNOWN_ENTRYID);
	 PyDict_SetItemString(d,"MAPI_E_UNKNOWN_ENTRYID", _wrap_python_const_MAPI_E_UNKNOWN_ENTRYID);
	 _wrap_python_const_MAPI_E_MISSING_REQUIRED_COLUMN = PyInt_FromLong(MAPI_E_MISSING_REQUIRED_COLUMN);
	 PyDict_SetItemString(d,"MAPI_E_MISSING_REQUIRED_COLUMN", _wrap_python_const_MAPI_E_MISSING_REQUIRED_COLUMN);
	 _wrap_python_const_MAPI_W_NO_SERVICE = PyInt_FromLong(MAPI_W_NO_SERVICE);
	 PyDict_SetItemString(d,"MAPI_W_NO_SERVICE", _wrap_python_const_MAPI_W_NO_SERVICE);
	 _wrap_python_const_MAPI_E_BAD_VALUE = PyInt_FromLong(MAPI_E_BAD_VALUE);
	 PyDict_SetItemString(d,"MAPI_E_BAD_VALUE", _wrap_python_const_MAPI_E_BAD_VALUE);
	 _wrap_python_const_MAPI_E_INVALID_TYPE = PyInt_FromLong(MAPI_E_INVALID_TYPE);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_TYPE", _wrap_python_const_MAPI_E_INVALID_TYPE);
	 _wrap_python_const_MAPI_E_TYPE_NO_SUPPORT = PyInt_FromLong(MAPI_E_TYPE_NO_SUPPORT);
	 PyDict_SetItemString(d,"MAPI_E_TYPE_NO_SUPPORT", _wrap_python_const_MAPI_E_TYPE_NO_SUPPORT);
	 _wrap_python_const_MAPI_E_UNEXPECTED_TYPE = PyInt_FromLong(MAPI_E_UNEXPECTED_TYPE);
	 PyDict_SetItemString(d,"MAPI_E_UNEXPECTED_TYPE", _wrap_python_const_MAPI_E_UNEXPECTED_TYPE);
	 _wrap_python_const_MAPI_E_TOO_BIG = PyInt_FromLong(MAPI_E_TOO_BIG);
	 PyDict_SetItemString(d,"MAPI_E_TOO_BIG", _wrap_python_const_MAPI_E_TOO_BIG);
	 _wrap_python_const_MAPI_E_DECLINE_COPY = PyInt_FromLong(MAPI_E_DECLINE_COPY);
	 PyDict_SetItemString(d,"MAPI_E_DECLINE_COPY", _wrap_python_const_MAPI_E_DECLINE_COPY);
	 _wrap_python_const_MAPI_E_UNEXPECTED_ID = PyInt_FromLong(MAPI_E_UNEXPECTED_ID);
	 PyDict_SetItemString(d,"MAPI_E_UNEXPECTED_ID", _wrap_python_const_MAPI_E_UNEXPECTED_ID);
	 _wrap_python_const_MAPI_W_ERRORS_RETURNED = PyInt_FromLong(MAPI_W_ERRORS_RETURNED);
	 PyDict_SetItemString(d,"MAPI_W_ERRORS_RETURNED", _wrap_python_const_MAPI_W_ERRORS_RETURNED);
	 _wrap_python_const_MAPI_E_UNABLE_TO_COMPLETE = PyInt_FromLong(MAPI_E_UNABLE_TO_COMPLETE);
	 PyDict_SetItemString(d,"MAPI_E_UNABLE_TO_COMPLETE", _wrap_python_const_MAPI_E_UNABLE_TO_COMPLETE);
	 _wrap_python_const_MAPI_E_TIMEOUT = PyInt_FromLong(MAPI_E_TIMEOUT);
	 PyDict_SetItemString(d,"MAPI_E_TIMEOUT", _wrap_python_const_MAPI_E_TIMEOUT);
	 _wrap_python_const_MAPI_E_TABLE_EMPTY = PyInt_FromLong(MAPI_E_TABLE_EMPTY);
	 PyDict_SetItemString(d,"MAPI_E_TABLE_EMPTY", _wrap_python_const_MAPI_E_TABLE_EMPTY);
	 _wrap_python_const_MAPI_E_TABLE_TOO_BIG = PyInt_FromLong(MAPI_E_TABLE_TOO_BIG);
	 PyDict_SetItemString(d,"MAPI_E_TABLE_TOO_BIG", _wrap_python_const_MAPI_E_TABLE_TOO_BIG);
	 _wrap_python_const_MAPI_E_INVALID_BOOKMARK = PyInt_FromLong(MAPI_E_INVALID_BOOKMARK);
	 PyDict_SetItemString(d,"MAPI_E_INVALID_BOOKMARK", _wrap_python_const_MAPI_E_INVALID_BOOKMARK);
	 _wrap_python_const_MAPI_W_POSITION_CHANGED = PyInt_FromLong(MAPI_W_POSITION_CHANGED);
	 PyDict_SetItemString(d,"MAPI_W_POSITION_CHANGED", _wrap_python_const_MAPI_W_POSITION_CHANGED);
	 _wrap_python_const_MAPI_W_APPROX_COUNT = PyInt_FromLong(MAPI_W_APPROX_COUNT);
	 PyDict_SetItemString(d,"MAPI_W_APPROX_COUNT", _wrap_python_const_MAPI_W_APPROX_COUNT);
	 _wrap_python_const_MAPI_E_WAIT = PyInt_FromLong(MAPI_E_WAIT);
	 PyDict_SetItemString(d,"MAPI_E_WAIT", _wrap_python_const_MAPI_E_WAIT);
	 _wrap_python_const_MAPI_E_CANCEL = PyInt_FromLong(MAPI_E_CANCEL);
	 PyDict_SetItemString(d,"MAPI_E_CANCEL", _wrap_python_const_MAPI_E_CANCEL);
	 _wrap_python_const_MAPI_E_NOT_ME = PyInt_FromLong(MAPI_E_NOT_ME);
	 PyDict_SetItemString(d,"MAPI_E_NOT_ME", _wrap_python_const_MAPI_E_NOT_ME);
	 _wrap_python_const_MAPI_W_CANCEL_MESSAGE = PyInt_FromLong(MAPI_W_CANCEL_MESSAGE);
	 PyDict_SetItemString(d,"MAPI_W_CANCEL_MESSAGE", _wrap_python_const_MAPI_W_CANCEL_MESSAGE);
	 _wrap_python_const_MAPI_E_CORRUPT_STORE = PyInt_FromLong(MAPI_E_CORRUPT_STORE);
	 PyDict_SetItemString(d,"MAPI_E_CORRUPT_STORE", _wrap_python_const_MAPI_E_CORRUPT_STORE);
	 _wrap_python_const_MAPI_E_NOT_IN_QUEUE = PyInt_FromLong(MAPI_E_NOT_IN_QUEUE);
	 PyDict_SetItemString(d,"MAPI_E_NOT_IN_QUEUE", _wrap_python_const_MAPI_E_NOT_IN_QUEUE);
	 _wrap_python_const_MAPI_E_NO_SUPPRESS = PyInt_FromLong(MAPI_E_NO_SUPPRESS);
	 PyDict_SetItemString(d,"MAPI_E_NO_SUPPRESS", _wrap_python_const_MAPI_E_NO_SUPPRESS);
	 _wrap_python_const_MAPI_E_COLLISION = PyInt_FromLong(MAPI_E_COLLISION);
	 PyDict_SetItemString(d,"MAPI_E_COLLISION", _wrap_python_const_MAPI_E_COLLISION);
	 _wrap_python_const_MAPI_E_NOT_INITIALIZED = PyInt_FromLong(MAPI_E_NOT_INITIALIZED);
	 PyDict_SetItemString(d,"MAPI_E_NOT_INITIALIZED", _wrap_python_const_MAPI_E_NOT_INITIALIZED);
	 _wrap_python_const_MAPI_E_NON_STANDARD = PyInt_FromLong(MAPI_E_NON_STANDARD);
	 PyDict_SetItemString(d,"MAPI_E_NON_STANDARD", _wrap_python_const_MAPI_E_NON_STANDARD);
	 _wrap_python_const_MAPI_E_NO_RECIPIENTS = PyInt_FromLong(MAPI_E_NO_RECIPIENTS);
	 PyDict_SetItemString(d,"MAPI_E_NO_RECIPIENTS", _wrap_python_const_MAPI_E_NO_RECIPIENTS);
	 _wrap_python_const_MAPI_E_SUBMITTED = PyInt_FromLong(MAPI_E_SUBMITTED);
	 PyDict_SetItemString(d,"MAPI_E_SUBMITTED", _wrap_python_const_MAPI_E_SUBMITTED);
	 _wrap_python_const_MAPI_E_HAS_FOLDERS = PyInt_FromLong(MAPI_E_HAS_FOLDERS);
	 PyDict_SetItemString(d,"MAPI_E_HAS_FOLDERS", _wrap_python_const_MAPI_E_HAS_FOLDERS);
	 _wrap_python_const_MAPI_E_HAS_MESSAGES = PyInt_FromLong(MAPI_E_HAS_MESSAGES);
	 PyDict_SetItemString(d,"MAPI_E_HAS_MESSAGES", _wrap_python_const_MAPI_E_HAS_MESSAGES);
	 _wrap_python_const_MAPI_E_FOLDER_CYCLE = PyInt_FromLong(MAPI_E_FOLDER_CYCLE);
	 PyDict_SetItemString(d,"MAPI_E_FOLDER_CYCLE", _wrap_python_const_MAPI_E_FOLDER_CYCLE);
	 _wrap_python_const_MAPI_W_PARTIAL_COMPLETION = PyInt_FromLong(MAPI_W_PARTIAL_COMPLETION);
	 PyDict_SetItemString(d,"MAPI_W_PARTIAL_COMPLETION", _wrap_python_const_MAPI_W_PARTIAL_COMPLETION);
	 _wrap_python_const_MAPI_E_AMBIGUOUS_RECIP = PyInt_FromLong(MAPI_E_AMBIGUOUS_RECIP);
	 PyDict_SetItemString(d,"MAPI_E_AMBIGUOUS_RECIP", _wrap_python_const_MAPI_E_AMBIGUOUS_RECIP);
	 _wrap_python_const_MODRECIP_ADD = PyInt_FromLong(MODRECIP_ADD);
	 PyDict_SetItemString(d,"MODRECIP_ADD", _wrap_python_const_MODRECIP_ADD);
	 _wrap_python_const_MODRECIP_MODIFY = PyInt_FromLong(MODRECIP_MODIFY);
	 PyDict_SetItemString(d,"MODRECIP_MODIFY", _wrap_python_const_MODRECIP_MODIFY);
	 _wrap_python_const_MODRECIP_REMOVE = PyInt_FromLong(MODRECIP_REMOVE);
	 PyDict_SetItemString(d,"MODRECIP_REMOVE", _wrap_python_const_MODRECIP_REMOVE);
	 _wrap_python_const_MAPI_TO = PyInt_FromLong(MAPI_TO);
	 PyDict_SetItemString(d,"MAPI_TO", _wrap_python_const_MAPI_TO);
	 _wrap_python_const_MAPI_CC = PyInt_FromLong(MAPI_CC);
	 PyDict_SetItemString(d,"MAPI_CC", _wrap_python_const_MAPI_CC);
	 _wrap_python_const_MAPI_BCC = PyInt_FromLong(MAPI_BCC);
	 PyDict_SetItemString(d,"MAPI_BCC", _wrap_python_const_MAPI_BCC);
	 _wrap_python_const_MAPI_P1 = PyInt_FromLong(MAPI_P1);
	 PyDict_SetItemString(d,"MAPI_P1", _wrap_python_const_MAPI_P1);
	 _wrap_python_const_MAPI_SUBMITTED = PyInt_FromLong(MAPI_SUBMITTED);
	 PyDict_SetItemString(d,"MAPI_SUBMITTED", _wrap_python_const_MAPI_SUBMITTED);
	 _wrap_python_const_AB_NO_DIALOG = PyInt_FromLong(AB_NO_DIALOG);
	 PyDict_SetItemString(d,"AB_NO_DIALOG", _wrap_python_const_AB_NO_DIALOG);
	 _wrap_python_const_BOOKMARK_BEGINNING = PyInt_FromLong(BOOKMARK_BEGINNING);
	 PyDict_SetItemString(d,"BOOKMARK_BEGINNING", _wrap_python_const_BOOKMARK_BEGINNING);
	 _wrap_python_const_BOOKMARK_CURRENT = PyInt_FromLong(BOOKMARK_CURRENT);
	 PyDict_SetItemString(d,"BOOKMARK_CURRENT", _wrap_python_const_BOOKMARK_CURRENT);
	 _wrap_python_const_BOOKMARK_END = PyInt_FromLong(BOOKMARK_END);
	 PyDict_SetItemString(d,"BOOKMARK_END", _wrap_python_const_BOOKMARK_END);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_FLAGS",0);
	 SWIG_RegisterMapping("_signed_long","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_signed_long","_HRESULT",0);
	 SWIG_RegisterMapping("_signed_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_signed_long","_LONG",0);
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_HRESULT","_FLAGS",0);
	 SWIG_RegisterMapping("_HRESULT","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_HRESULT","_long",0);
	 SWIG_RegisterMapping("_HRESULT","_signed_long",0);
	 SWIG_RegisterMapping("_HRESULT","_unsigned_long",0);
	 SWIG_RegisterMapping("_HRESULT","_DWORD",0);
	 SWIG_RegisterMapping("_HRESULT","_LONG",0);
	 SWIG_RegisterMapping("_HRESULT","_ULONG",0);
	 SWIG_RegisterMapping("_HRESULT","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_BOOLAPI","_BOOL",0);
	 SWIG_RegisterMapping("_BOOLAPI","_unsigned_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_signed_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_int",0);
	 SWIG_RegisterMapping("_long","_FLAGS",0);
	 SWIG_RegisterMapping("_long","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_long","_HRESULT",0);
	 SWIG_RegisterMapping("_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_long","_ULONG",0);
	 SWIG_RegisterMapping("_long","_LONG",0);
	 SWIG_RegisterMapping("_long","_DWORD",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_LPCTSTR","_char_p",0);
	 SWIG_RegisterMapping("_LPCTSTR","_LPCSTR",0);
	 SWIG_RegisterMapping("_ULONG","_FLAGS",0);
	 SWIG_RegisterMapping("_ULONG","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_ULONG","_HRESULT",0);
	 SWIG_RegisterMapping("_ULONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_ULONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_ULONG","_long",0);
	 SWIG_RegisterMapping("_ULONG","_DWORD",0);
	 SWIG_RegisterMapping("_ULONG","_LONG",0);
	 SWIG_RegisterMapping("_FLAGS","_long",0);
	 SWIG_RegisterMapping("_FLAGS","_signed_long",0);
	 SWIG_RegisterMapping("_FLAGS","_unsigned_long",0);
	 SWIG_RegisterMapping("_FLAGS","_DWORD",0);
	 SWIG_RegisterMapping("_FLAGS","_LONG",0);
	 SWIG_RegisterMapping("_FLAGS","_ULONG",0);
	 SWIG_RegisterMapping("_FLAGS","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_FLAGS","_HRESULT",0);
	 SWIG_RegisterMapping("_FLAGS","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_WORD","_unsigned_short",0);
	 SWIG_RegisterMapping("_WORD","_short",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_FLAGS",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_long",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_signed_long",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_unsigned_long",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_DWORD",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_LONG",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_ULONG",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_HRESULT_KEEP","_HRESULT",0);
	 SWIG_RegisterMapping("_LPCSTR","_LPCTSTR",0);
	 SWIG_RegisterMapping("_LPCSTR","_char_p",0);
	 SWIG_RegisterMapping("_char_p","_LPCTSTR",0);
	 SWIG_RegisterMapping("_char_p","_LPCSTR",0);
	 SWIG_RegisterMapping("_unsigned_long","_FLAGS",0);
	 SWIG_RegisterMapping("_unsigned_long","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_unsigned_long","_HRESULT",0);
	 SWIG_RegisterMapping("_unsigned_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_long","_ULONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_LONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_FLAGS",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_HRESULT",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_signed_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_unsigned_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_DWORD",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_LONG",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_ULONG",0);
	 SWIG_RegisterMapping("_BOOL","_BOOLAPI",0);
	 SWIG_RegisterMapping("_BOOL","_int",0);
	 SWIG_RegisterMapping("_BOOL","_signed_int",0);
	 SWIG_RegisterMapping("_BOOL","_unsigned_int",0);
	 SWIG_RegisterMapping("_signed_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_signed_int","_BOOL",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_WORD",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_DWORD","_FLAGS",0);
	 SWIG_RegisterMapping("_DWORD","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_DWORD","_HRESULT",0);
	 SWIG_RegisterMapping("_DWORD","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_DWORD","_ULONG",0);
	 SWIG_RegisterMapping("_DWORD","_LONG",0);
	 SWIG_RegisterMapping("_DWORD","_unsigned_long",0);
	 SWIG_RegisterMapping("_DWORD","_long",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_LONG","_FLAGS",0);
	 SWIG_RegisterMapping("_LONG","_HRESULT_KEEP",0);
	 SWIG_RegisterMapping("_LONG","_HRESULT",0);
	 SWIG_RegisterMapping("_LONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_LONG","_ULONG",0);
	 SWIG_RegisterMapping("_LONG","_long",0);
	 SWIG_RegisterMapping("_LONG","_signed_long",0);
	 SWIG_RegisterMapping("_LONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_LONG","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOL",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_WORD",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_int","_BOOL",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
