// PyMapiUtil.h

PyObject *PyMAPIObject_FromTypedUnknown( ULONG typ, IUnknown *pUnk, BOOL bAddRef);

BOOL PyMAPIObject_AsSBinaryArray(PyObject *ob, SBinaryArray *pv);
void PyMAPIObject_FreeSBinaryArray(SBinaryArray *pv);


BOOL PyMAPIObject_AsSPropValue(PyObject *ob, SPropValue *pv, void *pAllocMoreLinkBlock);
PyObject *PyMAPIObject_FromSPropValue(SPropValue *pv);

PyObject *PyMAPIObject_FromSRow(SRow *pr);
PyObject *PyMAPIObject_FromSRowSet(SRowSet *prs);

BOOL PyMAPIObject_AsSRowSet(PyObject *obSeq, SRowSet **ppResult, BOOL bNoneOK);
void PyMAPIObject_FreeSRowSet(SRowSet *pResult);

#define PyMAPIObject_FromADRLIST(prs) PyMAPIObject_FromSRowSet((SRowSet *)(prs))

#define PyMAPIObject_AsADRLIST(obSeq, ppResult, bNoneOK) PyMAPIObject_AsSRowSet(obSeq, (SRowSet **)(ppResult), bNoneOK)
#define PyMAPIObject_FreeADRLIST(p) PyMAPIObject_FreeSRowSet((SRowSet *)(p))

inline BOOL PyMAPIObject_AsSSortOrderSet(PyObject *obsos, SSortOrderSet **ppsos) 
{
	if (obsos==Py_None) {
		*ppsos = NULL;
		return TRUE;
	} else {
		PyErr_SetString(PyExc_TypeError, "Only None is supported for SSortOrderSet!");
		return FALSE;
	}
}
inline void PyMAPIObject_FreeSSortOrderSet(SSortOrderSet *ppsos) 
{
}

inline BOOL PyMAPIObject_AsSRestriction(PyObject *obsos, SRestriction **ppr) 
{
	if (obsos==Py_None) {
		*ppr = NULL;
		return TRUE;
	} else {
		PyErr_SetString(PyExc_TypeError, "Only None is supported for SRestriction!");
		return FALSE;
	}
}
inline void PyMAPIObject_FreeSRestriction(SRestriction *pr) 
{
}

BOOL PyMAPIObject_AsSPropTagArray(PyObject *obsos, SPropTagArray **ppta);

void PyMAPIObject_FreeSPropTagArray(SPropTagArray *pta);

PyObject *PyMAPIObject_FromSPropTagArray(SPropTagArray *pta);

BOOL PyMAPIObject_AsMAPINAMEIDArray(PyObject *ob, MAPINAMEID ***pppNameId, ULONG *pNumIds, BOOL bNoneOK = FALSE);

void PyMAPIObject_FreeMAPINAMEIDArray(MAPINAMEID **pv);
