/* File : PyIMAPISession.i */

%module IMAPISession // An COM interface to MAPI

%include "typemaps.i"
%include "pywin32.i"
%include "pythoncom.i"
%include "mapilib.i"

%{

#include "PyIMAPISession.h"

PyIMAPISession::PyIMAPISession(IUnknown *pDisp) :
	PyIUnknown(pDisp)
{
	ob_type = &type;
}

PyIMAPISession::~PyIMAPISession()
{
}

/*static*/ IMAPISession *PyIMAPISession::GetI(PyObject *self)
{
	return (IMAPISession *)PyIUnknown::GetI(self);
}

PyObject *PyIMAPISession::OpenEntry(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
    char * entryString;
	int entryStrLen;
    IID iid;
	IID *pIID;
    PyObject * objIID = 0;
    unsigned long  flags;
    IUnknown * pUnk = NULL;
	ULONG resType;
	PyObject *obEntry;

	IMAPISession *_swig_self;
	if ((_swig_self=GetI(self))==NULL) return NULL;
    if(!PyArg_ParseTuple(args,"OOl:OpenEntry", &obEntry, &objIID,&flags)) 
        return NULL;
	if (obEntry==Py_None) {
		entryString = NULL;
		entryStrLen = 0;
	} else if PyString_Check(obEntry) {
		entryString = PyString_AsString(obEntry);
		entryStrLen = PyString_Size(obEntry);
	} else {
		PyErr_SetString(PyExc_TypeError, "EntryID must be a string or None");
		return NULL;
	}
	if (objIID==Py_None)
		pIID = NULL;
	else {
		pIID = &iid;
		if (!PyCom_CLSIDFromPyObject(objIID, pIID))
			return NULL;
	}
     _result = (HRESULT )_swig_self->OpenEntry(entryStrLen,(ENTRYID *)entryString,pIID,flags, &resType, &pUnk);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 return PyMAPIObject_FromTypedUnknown( resType, pUnk, FALSE /*bAddRef*/);
}

PyObject *PyIMAPISession::OpenMsgStore(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
    char * entryString;
	int entryStrLen;
    IID iid;
	IID *pIID;
    PyObject * objIID = 0;
    unsigned long  ulParm;
    unsigned long  flags;
    IMsgStore * pMS = NULL;

	IMAPISession *_swig_self;
	if ((_swig_self=GetI(self))==NULL) return NULL;
    if(!PyArg_ParseTuple(args,"ls#Ol:OpenEntry",&ulParm,&entryString,&entryStrLen, &objIID,&flags)) 
        return NULL;
	if (objIID==Py_None)
		pIID = NULL;
	else {
		pIID = &iid;
		if (!PyCom_CLSIDFromPyObject(objIID, pIID))
			return NULL;
	}
     _result = (HRESULT )_swig_self->OpenMsgStore(ulParm, entryStrLen,(ENTRYID *)entryString,pIID,flags,&pMS);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
     return PyCom_PyObjectFromIUnknown(pMS, IID_IMsgStore, FALSE /*bAddRef*/ );
}


%}


HRESULT GetLastError(HRESULT hr, unsigned long flags, MAPIERROR **OUTPUT);

HRESULT GetMsgStoresTable(unsigned long ulFlags, IMAPITable **OUTPUT );

HRESULT Logoff( unsigned long ulUIParam, unsigned long ulFlags, unsigned long ulReserved );

%native(OpenEntry) OpenEntry; // OpenEntry manually done :-(
%native(OpenMsgStore) OpenMsgStore;

// @pyswig <o PyIAddrBook>|OpenAddressBook|Opens the integrated address book.
HRESULT OpenAddressBook(
	unsigned long ulUIParm, // @pyparm int|uiParm||hwnd of a dialog is to be displayed.
	IID *INPUT_NULLOK, // @pyparm <o PyIID>|iid||The IID of the interface, or None.
	unsigned long flags, // @pyparm int|flags||Flags that control the opening - AB_NO_DIALOG.
	IAddrBook **OUTPUT
);