// PyGActiveScript.cpp

#include "stdafx.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGActiveScript::AddRef(void) {return PyGatewayBase::AddRef();} \
STDMETHODIMP_(ULONG) PyGActiveScript::Release(void) {return PyGatewayBase::Release();} \
STDMETHODIMP PyGActiveScript::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);} \
STDMETHODIMP PyGActiveScript::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);} \
STDMETHODIMP PyGActiveScript::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);} \
STDMETHODIMP PyGActiveScript::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);} \
STDMETHODIMP PyGActiveScript::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGActiveScript::SetScriptSite(
		/* [in]  */ IActiveScriptSite *pioss
	)
{
	PY_GATEWAY_METHOD;
	PyObject *obSite = PyCom_PyObjectFromIUnknown(pioss, IID_IActiveScriptSite, TRUE);
	HRESULT hr = InvokeViaPolicy("SetScriptSite", NULL, "O", obSite);
	Py_DECREF(obSite);
	return hr;
}

STDMETHODIMP PyGActiveScript::GetScriptSite(
		/* [in]  */ REFIID iid,
		/* [out] */ VOID **ppvSiteObject
		)
{
	PY_GATEWAY_METHOD;
	*ppvSiteObject = NULL;
	PyObject *obIID = PyCom_PyIIDObjectFromIID(iid);
	if (!obIID)
		return PyCom_SetFromSimple(E_OUTOFMEMORY, GetIID());

	PyObject *result = NULL;
	HRESULT hr = InvokeViaPolicy("GetScriptSite", &result, "O", obIID);

	Py_DECREF(obIID);
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGActiveScript::SetScriptState(
		/* [in]  */ SCRIPTSTATE ss
	)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("SetScriptState", NULL, "i", (int)ss);
}

STDMETHODIMP PyGActiveScript::GetScriptState(
		/* [out] */ SCRIPTSTATE *pssState
	)
{
	if (pssState==NULL) return E_INVALIDARG;
	PY_GATEWAY_METHOD;
	PyObject *result = NULL;
	HRESULT hr = InvokeViaPolicy("GetScriptState", &result, NULL);
	if (FAILED(hr))
		return hr;
	if (result && PyInt_Check(result))
		*pssState = (SCRIPTSTATE)PyInt_AsLong(result);
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGActiveScript::Close(void)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Close", NULL, NULL);
}

STDMETHODIMP PyGActiveScript::AddNamedItem(
		/* [in]  */ LPCOLESTR pstrName,
		/* [in]  */ DWORD dwFlags
	)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	return InvokeViaPolicy(	"AddNamedItem", NULL, 
											"si",
											OLE2CT(pstrName),
											dwFlags);
}

STDMETHODIMP PyGActiveScript::AddTypeLib(
		/* [in]  */ REFGUID rguidTypeLib,
		/* [in]  */ DWORD dwMajor,
		/* [in]  */ DWORD dwMinor,
		/* [in]  */ DWORD dwFlags
	)
{
	return E_FAIL;
}

STDMETHODIMP PyGActiveScript::GetScriptDispatch(
		/* [in]  */ LPCOLESTR pstrItemName,
		/* [out] */ IDispatch **ppdisp
	)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	*ppdisp = NULL;
	PyObject *result = NULL;
	HRESULT hr = InvokeViaPolicy("GetScriptDispatch", &result,
											"z",
											OLE2CT(pstrItemName));
	if (FAILED(hr))
		return hr;

	if (result)
		PyCom_InterfaceFromPyObject(result, IID_IDispatch, (void **)ppdisp, FALSE);
	if (PyErr_Occurred())
		hr = PyCom_SetFromPyException();
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGActiveScript::GetCurrentScriptThreadID(
		/* [out] */ SCRIPTTHREADID *pstidThread
	)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("GetCurrentScriptThreadID",&result, 
											NULL);
	if (FAILED(hr))	return hr;

	if (PyInt_Check(result)) {
		*pstidThread = PyInt_AsLong(result);
		if (PyErr_Occurred())
			hr = PyCom_SetFromPyException();
	}
	else
		hr = PyCom_SetFromSimple(E_FAIL, GetIID());

	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGActiveScript::GetScriptThreadID(
		/* [in]  */ DWORD dwWin32ThreadId,
		/* [out] */ SCRIPTTHREADID *pstidThread
	)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("GetScriptThreadID", &result,
											"i", dwWin32ThreadId);
	if (FAILED(hr)) return hr;
	if (PyInt_Check(result)) {
		*pstidThread = PyInt_AsLong(result);
		if (PyErr_Occurred())
			hr = PyCom_SetFromPyException();
	}
	else
		hr = PyCom_SetFromSimple(E_FAIL, GetIID());
	return hr;
}

STDMETHODIMP PyGActiveScript::GetScriptThreadState(
		/* [in]  */ SCRIPTTHREADID stidThread,
		/* [out] */ SCRIPTTHREADSTATE *pstsState
	)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("GetScriptThreadState", &result,
											"i", stidThread);

	if (FAILED(hr)) return hr;
	if (PyInt_Check(result)) {
		*pstsState = (SCRIPTTHREADSTATE)PyInt_AsLong(result);
		if (PyErr_Occurred())
			hr = PyCom_HandlePythonFailureToCOM();
	}
	else
		hr = PyCom_SetFromSimple(E_FAIL, GetIID());
	Py_XDECREF(result);
	return hr;
}

extern "C" __declspec( dllimport) void PyErr_SetInterrupt();

STDMETHODIMP PyGActiveScript::InterruptScriptThread(
		/* [in]  */ SCRIPTTHREADID stidThread,
		/* [in]  */ const EXCEPINFO *pexcepinfo,
		/* [in]  */ DWORD dwFlags
	)
{
	PyErr_SetInterrupt();
	return S_OK;
}

STDMETHODIMP PyGActiveScript::Clone(
		/* [out] */ IActiveScript **ppscript
	)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("Clone", &result, 
											NULL);
	if (FAILED(hr)) return hr;
	if (!PyCom_InterfaceFromPyObject(result, IID_IActiveScript, (void **)ppscript, FALSE))
		hr = PyCom_SetFromPyException();
	Py_XDECREF(result);
	return hr;
}
