import string
import ni
import win32com.axscript.axscript
import winerror
from win32com.axscript import axscript
from __.__.__.server import exception
from __.__.__.server import util
from __.__.__ import pythoncom

class AXEngine:
  def __init__(self, site, engine):
    if type(engine) == type(''):
      engine = pythoncom.CoCreateInstance(engine,
                                          None,
                                          pythoncom.CLSCTX_SERVER,
                                          pythoncom.IID_IUnknown)

    self.eScript = engine.QueryInterface(axscript.IID_IActiveScript)
    self.eParse = engine.QueryInterface(axscript.IID_IActiveScriptParse)
    self.eSafety = engine.QueryInterface(axscript.IID_IObjectSafety)

    self.eScript.SetScriptSite(util.wrap(site))
    self.eParse.InitNew()
  def GetScriptDispatch(self):
    return self.eScript.GetScriptDispatch()
  def AddNamedItem(self, item, flags):
    return self.eScript.AddNamedItem(item, flags)
  def SetScriptState(self, state):
    return self.eScript.SetScriptState(state)
  # Some helpers.  
  def AddCode(self, code):
    self.eParse.ParseScriptText(code, None, None, None, 0, 0, 0)
  def EvalCode(self, code):
    return self.eParse.ParseScriptText(code, None, None, None, 0, 0, axscript.SCRIPTTEXT_ISEXPRESSION)
  def Start(self):
    # Should maybe check state?
    self.eScript.SetScriptState(axscript.SCRIPTSTATE_STARTED) # Actually run the text
		
IActiveScriptSite_methods = [
  'GetLCID',
  'GetItemInfo',
  'GetDocVersionString',
  'OnScriptTerminate',
  'OnStateChange',
  'OnScriptError',
  'OnEnterScript',
  'OnLeaveScript',
  ]

class AXSite:
  _public_methods_ = IActiveScriptSite_methods
  _com_interfaces_ = [ axscript.IID_IActiveScriptSite ]

  def __init__(self, objModel={}, engine = None, lcid=0):
    self.lcid = lcid

    self.objModel = { }
    for name, object in objModel.items():
      # Gregs code did string.lower this - I think that is callers job if he wants!
      self.objModel[name] = object

    self.engines = []
    if engine:
      self._AddEngine(engine)
    
  def _GetEngines(self):
    return self.engines

  def _AddEngine(self, engine):
    newEngine = AXEngine(self, engine) 
    self.engines.append(newEngine)
    flags = axscript.SCRIPTITEM_ISVISIBLE | axscript.SCRIPTITEM_NOCODE
    for name in self.objModel.keys():
      newEngine.AddNamedItem(name, flags)
      newEngine.SetScriptState(axscript.SCRIPTSTATE_INITIALIZED)
    return newEngine

  def GetLCID(self):
    return self.lcid

  def GetItemInfo(self, name, returnMask):
#    name = string.lower(name)
    if not self.objModel.has_key(name):
      raise exception.Exception(scode=winerror.TYPE_E_ELEMENTNOTFOUND, desc='item not found')

    ### for now, we don't have any type information

    if returnMask & axscript.SCRIPTINFO_IUNKNOWN:
      return (self.objModel[name], None)

    return (None, None)

  def GetDocVersionString(self):
    return 'Python AXHost version 1.0'

  def OnScriptTerminate(self, result, excepInfo):
    pass

  def OnStateChange(self, state):
    pass

  def OnScriptError(self, errorInterface):
    return winerror.S_FALSE  

  def OnEnterScript(self):
    pass

  def OnLeaveScript(self):
    pass
