import string, ni, os, sys, traceback, winerror
from win32com.axscript import axscript
from win32com.axscript.server import axsite
from win32com.axscript.server.error import Exception
from win32com import pythoncom
from win32com.server import util

version = "0.0.1"

class MySite(axsite.AXSite):

  def runCode(self, code):
    self.eParse.ParseScriptText(code, None, None, None, 0, 0, 0)

  def evalCode(self, code):
    return self.eParse.ParseScriptText(code, None, None, None, 0, 0,
                                       axscript.SCRIPTTEXT_ISEXPRESSION)

  def OnScriptError(self, error):
    exc = error.GetExceptionInfo()
    try:
      text = error.GetSourceLineText()
    except:
      text = "<unknown>"
    context, line, char = error.GetSourcePosition()
    heading="Exception: %s (line %d)" % (exc[1], line)
    print "%s\n%s\n%s\n%s^\n%s" % ("_" * len(heading), heading, text, " " * (char-1), exc[2])
    return winerror.E_FAIL # Just bomb out.

class ArgsObject:
  _public_methods_ = [ 'Count', "Item" ]
  def __init__(self, mylist):
    self._mylist_ = mylist
  def Count(self):
    return len(self._mylist_)
  def Item(self, num):
    return self._mylist_[num]
  def _value_(self, item):
    return self.Item(item)
  def _NewEnum(self):
    return util.NewEnum(self._mylist_)

class ObjectModel:
  _public_methods_ = [ 'echo', "createobject", "getobject" ]
  _public_attrs_ = ['application', 'name', 'version','fullname', 'path', 'arguments', 'interactive', 'scriptfullname', 'scriptfilename']
  _readonly_attrs_ = _public_attrs_[:]
  def __init__(self, args):
    self.name = "Python Scripting Host"
    import win32api
    self.fullname = win32api.GetFullPathName(sys.argv[0])
    self.version = version
    self.path = os.getcwd()
    self.arguments = util.wrap(ArgsObject(args[1:]))
    self.scriptfullname = win32api.GetFullPathName(args[0])
    self.scriptfilename = os.path.split(args[0])[1]
    self.interactive = 1
    self.application = util.wrap(self)

  def echo(self, *args):
    print string.join(map(str, args))
  def createobject(self, clsid):
    return pythoncom.new(clsid)
  def getobject(self, clsid):
    return pythoncom.connect(clsid)

def TestEngine(engineName, code, model, entryPoint = None):
  site = MySite(engineName, model)
  try:
    site.runCode(code)
    site.eScript.SetScriptState(axscript.SCRIPTSTATE_STARTED) # Actually run the text
    if entryPoint:
      # Now call into the scripts IDispatch
      from win32com.client.dynamic import Dispatch
      ob = Dispatch(site.eScript.GetScriptDispatch())
      ep = getattr(ob, entryPoint)
      ep()
  except pythoncom.com_error, details:
    print "Script failed: %s (0x%x)" % (details[1], details[0])
  site.eScript.Close()

def doit():
	print "Python Scripting Host (%s)" % version
	import sys, os, string
	entryPoint = None
	args = sys.argv[1:]
	while args[0][:2]=='//':
		arg = args[0]
		args.remove(arg)
		if arg[2:]=='e':
			entryPoint = args[0]
			args.remove(entryPoint)
		else:
			print "Unknown option"
			return

	fname = args[0]
	exts = {'.pys' : "Python", '.vbs' : "VBScript", '.js' : "JScript"}
	try: 	# Later look up registry.
		language = exts[string.lower(os.path.splitext(fname)[1])]
		data = open(fname).read()
	except KeyError:
		print "The language for the file %s is unknown" % fname
		return 1
	except IOError:
		print "Could not open file", fname
		return 1
	model = {'WScript' : util.wrap(ObjectModel(args)) }
	TestEngine(language, data, model, entryPoint)

if __name__ == '__main__':
  try:
    doit()
  except:
    traceback.print_exc()
  sys.exc_type = sys.exc_value = sys.exc_traceback = None

