# Utility function for wrapping objects.  Centralising allows me to turn
# debugging on and off for the entire package in a single spot.

import sys
import win32com.server.util
from win32com.server.exception import Exception

# The AXDebugging implementation assumes that the returned COM pointers are in
# some cases identical.  Eg, from a C++ perspective:
# p->GetSomeInterface( &p1 );
# p->GetSomeInterface( &p2 );
# p1==p2
# By default, this is _not_ true for Python.

# Therefore we cache all wrapped objects, to ensure we return the same
# one.  BIG BIG downside is that this creates a circular reference
# which can be removed via "_wrap_remove(object)"
# Note that attmepting to make this call in an objects __del__ will _not_
# work, as the circular reference will prevent __del__ from ever being called.

all_wrapped = {} # Dict is indexed by object, and has a list of (iid, wrapped_object)

def _wrap(object, iid, cache=1):
	return _dowrap( win32com.server.util.wrap, object, iid, cache)

def _wrap_force(object, iid, cache=1):
	return _dowrap( win32com.server.util.wrap_force, object, iid, cache)

import win32api
def trace(*args):
	print str(win32api.GetCurrentThreadId()) + ":",
	for arg in args:
		print arg,
	print

def _dowrap(fn, object, iid, cache):
	# Check the cache
	try:
		if cache:
			iid_list = all_wrapped[id(object)]
			for lookiid, wrapped in iid_list:
				if iid==lookiid:
					return wrapped
	except KeyError:
		pass
		
	# Make a new wrapped object.
	dispatcher = None
#	import win32com.server.policy
#	dispatcher = win32com.server.policy.DispatcherWin32trace
#	dispatcher = Dispatcher
	policy = None
	rc = apply(fn, (object, iid, policy, dispatcher))
	
	# Now cache it.
	if cache:
		if not all_wrapped.has_key(id(object)):
			all_wrapped[id(object)]=[]
		all_wrapped[id(object)].append((iid, rc))
	return rc

def _wrap_remove(object, iid = None):
	if not all_wrapped.has_key(id(object)):
		return
	if iid is None:
		# Remove the lot
		del all_wrapped[id(object)]
		return
	# Find the specific IID.
	iidlist = all_wrapped[id(object)]
	for item in iidlist:
		if item[0]==iid:
			all_wrapped[id(object)].remove(item)
			break

def _dump_wrapped():
	print "Wrapped items:"
	for key, items in win32com.axdebug.util.all_wrapped.items():
		for iid, obj in items:
			print obj


import win32com.server.policy
class Dispatcher(win32com.server.policy.DispatcherWin32trace):
	def __init__(self, policyClass, object):
		win32com.server.policy.DispatcherTrace.__init__(self, policyClass, object)
		import win32traceutil # Sets up everything.
#		print "Object with win32trace dispatcher created (object=%s)" % `object`

	def _QueryInterface_(self, iid):
		rc = win32com.server.policy.DispatcherBase._QueryInterface_(self, iid)
#		if not rc:
#			self._trace_("in _QueryInterface_ with unsupported IID %s (%s)\n" % (IIDToInterfaceName(iid),iid))
		return rc

	def _Invoke_(self, dispid, lcid, wFlags, args):
		print "In Invoke with", dispid, lcid, wFlags, args, "with object",self.policy._obj_
		try:
			rc = win32com.server.policy.DispatcherBase._Invoke_(self, dispid, lcid, wFlags, args)
#			print "Invoke of", dispid, "returning", rc
			return rc
		except Exception:
			scode = sys.exc_value.scode
			try:
				desc = " (" + str(sys.exc_value.description) + ")"
			except AttributeError:
				desc = ""
			print "*** Invoke of %s raised COM exception 0x%x%s" % (dispid, scode, desc)
		except:
			print "*** Invoke of %s failed:" % dispid
			typ, val, tb = sys.exc_type, sys.exc_value, sys.exc_traceback
			import traceback
			traceback.print_exception(typ, val, tb)
			raise typ, val, tb

