"""Support for stack-frames.

Provides Implements a nearly complete wrapper for a stack frame.
"""
from util import _wrap
import gateways, axdebug
from win32com import pythoncom

class EnumDebugStackFrames(gateways.EnumDebugStackFrames):
	def _wrap(self, obj):
		# This enum returns a tuple, with 2 com objects in it.
		obFrame, min, lim, fFinal, obFinal = obj
		obFrame = _wrap(obFrame, axdebug.IID_IDebugStackFrame, 0)
		if obFinal:
			obFinal = _wrap(obFinal, pythoncom.IID_IUnknown, 0)
		return obFrame, min, lim, fFinal, obFinal

class DebugStackFrame(gateways.DebugStackFrame):
	def __init__(self, frame):
		self.frame = frame
	def _query_interface_(self, iid):
		from win32com.util import IIDToInterfaceName
		print "DebugStackFrame QI with %s (%s)" % (IIDToInterfaceName(iid), str(iid))
		return 0
	#
	# The following need implementation
	def GetThread(self):
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetCodeContext(self):
		raise Exception(scode=winerror.E_NOTIMPL)
	#
	# The following are usefully implemented
	def GetDescriptionString(self, fLong):
		import repr, string
		filename = self.frame.f_code.co_filename
		s = filename
		if self.frame.f_code.co_name:
		    s = s +self. frame.f_code.co_name
		else:
		    s = s + "<lambda>"
		if fLong: # Return args too (even tho we cant !!!)
			args = None # ???
			if args:
				s = s + repr.repr(args)
			else:
				s = s + '()'
		return s
	def GetLanguageString(self, fLong):
		if fLong:
			return "Python ActiveX Scripting Engine"
		else:
			return "Python"

