// This file implements the IEnumDebugStackFrames Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIEnumDebugStackFrames.h"

// @doc - This file contains autoduck documentation

// ---------------------------------------------------
//
// Interface Implementation

PyIEnumDebugStackFrames::PyIEnumDebugStackFrames(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIEnumDebugStackFrames::~PyIEnumDebugStackFrames()
{
}

/* static */ IEnumDebugStackFrames *PyIEnumDebugStackFrames::GetI(PyObject *self)
{
	return (IEnumDebugStackFrames *)PyIUnknown::GetI(self);
}

// @pymethod object|PyIEnumDebugStackFrames|Next|Retrieves a specified number of items in the enumeration sequence.
PyObject *PyIEnumDebugStackFrames::Next(PyObject *self, PyObject *args)
{
	long celt = 1;
	// @pyparm int|num|1|Number of items to retrieve.
	if ( !PyArg_ParseTuple(args, "|l:Next", &celt) )
		return NULL;

	IEnumDebugStackFrames *pIEDebugStackFrames = GetI(self);
	if ( pIEDebugStackFrames == NULL )
		return NULL;

	DebugStackFrameDescriptor *rgVar = new DebugStackFrameDescriptor [celt];
	if ( rgVar == NULL )
		return OleSetMemoryError("allocating result IDebugStackFrameDescriptor");

	int i;
/*	for ( i = celt; i--; )
		// *** possibly init each structure element???
*/

	ULONG celtFetched = 0;
	HRESULT hr = pIEDebugStackFrames->Next(celt, rgVar, &celtFetched);
	if (  HRESULT_CODE(hr) != ERROR_NO_MORE_ITEMS && FAILED(hr) )
	{
		delete [] rgVar;
		return SetPythonCOMError(self,hr);
	}

	PyObject *result = PyTuple_New(celtFetched);
	if ( result != NULL )
	{
		for ( i = celtFetched; i--; )
		{
			// Make a result tuple.
			PyObject *obFrame = PyCom_PyObjectFromIUnknown(rgVar[i].pdsf, IID_IDebugStackFrame, FALSE);
			PyObject *obUnkFinal = PyCom_PyObjectFromIUnknown(rgVar[i].punkFinal, IID_IUnknown, FALSE);
			if ( obFrame == NULL || obUnkFinal==NULL)
			{
				Py_DECREF(result);
				Py_XDECREF(obFrame);
				Py_XDECREF(obUnkFinal);
				result = NULL;
				break;
			}
			PyTuple_SET_ITEM(result, i, Py_BuildValue("OiiiO", obFrame, rgVar[i].dwMin, rgVar[i].dwLim, rgVar[i].fFinal, obUnkFinal));
			Py_DECREF(obFrame);
			Py_DECREF(obUnkFinal);
		}
	}

/*	for ( i = celtFetched; i--; )
		// *** possibly cleanup each structure element???
*/
	delete [] rgVar;
	return result;
}

// @pymethod |PyIEnumDebugStackFrames|Skip|Skips over the next specified elementes.
PyObject *PyIEnumDebugStackFrames::Skip(PyObject *self, PyObject *args)
{
	long celt;
	if ( !PyArg_ParseTuple(args, "l:Skip", &celt) )
		return NULL;

	IEnumDebugStackFrames *pIEDebugStackFrames = GetI(self);
	if ( pIEDebugStackFrames == NULL )
		return NULL;

	HRESULT hr = pIEDebugStackFrames->Skip(celt);
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);

	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIEnumDebugStackFrames|Reset|Resets the enumeration sequence to the beginning.
PyObject *PyIEnumDebugStackFrames::Reset(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":Reset") )
		return NULL;

	IEnumDebugStackFrames *pIEDebugStackFrames = GetI(self);
	if ( pIEDebugStackFrames == NULL )
		return NULL;

	HRESULT hr = pIEDebugStackFrames->Reset();
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);

	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod <o PyIEnumDebugStackFrames>|PyIEnumDebugStackFrames|Clone|Creates another enumerator that contains the same enumeration state as the current one
PyObject *PyIEnumDebugStackFrames::Clone(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":Clone") )
		return NULL;

	IEnumDebugStackFrames *pIEDebugStackFrames = GetI(self);
	if ( pIEDebugStackFrames == NULL )
		return NULL;

	IEnumDebugStackFrames *pClone;
	HRESULT hr = pIEDebugStackFrames->Clone(&pClone);
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);

	return PyCom_PyObjectFromIUnknown(pClone, IID_IEnumDebugStackFrames, FALSE);
}

// @object PyIEnumDebugStackFrames|A Python interface to IEnumDebugStackFrames
static struct PyMethodDef PyIEnumDebugStackFrames_methods[] =
{
	{ "Next", PyIEnumDebugStackFrames::Next, 1 },    // @pymeth Next|Retrieves a specified number of items in the enumeration sequence.
	{ "Skip", PyIEnumDebugStackFrames::Skip, 1 },	// @pymeth Skip|Skips over the next specified elementes.
	{ "Reset", PyIEnumDebugStackFrames::Reset, 1 },	// @pymeth Reset|Resets the enumeration sequence to the beginning.
	{ "Clone", PyIEnumDebugStackFrames::Clone, 1 },	// @pymeth Clone|Creates another enumerator that contains the same enumeration state as the current one.
	{ NULL }
};

PyComTypeObject PyIEnumDebugStackFrames::type("PyIEnumDebugStackFrames",
		&PyIUnknown::type,
		sizeof(PyIEnumDebugStackFrames),
		PyIEnumDebugStackFrames_methods,
		GET_PYCOM_CTOR(PyIEnumDebugStackFrames));

// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGEnumDebugStackFrames::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGEnumDebugStackFrames::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGEnumDebugStackFrames::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGEnumDebugStackFrames::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGEnumDebugStackFrames::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGEnumDebugStackFrames::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGEnumDebugStackFrames::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGEnumDebugStackFrames::Next( 
            /* [in] */ ULONG celt,
            /* [length_is][size_is][out] */ DebugStackFrameDescriptor __RPC_FAR *rgVar,
            /* [out] */ ULONG __RPC_FAR *pCeltFetched)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("Next", &result, "i", celt);
	if ( FAILED(hr) )
		return hr;

	if ( !PySequence_Check(result) )
		goto error;
	int len;
	len = PyObject_Length(result);
	if ( len == -1 )
		goto error;
	if ( len > (int)celt)
		len = celt;

	if ( pCeltFetched )
		*pCeltFetched = len;

	int i;
	for ( i = 0; i < len; ++i )
	{
		PyObject *ob = PySequence_GetItem(result, i);
		if ( ob == NULL )
			goto error;
		if (!PyTuple_Check(ob)) {
			Py_DECREF(ob);
			PyErr_SetString(PyExc_TypeError, "PyIEnumDebugStackFrames::Next must return a tuple.");
			goto error;
		}
		PyObject *obEnum, *obUnk;
		if (!PyArg_ParseTuple(ob, "OiiiO", &obEnum, &rgVar[i].dwMin, &rgVar[i].dwLim, &rgVar[i].fFinal, &obUnk)) {
			Py_DECREF(ob);
			goto error;
		}

		if ( !PyCom_InterfaceFromPyInstanceOrObject(obEnum, IID_IDebugStackFrame, (void **)&rgVar[i].pdsf, FALSE) ||
		     !PyCom_InterfaceFromPyInstanceOrObject(obUnk, IID_IUnknown, (void **)&rgVar[i].punkFinal, TRUE) )
		{
			Py_DECREF(ob);
			Py_DECREF(result);
			return PyCom_SetFromSimple(E_OUTOFMEMORY, IID_IEnumDebugStackFrames);
		}
		Py_DECREF(ob);
	}

	Py_DECREF(result);

	return len < (int)celt ? S_FALSE : S_OK;

  error:
	hr = PyErr_Occurred() ? PyCom_SetFromPyException(IID_IEnumDebugStackFrames)
		                          : PyCom_SetFromSimple(E_FAIL, IID_IEnumDebugStackFrames);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGEnumDebugStackFrames::Skip( 
            /* [in] */ ULONG celt)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Skip", NULL, "i", celt);
}

STDMETHODIMP PyGEnumDebugStackFrames::Reset(void)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Reset");
}

STDMETHODIMP PyGEnumDebugStackFrames::Clone( 
            /* [out] */ IEnumDebugStackFrames __RPC_FAR *__RPC_FAR *ppEnum)
{
	PY_GATEWAY_METHOD;
	PyObject * result;
	HRESULT hr = InvokeViaPolicy("Clone", &result);
	if ( FAILED(hr) )
		return hr;

	/*
	** Make sure we have the right kind of object: we should have some kind
	** of IUnknown subclass wrapped into a PyIUnknown instance.
	*/
	if ( !PyIBase::is_object(result, &PyIUnknown::type) )
	{
		/* the wrong kind of object was returned to us */
		Py_DECREF(result);
		return PyCom_SetFromSimple(E_FAIL, IID_IEnumDebugStackFrames);
	}

	/*
	** Get the IUnknown out of the thing. note that the Python ob maintains
	** a reference, so we don't have to explicitly AddRef() here.
	*/
	IUnknown *punk = ((PyIUnknown *)result)->m_obj;
	if ( !punk )
	{
		/* damn. the object was released. */
		Py_DECREF(result);
		return PyCom_SetFromSimple(E_FAIL, IID_IEnumDebugStackFrames);
	}

	/*
	** Get the interface we want. note it is returned with a refcount.
	** This QI is actually going to instantiate a PyGEnumDebugStackFrames.
	*/
	hr = punk->QueryInterface(IID_IEnumDebugStackFrames, (LPVOID *)ppEnum);

	/* done with the result; this DECREF is also for <punk> */
	Py_DECREF(result);

	return PyCom_SetFromSimple(hr, IID_IEnumDebugStackFrames);
}
