// This file implements the IDebugSyncOperation Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIDebugSyncOperation.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugSyncOperation::PyIDebugSyncOperation(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIDebugSyncOperation::~PyIDebugSyncOperation()
{
}

/* static */ IDebugSyncOperation *PyIDebugSyncOperation::GetI(PyObject *self)
{
	return (IDebugSyncOperation *)PyIUnknown::GetI(self);
}

// @pymethod |PyIDebugSyncOperation|GetTargetThread|Description of GetTargetThread.
PyObject *PyIDebugSyncOperation::GetTargetThread(PyObject *self, PyObject *args)
{
	IDebugSyncOperation *pIDSO = GetI(self);
	if ( pIDSO == NULL )
		return NULL;
	IDebugApplicationThread *ppatTarget;
	if ( !PyArg_ParseTuple(args, ":GetTargetThread") )
		return NULL;
	HRESULT hr = pIDSO->GetTargetThread( &ppatTarget );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	PyObject *obppatTarget;

	obppatTarget = PyCom_PyObjectFromIUnknown(ppatTarget, IID_IDebugApplicationThread, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppatTarget);
	Py_XDECREF(obppatTarget);
	return pyretval;
}

// @pymethod |PyIDebugSyncOperation|Execute|Description of Execute.
PyObject *PyIDebugSyncOperation::Execute(PyObject *self, PyObject *args)
{
	IDebugSyncOperation *pIDSO = GetI(self);
	if ( pIDSO == NULL )
		return NULL;
	IUnknown *ppunkResult;
	if ( !PyArg_ParseTuple(args, ":Execute") )
		return NULL;
	HRESULT hr = pIDSO->Execute( &ppunkResult );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	PyObject *obppunkResult;

	obppunkResult = PyCom_PyObjectFromIUnknown(ppunkResult, IID_IUnknown, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppunkResult);
	Py_XDECREF(obppunkResult);
	return pyretval;
}

// @pymethod |PyIDebugSyncOperation|InProgressAbort|Description of InProgressAbort.
PyObject *PyIDebugSyncOperation::InProgressAbort(PyObject *self, PyObject *args)
{
	IDebugSyncOperation *pIDSO = GetI(self);
	if ( pIDSO == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":InProgressAbort") )
		return NULL;
	HRESULT hr = pIDSO->InProgressAbort( );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @object PyIDebugSyncOperation|Description of the interface
static struct PyMethodDef PyIDebugSyncOperation_methods[] =
{
	{ "GetTargetThread", PyIDebugSyncOperation::GetTargetThread, 1 }, // @pymeth GetTargetThread|Description of GetTargetThread
	{ "Execute", PyIDebugSyncOperation::Execute, 1 }, // @pymeth Execute|Description of Execute
	{ "InProgressAbort", PyIDebugSyncOperation::InProgressAbort, 1 }, // @pymeth InProgressAbort|Description of InProgressAbort
	{ NULL }
};

PyComTypeObject PyIDebugSyncOperation::type("PyIDebugSyncOperation",
		&PyIUnknown::type,
		sizeof(PyIDebugSyncOperation),
		PyIDebugSyncOperation_methods,
		GET_PYCOM_CTOR(PyIDebugSyncOperation));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGDebugSyncOperation::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGDebugSyncOperation::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGDebugSyncOperation::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGDebugSyncOperation::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGDebugSyncOperation::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGDebugSyncOperation::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGDebugSyncOperation::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGDebugSyncOperation::GetTargetThread(
		/* [out] */ IDebugApplicationThread __RPC_FAR *__RPC_FAR * ppatTarget)
{
	PY_GATEWAY_METHOD;
	if (ppatTarget==NULL) return E_POINTER;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetTargetThread", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppatTarget;
	if (!PyArg_Parse(result, "O" , &obppatTarget)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyInstanceOrObject(obppatTarget, IID_IDebugApplicationThread, (void **)ppatTarget, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDebugSyncOperation::Execute(
		/* [out] */ IUnknown __RPC_FAR *__RPC_FAR * ppunkResult)
{
	PY_GATEWAY_METHOD;
	if (ppunkResult==NULL) return E_POINTER;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("Execute", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppunkResult;
	if (!PyArg_Parse(result, "O" , &obppunkResult)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyInstanceOrObject(obppunkResult, IID_IUnknown, (void **)ppunkResult, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDebugSyncOperation::InProgressAbort(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("InProgressAbort", NULL);
	return hr;
}

