// This file implements the IDebugDocumentTextExternalAuthor Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIDebugDocumentTextExternalAuthor.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugDocumentTextExternalAuthor::PyIDebugDocumentTextExternalAuthor(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIDebugDocumentTextExternalAuthor::~PyIDebugDocumentTextExternalAuthor()
{
}

/* static */ IDebugDocumentTextExternalAuthor *PyIDebugDocumentTextExternalAuthor::GetI(PyObject *self)
{
	return (IDebugDocumentTextExternalAuthor *)PyIUnknown::GetI(self);
}

// @pymethod |PyIDebugDocumentTextExternalAuthor|GetPathName|Description of GetPathName.
PyObject *PyIDebugDocumentTextExternalAuthor::GetPathName(PyObject *self, PyObject *args)
{
	IDebugDocumentTextExternalAuthor *pIDDTEA = GetI(self);
	if ( pIDDTEA == NULL )
		return NULL;
	BSTR pbstrLongName;
	BOOL pfIsOriginalFile;
	if ( !PyArg_ParseTuple(args, ":GetPathName") )
		return NULL;
	HRESULT hr = pIDDTEA->GetPathName( &pbstrLongName, &pfIsOriginalFile );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	PyObject *obpbstrLongName;

	obpbstrLongName = MakeBstrToObj(pbstrLongName);
	PyObject *pyretval = Py_BuildValue("Oi", obpbstrLongName, pfIsOriginalFile);
	SysFreeString(pbstrLongName);
	return pyretval;
}

// @pymethod |PyIDebugDocumentTextExternalAuthor|GetFileName|Description of GetFileName.
PyObject *PyIDebugDocumentTextExternalAuthor::GetFileName(PyObject *self, PyObject *args)
{
	IDebugDocumentTextExternalAuthor *pIDDTEA = GetI(self);
	if ( pIDDTEA == NULL )
		return NULL;
	BSTR pbstrShortName;
	if ( !PyArg_ParseTuple(args, ":GetFileName") )
		return NULL;
	HRESULT hr = pIDDTEA->GetFileName( &pbstrShortName );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	PyObject *obpbstrShortName;

	obpbstrShortName = MakeBstrToObj(pbstrShortName);
	PyObject *pyretval = Py_BuildValue("O", obpbstrShortName);
	SysFreeString(pbstrShortName);
	return pyretval;
}

// @pymethod |PyIDebugDocumentTextExternalAuthor|NotifyChanged|Description of NotifyChanged.
PyObject *PyIDebugDocumentTextExternalAuthor::NotifyChanged(PyObject *self, PyObject *args)
{
	IDebugDocumentTextExternalAuthor *pIDDTEA = GetI(self);
	if ( pIDDTEA == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":NotifyChanged") )
		return NULL;
	HRESULT hr = pIDDTEA->NotifyChanged( );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @object PyIDebugDocumentTextExternalAuthor|Description of the interface
static struct PyMethodDef PyIDebugDocumentTextExternalAuthor_methods[] =
{
	{ "GetPathName", PyIDebugDocumentTextExternalAuthor::GetPathName, 1 }, // @pymeth GetPathName|Description of GetPathName
	{ "GetFileName", PyIDebugDocumentTextExternalAuthor::GetFileName, 1 }, // @pymeth GetFileName|Description of GetFileName
	{ "NotifyChanged", PyIDebugDocumentTextExternalAuthor::NotifyChanged, 1 }, // @pymeth NotifyChanged|Description of NotifyChanged
	{ NULL }
};

PyComTypeObject PyIDebugDocumentTextExternalAuthor::type("PyIDebugDocumentTextExternalAuthor",
		&PyIUnknown::type,
		sizeof(PyIDebugDocumentTextExternalAuthor),
		PyIDebugDocumentTextExternalAuthor_methods,
		GET_PYCOM_CTOR(PyIDebugDocumentTextExternalAuthor));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGDebugDocumentTextExternalAuthor::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGDebugDocumentTextExternalAuthor::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGDebugDocumentTextExternalAuthor::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGDebugDocumentTextExternalAuthor::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGDebugDocumentTextExternalAuthor::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGDebugDocumentTextExternalAuthor::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGDebugDocumentTextExternalAuthor::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGDebugDocumentTextExternalAuthor::GetPathName(
		/* [out] */ BSTR __RPC_FAR * pbstrLongName,
		/* [out] */ BOOL __RPC_FAR * pfIsOriginalFile)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetPathName", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obpbstrLongName;
	if (!PyArg_ParseTuple(result, "Oi" , &obpbstrLongName, pfIsOriginalFile)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_BstrFromPyObject(obpbstrLongName, pbstrLongName)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDebugDocumentTextExternalAuthor::GetFileName(
		/* [out] */ BSTR __RPC_FAR * pbstrShortName)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetFileName", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obpbstrShortName;
	if (!PyArg_Parse(result, "O" , &obpbstrShortName)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_BstrFromPyObject(obpbstrShortName, pbstrShortName)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDebugDocumentTextExternalAuthor::NotifyChanged(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("NotifyChanged", NULL);
	return hr;
}

