// Interface Declaration

class PyIDebugDocumentInfo : public PyIUnknown
{
public:
	MAKE_PYCOM_CTOR_ERRORINFO(PyIDebugDocumentInfo, IID_IDebugDocumentInfo);
	static IDebugDocumentInfo *GetI(PyObject *self);
	static PyComTypeObject type;

	// The Python methods
	static PyObject *GetName(PyObject *self, PyObject *args);
	static PyObject *GetDocumentClassId(PyObject *self, PyObject *args);

protected:
	PyIDebugDocumentInfo(IUnknown *pdisp);
	~PyIDebugDocumentInfo();
};
// ---------------------------------------------------
//
// Gateway Declaration

class PyGDebugDocumentInfo : public PyGatewayBase, public IDebugDocumentInfo
{
protected:
	PyGDebugDocumentInfo(PyObject *instance) : PyGatewayBase(instance) { ; }
	PYGATEWAY_MAKE_SUPPORT(PyGDebugDocumentInfo, IDebugDocumentInfo, IID_IDebugDocumentInfo)

	// IUnknown and IDispatch
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// IDebugDocumentInfo
	STDMETHOD(GetName)(  
		DOCUMENTNAMETYPE dnt,  
		BSTR *pbstrName);  
	STDMETHOD(GetDocumentClassId)(
		CLSID *pclsidDocument);
};
