// This file implements the IDebugDocumentInfo Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"

#include "PyIDebugDocumentInfo.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugDocumentInfo::PyIDebugDocumentInfo(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIDebugDocumentInfo::~PyIDebugDocumentInfo()
{
}

/* static */ IDebugDocumentInfo *PyIDebugDocumentInfo::GetI(PyObject *self)
{
	return (IDebugDocumentInfo *)PyIUnknown::GetI(self);
}

// @pymethod |PyIDebugDocumentInfo|GetName|Returns the specified name for the document.
PyObject *PyIDebugDocumentInfo::GetName(PyObject *self, PyObject *args)
{
	IDebugDocumentInfo *pIDDP = GetI(self);
	if ( pIDDP == NULL )
		return NULL;
	DOCUMENTNAMETYPE dnt;
	if ( !PyArg_ParseTuple(args, "i:GetName", &dnt) )
		return NULL;
	BSTR pbstrName;
	HRESULT hr = pIDDP->GetName( dnt, &pbstrName );
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);

	PyObject *obpbstrName = MakeBstrToObj(pbstrName);
	PyObject *pyretval = Py_BuildValue("O", obpbstrName);
	SysFreeString(pbstrName);
	return pyretval;
}

// @pymethod <o PyIID>|PyIDebugDocumentInfo|GetDocumentClassId|Returns a CLSID describing the document type.
PyObject *PyIDebugDocumentInfo::GetDocumentClassId(PyObject *self, PyObject *args)
{
	IDebugDocumentInfo *pIDD = GetI(self);
	if ( pIDD == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":GetDocumentClassId") )
		return NULL;
	CLSID pclsidDocument;
	HRESULT hr = pIDD->GetDocumentClassId( &pclsidDocument );
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);

	PyObject *obpclsidDocument = PyCom_PyIIDObjectFromIID(pclsidDocument);
	PyObject *pyretval = Py_BuildValue("O", obpclsidDocument);
	Py_XDECREF(obpclsidDocument);
	return pyretval;
}


// @object PyIDebugDocumentInfo|Provides information on a document, which may or may not be instantiated.
static struct PyMethodDef PyIDebugDocumentInfo_methods[] =
{
	{ "GetName", PyIDebugDocumentInfo::GetName, 1 }, // @pymeth GetName|Returns the specified name for the document.
	{ "GetDocumentClassId", PyIDebugDocumentInfo::GetDocumentClassId, 1 }, // @pymeth GetDocumentClassId|Returns a CLSID describing the document type.
	{ NULL }
};

PyComTypeObject PyIDebugDocumentInfo::type("PyIDebugDocumentInfo",
		&PyIUnknown::type,
		sizeof(PyIDebugDocumentInfo),
		PyIDebugDocumentInfo_methods,
		GET_PYCOM_CTOR(PyIDebugDocumentInfo));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGDebugDocumentInfo::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGDebugDocumentInfo::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGDebugDocumentInfo::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGDebugDocumentInfo::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGDebugDocumentInfo::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGDebugDocumentInfo::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGDebugDocumentInfo::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGDebugDocumentInfo::GetName(
		/* [in]  */	DOCUMENTNAMETYPE dnt,
		/* [out] */ BSTR __RPC_FAR * pbstrName)

{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetName", &result, "i", dnt);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obpbstrName;
	if (!PyArg_Parse(result, "O" , &obpbstrName)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_BstrFromPyObject(obpbstrName, pbstrName)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDebugDocumentInfo::GetDocumentClassId(
		/* [out] */ GUID __RPC_FAR * pclsidDocument)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetDocumentClassId", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obpclsidDocument;
	if (!PyArg_Parse(result, "O" , &obpclsidDocument)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_CLSIDFromPyObject(obpclsidDocument, pclsidDocument)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}
