// This file implements the IDebugDocumentContext Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIDebugDocumentContext.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugDocumentContext::PyIDebugDocumentContext(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIDebugDocumentContext::~PyIDebugDocumentContext()
{
}

/* static */ IDebugDocumentContext *PyIDebugDocumentContext::GetI(PyObject *self)
{
	return (IDebugDocumentContext *)PyIUnknown::GetI(self);
}

// @pymethod |PyIDebugDocumentContext|GetDocument|Description of GetDocument.
PyObject *PyIDebugDocumentContext::GetDocument(PyObject *self, PyObject *args)
{
	PY_INTERFACE_METHOD;
	IDebugDocumentContext *pIDDC = GetI(self);
	if ( pIDDC == NULL )
		return NULL;
	IDebugDocument *ppsd;
	if ( !PyArg_ParseTuple(args, ":GetDocument") )
		return NULL;
	PY_INTERFACE_PRECALL;
	HRESULT hr = pIDDC->GetDocument( &ppsd );
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);
	PyObject *obppsd;

	obppsd = PyCom_PyObjectFromIUnknown(ppsd, IID_IDebugDocument, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppsd);
	Py_XDECREF(obppsd);
	return pyretval;
}

// @pymethod |PyIDebugDocumentContext|EnumCodeContexts|Description of EnumCodeContexts.
PyObject *PyIDebugDocumentContext::EnumCodeContexts(PyObject *self, PyObject *args)
{
	PY_INTERFACE_METHOD;
	IDebugDocumentContext *pIDDC = GetI(self);
	if ( pIDDC == NULL )
		return NULL;
	IEnumDebugCodeContexts *ppescc;
	if ( !PyArg_ParseTuple(args, ":EnumCodeContexts") )
		return NULL;
	PY_INTERFACE_PRECALL;
	HRESULT hr = pIDDC->EnumCodeContexts( &ppescc );
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);
	PyObject *obppescc;

	obppescc = PyCom_PyObjectFromIUnknown(ppescc, IID_IEnumDebugCodeContexts, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppescc);
	Py_XDECREF(obppescc);
	return pyretval;
}

// @object PyIDebugDocumentContext|Description of the interface
static struct PyMethodDef PyIDebugDocumentContext_methods[] =
{
	{ "GetDocument", PyIDebugDocumentContext::GetDocument, 1 }, // @pymeth GetDocument|Description of GetDocument
	{ "EnumCodeContexts", PyIDebugDocumentContext::EnumCodeContexts, 1 }, // @pymeth EnumCodeContexts|Description of EnumCodeContexts
	{ NULL }
};

PyComTypeObject PyIDebugDocumentContext::type("PyIDebugDocumentContext",
		&PyIUnknown::type,
		sizeof(PyIDebugDocumentContext),
		PyIDebugDocumentContext_methods,
		GET_PYCOM_CTOR(PyIDebugDocumentContext));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGDebugDocumentContext::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGDebugDocumentContext::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGDebugDocumentContext::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGDebugDocumentContext::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGDebugDocumentContext::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGDebugDocumentContext::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGDebugDocumentContext::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGDebugDocumentContext::GetDocument(
		/* [out] */ IDebugDocument __RPC_FAR *__RPC_FAR * ppsd)
{
	PY_GATEWAY_METHOD;
	if (ppsd==NULL) return E_POINTER;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetDocument", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppsd;
	if (!PyArg_Parse(result, "O" , &obppsd)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyInstanceOrObject(obppsd, IID_IDebugDocument, (void **)ppsd, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDebugDocumentContext::EnumCodeContexts(
		/* [out] */ IEnumDebugCodeContexts __RPC_FAR *__RPC_FAR * ppescc)
{
	PY_GATEWAY_METHOD;
	if (ppescc==NULL) return E_POINTER;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("EnumCodeContexts", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppescc;
	if (!PyArg_Parse(result, "O" , &obppescc)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyInstanceOrObject(obppescc, IID_IEnumDebugCodeContexts, (void **)ppescc, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

