// axsdebug.cpp - ActiveX Scripting Debugging Extensions.:
// $Id:$

/***
Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc
***/

#include "stdafxaxs.h"
#include "PyIActiveScriptError.h"
#include "PyGActiveScriptError.h"
#include "PyIActiveScriptErrorDebug.h"

static PyObject* axsdebug_Error;     /* 'Python level' errors */


/* List of module functions */
// @module axsdebug|A module, encapsulating the ActiveX Script Debugging Interfaces.
// @comm Only interfaces "shared" between ActiveX Scripting and ActiveX Debugging are
// provided here.  See the <o axscript> and <o axdebug> modules for the stand-alone interfaces.
// Note also that axscriptmodules mus be imported before this
// module can be imported.
static struct PyMethodDef axsdebug_methods[]=
{
	{ NULL, NULL }
};

// Register a Python on both the UID and Name maps.
int RegisterType(PyObject *obMapNameToType, PyObject *obMapIIDToType, PyTypeObject *typeOb, const GUID *guid)
{
	int rc = PyDict_SetItemString(obMapNameToType, typeOb->tp_name, (PyObject *)typeOb);
	if (rc==0 && guid) {
		PyObject *obiid = PyCom_PyIIDObjectFromIID(*guid);
		if (!obiid) return 1;
		rc = PyDict_SetItem(obMapIIDToType, obiid, (PyObject *)typeOb);
		PyTS_DECREF(obiid);
	}
	return rc;
}

int AddConstant(PyObject *dict, const char *key, long value)
{
	PyObject *oval = PyInt_FromLong(value);
	if (!oval)
	{
		return 1;
	}
	int rc = PyDict_SetItemString(dict, (char*)key, oval);
	PyTS_DECREF(oval);
	return rc;
}

int AddIID(PyObject *dict, const char *key, REFGUID guid)
{
	PyObject *obiid = PyCom_PyIIDObjectFromIID(guid);
	if (!obiid) return 1;
	int rc = PyDict_SetItemString(dict, (char*)key, obiid);
	PyTS_DECREF(obiid);
	return rc;
}

#define ADD_CONSTANT(tok) AddConstant(dict, #tok, tok)
#define ADD_IID(tok) AddIID(dict, #tok, tok)

/* Module initialisation */
extern "C" __declspec(dllexport) void initaxsdebug()
{
	char *modName = "axsdebug";
	static PyObject *oModule = NULL;
	if (oModule) return;
	// Create the module and add the functions
	oModule = Py_InitModule(modName, axsdebug_methods);
	PyObject *dict = PyModule_GetDict(oModule);

	// Add some symbolic constants to the module   
	axsdebug_Error = PyString_FromString("axsdebug error");
	if (axsdebug_Error == NULL || PyDict_SetItemString(dict, "error", axsdebug_Error) != 0)
	{
		PyErr_SetString(PyExc_MemoryError, "can't define error");
		return;
	}

	// AX-Debugging ones
	if ( PyCom_RegisterClientType(&PyIActiveScriptErrorDebug::type, &IID_IActiveScriptErrorDebug) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IActiveScriptErrorDebug, GET_PYGATEWAY_CTOR(PyGActiveScriptErrorDebug), "IActiveScriptErrorDebug");
	ADD_IID(IID_IActiveScriptErrorDebug);
	
/*
	if ( PyCom_RegisterClientType(&PyI::type, &IID_I) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_I, GET_PYGATEWAY_CTOR(PyG), "");
	ADD_IID(IID_I);
*/
//	ADD_CONSTANT();
	
}
