// axcom.cpp :
// $Id:$

/***
Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc
***/

#include "stdafx.h"
#include "PyIActiveScriptDebug.h"
#include "PyIActiveScriptSiteDebug.h"
#include "PyIMachineDebugManager.h"
#include "PyIRemoteDebugApplication.h"
#include "PyIRemoteDebugApplicationEvents.h"
#include "PyIEnumRemoteDebugApplications.h"
#include "PyIDebugDocumentInfo.h"
#include "PyIDebugDocumentProvider.h"
#include "PyIDebugDocument.h"
#include "PyIDebugDocumentText.h"
#include "PyIDebugApplicationNode.h"
#include "PyIDebugApplicationNodeEvents.h"
#include "PyIProcessDebugManager.h"
#include "PyIApplicationDebugger.h"
#include "PyIDebugApplication.h"
#include "PyIDebugDocumentContext.h"
#include "PyIDebugCodeContext.h"
#include "PyIEnumDebugCodeContexts.h"
#include "PyIDebugExpressionContext.h"
#include "PyIDebugExpression.h"
#include "PyIDebugExpressionCallBack.h"
#include "PyIDebugStackFrame.h"
#include "PyIEnumDebugStackFrames.h"
#include "PyIDebugStackFrameSniffer.h"
#include "PyIDebugStackFrameSnifferEx.h"
#include "PyIRemoteDebugApplicationThread.h"
#include "PyIDebugApplicationThread.h"
#include "PyIDebugProperties.h"
#include "PyIEnumDebugApplicationNodes.h"
#include "PyIEnumRemoteDebugApplicationThreads.h"
#include "PyIDebugDocumentHelper.h"
#include "PyIDebugDocumentTextEvents.h"
#include "PyIDebugDocumentTextAuthor.h"
#include "PyIDebugDocumentTextExternalAuthor.h"
#include "PyIDebugDocumentHost.h"
#include "PyIDebugSyncOperation.h"
#include "PyIMachineDebugManagerEvents.h"
#include "PyIDebugSessionProvider.h"
#include "PyIEnumDebugExpressionContexts.h"

static PyObject* axdebug_Error;     /* 'Python level' errors */

BOOL PyAXDebug_PySOURCE_TEXT_ATTR_Length( PyObject *obAttr, ULONG *pLength )
{
	if (!PySequence_Check(obAttr))
		return FALSE;
	DWORD seqLen = (DWORD)PySequence_Length(obAttr);
	DWORD attrLen = 0;
	BOOL ok = TRUE;
	for (DWORD i=0;ok && i<seqLen;i++) {
		PyObject *ob = PySequence_GetItem(obAttr, i);
		if (!ob) {
			ok = FALSE;
			break;
		}
		if (PyInt_Check(ob)) {
			++attrLen;
		} else if (PySequence_Check(ob) && PySequence_Length(ob)==2) {
			PyObject *obRepeat = PySequence_GetItem(ob, 1);
			if (obRepeat==NULL)
				ok = FALSE;
			else {
				attrLen += PyInt_AsLong(obRepeat);
				Py_DECREF(obRepeat);
			}
		} else {
			PyErr_SetString(PyExc_TypeError, "Invalid format in SOURCE_TEXT_ATTR object");
			ok = FALSE;
		}
		Py_DECREF(ob);
	}
	if (ok) *pLength = attrLen;
	return ok;
}

BOOL PyAXDebug_PyObject_AsSOURCE_TEXT_ATTR( PyObject *obAttr, SOURCE_TEXT_ATTR *pstaTextAttr, ULONG numAttr)
{
	BOOL ok = PySequence_Check(obAttr);
	if (ok) {
		// We support 2 formats in the tuple.
		// Either: a simple integer
		// Or    : a tuple with an integer, repeatCount.
		// Either case, the total _must_ be the same as the requested size.
		DWORD seqLen = (DWORD)PySequence_Length(obAttr);
		DWORD attrLen = 0;
		for (DWORD i=0;ok && i<seqLen;i++) {
			PyObject *ob = PySequence_GetItem(obAttr, i);
			if (ob) {
				if (PyInt_Check(ob)) {
					pstaTextAttr[attrLen] = (SOURCE_TEXT_ATTR)PyInt_AsLong(ob);
					++attrLen;
				} else if (PySequence_Check(ob) && PySequence_Length(ob)==2) {
					PyObject *obAttr = PySequence_GetItem(ob, 0);
					PyObject *obRepeat = PySequence_GetItem(ob, 1);
					if (obAttr==NULL || obRepeat==NULL)
						ok = FALSE;
					else {
						SOURCE_TEXT_ATTR attr = (SOURCE_TEXT_ATTR)PyInt_AsLong(obAttr);
						DWORD len = (DWORD)PyInt_AsLong(obRepeat);
						if (attrLen+len<=numAttr) {
							while(len--)
								pstaTextAttr[attrLen++] = attr;
						}
					}
					Py_XDECREF(obAttr);
					Py_XDECREF(obRepeat);
				} else {
					PyErr_SetString( PyExc_ValueError, "Attributes must be a sequence of [attribute|(attribute, repeat)]");
					ok = FALSE;
				}
				Py_DECREF(ob);
			} else
				ok = FALSE;
		}
		if (attrLen!=numAttr) {
			PyErr_SetString(PyExc_ValueError, "The attributes must resolve to the exact length as the text");
			ok = FALSE;
		}
	}
	return ok;
}

PyObject *PyAXDebug_PyObject_FromSOURCE_TEXT_ATTR( const SOURCE_TEXT_ATTR *pstaTextAttr, ULONG numAttr)
{
	PyObject *obattr = PyTuple_New(numAttr);
	if (obattr)
		for (ULONG i=0;i<numAttr;i++) {
			PyTuple_SET_ITEM(obattr, i, PyInt_FromLong(pstaTextAttr[i]));
		}
	return obattr;
}

/* List of module functions */
// @module axdebug|A module, encapsulating the ActiveX Debugging
static struct PyMethodDef axdebug_methods[]=
{
	{ NULL, NULL }
};

// Register a Python on both the UID and Name maps.
int RegisterType(PyObject *obMapNameToType, PyObject *obMapIIDToType, PyTypeObject *typeOb, const GUID *guid)
{
	int rc = PyDict_SetItemString(obMapNameToType, typeOb->tp_name, (PyObject *)typeOb);
	if (rc==0 && guid) {
		PyObject *obiid = PyCom_PyIIDObjectFromIID(*guid);
		if (!obiid) return 1;
		rc = PyDict_SetItem(obMapIIDToType, obiid, (PyObject *)typeOb);
		PyTS_DECREF(obiid);
	}
	return rc;
}

int AddConstant(PyObject *dict, const char *key, long value)
{
	PyObject *oval = PyInt_FromLong(value);
	if (!oval)
	{
		return 1;
	}
	int rc = PyDict_SetItemString(dict, (char*)key, oval);
	PyTS_DECREF(oval);
	return rc;
}

int AddIID(PyObject *dict, const char *key, REFGUID guid)
{
	PyObject *obiid = PyCom_PyIIDObjectFromIID(guid);
	if (!obiid) return 1;
	int rc = PyDict_SetItemString(dict, (char*)key, obiid);
	PyTS_DECREF(obiid);
	return rc;
}

#define ADD_CONSTANT(tok) AddConstant(dict, #tok, tok)
#define ADD_IID(tok) AddIID(dict, #tok, tok)

/* Module initialisation */
extern "C" __declspec(dllexport) void initaxdebug()
{
	char *modName = "axdebug";
	static PyObject *oModule = NULL;
	if (oModule) return;
	// Create the module and add the functions
	oModule = Py_InitModule(modName, axdebug_methods);
	PyObject *dict = PyModule_GetDict(oModule);

	// Add some symbolic constants to the module   
	axdebug_Error = PyString_FromString("error");
	if (axdebug_Error == NULL || PyDict_SetItemString(dict, "error", axdebug_Error) != 0)
	{
		PyErr_SetString(PyExc_MemoryError, "can't define error");
		return;
	}

	// AX-Debugging ones
	if ( PyCom_RegisterClientType(&PyIActiveScriptDebug::type, &IID_IActiveScriptDebug) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IActiveScriptDebug, GET_PYGATEWAY_CTOR(PyGActiveScriptDebug), "IActiveScriptDebug");
	ADD_IID(IID_IActiveScriptDebug);

	if ( PyCom_RegisterClientType(&PyIActiveScriptSiteDebug::type, &IID_IActiveScriptSiteDebug) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IActiveScriptSiteDebug, GET_PYGATEWAY_CTOR(PyGActiveScriptSiteDebug), "IActiveScriptSiteDebug");
	ADD_IID(IID_IActiveScriptSiteDebug);

	if ( PyCom_RegisterClientType(&PyIMachineDebugManager::type, &IID_IMachineDebugManager) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IMachineDebugManager, GET_PYGATEWAY_CTOR(PyGMachineDebugManager), "IMachineDebugManager");
	ADD_IID(IID_IMachineDebugManager);

	if ( PyCom_RegisterClientType(&PyIRemoteDebugApplication::type, &IID_IRemoteDebugApplication) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IRemoteDebugApplication, GET_PYGATEWAY_CTOR(PyGRemoteDebugApplication), "IRemoteDebugApplication");
	ADD_IID(IID_IRemoteDebugApplication);

	if ( PyCom_RegisterClientType(&PyIRemoteDebugApplicationEvents::type, &IID_IRemoteDebugApplicationEvents) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IRemoteDebugApplicationEvents, GET_PYGATEWAY_CTOR(PyGRemoteDebugApplicationEvents), "IRemoteDebugApplicationEvents");
	ADD_IID(IID_IRemoteDebugApplicationEvents);

	if ( PyCom_RegisterClientType(&PyIEnumRemoteDebugApplications::type, &IID_IEnumRemoteDebugApplications) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IEnumRemoteDebugApplications, GET_PYGATEWAY_CTOR(PyGEnumRemoteDebugApplications), "IEnumRemoteDebugApplications");
	ADD_IID(IID_IEnumRemoteDebugApplications);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentInfo::type, &IID_IDebugDocumentInfo) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentInfo, GET_PYGATEWAY_CTOR(PyGDebugDocumentInfo), "IDebugDocumentInfo");
	ADD_IID(IID_IDebugDocumentInfo);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentProvider::type, &IID_IDebugDocumentProvider) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentProvider, GET_PYGATEWAY_CTOR(PyGDebugDocumentProvider), "IDebugDocumentProvider");
	ADD_IID(IID_IDebugDocumentProvider);

	if ( PyCom_RegisterClientType(&PyIDebugApplicationNode::type, &IID_IDebugApplicationNode) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugApplicationNode, GET_PYGATEWAY_CTOR(PyGDebugApplicationNode), "IDebugApplicationNode");
	ADD_IID(IID_IDebugApplicationNode);

	if ( PyCom_RegisterClientType(&PyIDebugApplicationNodeEvents::type, &IID_IDebugApplicationNodeEvents) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugApplicationNodeEvents, GET_PYGATEWAY_CTOR(PyGDebugApplicationNodeEvents), "IDebugApplicationNodeEvents");
	ADD_IID(IID_IDebugApplicationNodeEvents);

	if ( PyCom_RegisterClientType(&PyIDebugDocument::type, &IID_IDebugDocument) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocument, GET_PYGATEWAY_CTOR(PyGDebugDocument), "IDebugDocument");
	ADD_IID(IID_IDebugDocument);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentText::type, &IID_IDebugDocumentText) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentText, GET_PYGATEWAY_CTOR(PyGDebugDocumentText), "IDebugDocumentText");
	ADD_IID(IID_IDebugDocumentText);

	if ( PyCom_RegisterClientType(&PyIProcessDebugManager::type, &IID_IProcessDebugManager) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IProcessDebugManager, GET_PYGATEWAY_CTOR(PyGProcessDebugManager), "IProcessDebugManager");
	ADD_IID(IID_IProcessDebugManager);

	if ( PyCom_RegisterClientType(&PyIApplicationDebugger::type, &IID_IApplicationDebugger) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IApplicationDebugger, GET_PYGATEWAY_CTOR(PyGApplicationDebugger), "IApplicationDebugger");
	ADD_IID(IID_IApplicationDebugger);

	if ( PyCom_RegisterClientType(&PyIDebugApplication::type, &IID_IDebugApplication) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugApplication, GET_PYGATEWAY_CTOR(PyGDebugApplication), "IDebugApplication");
	ADD_IID(IID_IDebugApplication);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentContext::type, &IID_IDebugDocumentContext) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentContext, GET_PYGATEWAY_CTOR(PyGDebugDocumentContext), "IDebugDocumentContext");
	ADD_IID(IID_IDebugDocumentContext);

	if ( PyCom_RegisterClientType(&PyIDebugCodeContext::type, &IID_IDebugCodeContext) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugCodeContext, GET_PYGATEWAY_CTOR(PyGDebugCodeContext), "IDebugCodeContext");
	ADD_IID(IID_IDebugCodeContext);

	if ( PyCom_RegisterClientType(&PyIEnumDebugCodeContexts::type, &IID_IEnumDebugCodeContexts) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IEnumDebugCodeContexts, GET_PYGATEWAY_CTOR(PyGEnumDebugCodeContexts), "IEnumDebugCodeContexts");
	ADD_IID(IID_IEnumDebugCodeContexts);

	if ( PyCom_RegisterClientType(&PyIDebugStackFrame::type, &IID_IDebugStackFrame) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugStackFrame, GET_PYGATEWAY_CTOR(PyGDebugStackFrame), "IDebugStackFrame");
	ADD_IID(IID_IDebugStackFrame);

	if ( PyCom_RegisterClientType(&PyIEnumDebugStackFrames::type, &IID_IEnumDebugStackFrames) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IEnumDebugStackFrames, GET_PYGATEWAY_CTOR(PyGEnumDebugStackFrames), "IEnumDebugStackFrames");
	ADD_IID(IID_IEnumDebugStackFrames);
	
	if ( PyCom_RegisterClientType(&PyIDebugExpressionContext::type, &IID_IDebugExpressionContext) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugExpressionContext, GET_PYGATEWAY_CTOR(PyGDebugExpressionContext), "IDebugExpressionContext");
	ADD_IID(IID_IDebugExpressionContext);

	if ( PyCom_RegisterClientType(&PyIDebugExpression::type, &IID_IDebugExpression) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugExpression, GET_PYGATEWAY_CTOR(PyGDebugExpression), "IDebugExpression");
	ADD_IID(IID_IDebugExpression);

	if ( PyCom_RegisterClientType(&PyIDebugExpressionCallBack::type, &IID_IDebugExpressionCallBack) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugExpressionCallBack, GET_PYGATEWAY_CTOR(PyGDebugExpressionCallBack), "IDebugExpressionCallBack");
	ADD_IID(IID_IDebugExpressionCallBack);

	if ( PyCom_RegisterClientType(&PyIDebugStackFrameSniffer::type, &IID_IDebugStackFrameSniffer) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugStackFrameSniffer, GET_PYGATEWAY_CTOR(PyGDebugStackFrameSniffer), "IDebugStackFrameSniffer");
	ADD_IID(IID_IDebugStackFrameSniffer);

	if ( PyCom_RegisterClientType(&PyIDebugStackFrameSnifferEx::type, &IID_IDebugStackFrameSnifferEx) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugStackFrameSnifferEx, GET_PYGATEWAY_CTOR(PyGDebugStackFrameSnifferEx), "IDebugStackFrameSnifferEx");
	ADD_IID(IID_IDebugStackFrameSnifferEx);

	if ( PyCom_RegisterClientType(&PyIRemoteDebugApplicationThread::type, &IID_IRemoteDebugApplicationThread) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IRemoteDebugApplicationThread, GET_PYGATEWAY_CTOR(PyGRemoteDebugApplicationThread), "IRemoteDebugApplicationThread");
	ADD_IID(IID_IRemoteDebugApplicationThread);

	if ( PyCom_RegisterClientType(&PyIDebugApplicationThread::type, &IID_IDebugApplicationThread) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugApplicationThread, GET_PYGATEWAY_CTOR(PyGDebugApplicationThread), "IDebugApplicationThread");
	ADD_IID(IID_IDebugApplicationThread);

	if ( PyCom_RegisterClientType(&PyIDebugProperty::type, &IID_IDebugProperty) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugProperty, GET_PYGATEWAY_CTOR(PyGDebugProperty), "IDebugProperty");
	ADD_IID(IID_IDebugProperty);

	if ( PyCom_RegisterClientType(&PyIEnumDebugApplicationNodes::type, &IID_IEnumDebugApplicationNodes) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IEnumDebugApplicationNodes, GET_PYGATEWAY_CTOR(PyGEnumDebugApplicationNodes), "IEnumDebugApplicationNodes");
	ADD_IID(IID_IEnumDebugApplicationNodes);

	if ( PyCom_RegisterClientType(&PyIEnumRemoteDebugApplicationThreads::type, &IID_IEnumRemoteDebugApplicationThreads) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IEnumRemoteDebugApplicationThreads, GET_PYGATEWAY_CTOR(PyGEnumRemoteDebugApplicationThreads), "IEnumRemoteDebugApplicationThreads");
	ADD_IID(IID_IEnumRemoteDebugApplicationThreads);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentHelper::type, &IID_IDebugDocumentHelper) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentHelper, GET_PYGATEWAY_CTOR(PyGDebugDocumentHelper), "IDebugDocumentHelper");
	ADD_IID(IID_IDebugDocumentHelper);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentTextEvents::type, &IID_IDebugDocumentTextEvents) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentTextEvents, GET_PYGATEWAY_CTOR(PyGDebugDocumentTextEvents), "IDebugDocumentTextEvents");
	ADD_IID(IID_IDebugDocumentTextEvents);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentTextAuthor::type, &IID_IDebugDocumentTextAuthor) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentTextAuthor, GET_PYGATEWAY_CTOR(PyGDebugDocumentTextAuthor), "IDebugDocumentTextAuthor");
	ADD_IID(IID_IDebugDocumentTextAuthor);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentTextExternalAuthor::type, &IID_IDebugDocumentTextExternalAuthor) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentTextExternalAuthor, GET_PYGATEWAY_CTOR(PyGDebugDocumentTextExternalAuthor), "IDebugDocumentTextExternalAuthor");
	ADD_IID(IID_IDebugDocumentTextExternalAuthor);

	if ( PyCom_RegisterClientType(&PyIDebugDocumentHost::type, &IID_IDebugDocumentHost) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugDocumentHost, GET_PYGATEWAY_CTOR(PyGDebugDocumentHost), "IDebugDocumentHost");
	ADD_IID(IID_IDebugDocumentHost);

/**	if ( PyCom_RegisterClientType(&PyIActiveScriptTextInfo::type, &IID_IActiveScriptTextInfo) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IActiveScriptTextInfo, GET_PYGATEWAY_CTOR(PyGActiveScriptTextInfo), "IActiveScriptTextInfo");
	ADD_IID(IID_IActiveScriptTextInfo);
***/	
	if ( PyCom_RegisterClientType(&PyIDebugSyncOperation::type, &IID_IDebugSyncOperation) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugSyncOperation, GET_PYGATEWAY_CTOR(PyGDebugSyncOperation), "IDebugSyncOperation");
	ADD_IID(IID_IDebugSyncOperation);
	
	if ( PyCom_RegisterClientType(&PyIMachineDebugManagerEvents::type, &IID_IMachineDebugManagerEvents) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IMachineDebugManagerEvents, GET_PYGATEWAY_CTOR(PyGMachineDebugManagerEvents), "IMachineDebugManagerEvents");
	ADD_IID(IID_IMachineDebugManagerEvents);

	if ( PyCom_RegisterClientType(&PyIDebugSessionProvider::type, &IID_IDebugSessionProvider) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IDebugSessionProvider, GET_PYGATEWAY_CTOR(PyGDebugSessionProvider), "IDebugSessionProvider");
	ADD_IID(IID_IDebugSessionProvider);

	if ( PyCom_RegisterClientType(&PyIEnumDebugExpressionContexts::type, &IID_IEnumDebugExpressionContexts) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_IEnumDebugExpressionContexts, GET_PYGATEWAY_CTOR(PyGEnumDebugExpressionContexts), "IEnumDebugExpressionContexts");
	ADD_IID(IID_IEnumDebugExpressionContexts);

/*
	if ( PyCom_RegisterClientType(&PyI::type, &IID_I) != 0 ) return;
	PyCom_RegisterGatewayObject(IID_I, GET_PYGATEWAY_CTOR(PyG), "I");
	ADD_IID(IID_I);
*/
	ADD_IID(CLSID_MachineDebugManager);	// @const axdebug|CLSID_MachineDebugManager|An IID object
	ADD_IID(CLSID_ProcessDebugManager); // @const axdebug|CLSID_ProcessDebugManager|An IID object
	ADD_IID(CLSID_DefaultDebugSessionProvider); // @const axdebug|CLSID_DefaultDebugSessionProvider|An IID object

	ADD_CONSTANT(APPBREAKFLAG_DEBUGGER_BLOCK); // @const axdebug|APPBREAKFLAG_DEBUGGER_BLOCK|Languages should break immediately with BREAKREASON_DEBUGGER_BLOCK 
	ADD_CONSTANT(APPBREAKFLAG_DEBUGGER_HALT); // @const axdebug|APPBREAKFLAG_DEBUGGER_HALT|Languages should break immediately with BREAKREASON_DEBUGGER_HALT
	ADD_CONSTANT(APPBREAKFLAG_STEP); // @const axdebug|APPBREAKFLAG_STEP|
	ADD_CONSTANT(APPBREAKFLAGS	APPBREAKFLAG_NESTED);
	ADD_CONSTANT(APPBREAKFLAG_STEPTYPE_SOURCE);
	ADD_CONSTANT(APPBREAKFLAG_STEPTYPE_BYTECODE);
	ADD_CONSTANT(APPBREAKFLAG_STEPTYPE_MACHINE);
	ADD_CONSTANT(APPBREAKFLAG_STEPTYPE_MASK);
	ADD_CONSTANT(APPBREAKFLAG_IN_BREAKPOINT);

	ADD_CONSTANT(BREAKPOINT_DELETED);	// @const axdebug|BREAKPOINT_DELETED|
	ADD_CONSTANT(BREAKPOINT_DISABLED);	// @const axdebug|BREAKPOINT_DISABLED|
	ADD_CONSTANT(BREAKPOINT_ENABLED);	// @const axdebug|BREAKPOINT_ENABLED|

	ADD_CONSTANT(BREAKREASON_STEP);	// @const axdebug|BREAKREASON_STEP|Caused by the stepping mode
	ADD_CONSTANT(BREAKREASON_BREAKPOINT);	// @const axdebug|BREAKREASON_BREAKPOINT|Caused by an explicit breakpoint
	ADD_CONSTANT(BREAKREASON_DEBUGGER_BLOCK);	// @const axdebug|BREAKREASON_DEBUGGER_BLOCK|Caused by another thread breaking
	ADD_CONSTANT(BREAKREASON_HOST_INITIATED);	// @const axdebug|BREAKREASON_HOST_INITIATED|Caused by host requested break
	ADD_CONSTANT(BREAKREASON_LANGUAGE_INITIATED); // @const axdebug|BREAKREASON_LANGUAGE_INITIATED|Caused by a scripted break
	ADD_CONSTANT(BREAKREASON_DEBUGGER_HALT);		// @const axdebug|BREAKREASON_DEBUGGER_HALT|Caused by debugger IDE requested break
	ADD_CONSTANT(BREAKREASON_ERROR);				// @const axdebug|BREAKREASON_ERROR|Caused by an execution error

	ADD_CONSTANT(BREAKRESUMEACTION_ABORT);		// @const axdebug|BREAKRESUMEACTION_ABORT|Abort the application
	ADD_CONSTANT(BREAKRESUMEACTION_CONTINUE);		// @const axdebug|BREAKRESUMEACTION_CONTINUE|Continue running
	ADD_CONSTANT(BREAKRESUMEACTION_STEP_INTO);	// @const axdebug|BREAKRESUMEACTION_STEP_INTO|Step into a procedure
	ADD_CONSTANT(BREAKRESUMEACTION_STEP_OVER);	// @const axdebug|BREAKRESUMEACTION_STEP_OVER|Step over a procedure
	ADD_CONSTANT(BREAKRESUMEACTION_STEP_OUT);		// @const axdebug|BREAKRESUMEACTION_STEP_OUT|Step out of the current procedure

	ADD_CONSTANT(DEBUG_TEXT_ISEXPRESSION);  // @const axdebug|DEBUG_TEXT_ISEXPRESSION|Indicates that the text is an expression as opposed to a statement. This flag may affect the way in which the text is parsed by some languages.
	ADD_CONSTANT(DEBUG_TEXT_ALLOWBREAKPOINTS); // @const axdebug|DEBUG_TEXT_ALLOWBREAKPOINTS|Allow breakpoints during the evaluation of the text. If this flag is not set then breakpoints will be ignored during the evaluation of the text.

	ADD_CONSTANT(DOCUMENTNAMETYPE_APPNODE);	// @const axdebug|DOCUMENTNAMETYPE_APPNODE|Gets the name as it appears in the app tree  
	ADD_CONSTANT(DOCUMENTNAMETYPE_TITLE);	// @const axdebug|DOCUMENTNAMETYPE_TITLE|Gets the name as it appears on the doc viewer title bar  
	ADD_CONSTANT(DOCUMENTNAMETYPE_FILE_TAIL);	// @const axdebug|DOCUMENTNAMETYPE_FILE_TAIL|Gets the filename without a path (for save as...)  
	ADD_CONSTANT(DOCUMENTNAMETYPE_URL);		// @const axdebug|DOCUMENTNAMETYPE_URL|Gets the URL of the document, if any  

    ADD_CONSTANT(DBGPROP_ATTRIB_NO_ATTRIB); // @const axdebug|DBGPROP_ATTRIB_NO_ATTRIB|
	ADD_CONSTANT(DBGPROP_ATTRIB_VALUE_IS_INVALID); // @const axdebug|DBGPROP_ATTRIB_VALUE_IS_INVALID|
	ADD_CONSTANT(DBGPROP_ATTRIB_VALUE_IS_EXPANDABLE); // @const axdebug|DBGPROP_ATTRIB_VALUE_IS_EXPANDABLE|
	ADD_CONSTANT(DBGPROP_ATTRIB_VALUE_READONLY); // @const axdebug|DBGPROP_ATTRIB_VALUE_READONLY|
	ADD_CONSTANT(DBGPROP_ATTRIB_ACCESS_PUBLIC); // @const axdebug|DBGPROP_ATTRIB_ACCESS_PUBLIC|
	ADD_CONSTANT(DBGPROP_ATTRIB_ACCESS_PRIVATE); // @const axdebug|DBGPROP_ATTRIB_ACCESS_PRIVATE|
	ADD_CONSTANT(DBGPROP_ATTRIB_ACCESS_PROTECTED); // @const axdebug|DBGPROP_ATTRIB_ACCESS_PROTECTED|
	ADD_CONSTANT(DBGPROP_ATTRIB_ACCESS_FINAL); // @const axdebug|DBGPROP_ATTRIB_ACCESS_FINAL|
	ADD_CONSTANT(DBGPROP_ATTRIB_STORAGE_GLOBAL); // @const axdebug|DBGPROP_ATTRIB_STORAGE_GLOBAL|
	ADD_CONSTANT(DBGPROP_ATTRIB_STORAGE_STATIC); // @const axdebug|DBGPROP_ATTRIB_STORAGE_STATIC|
	ADD_CONSTANT(DBGPROP_ATTRIB_STORAGE_FIELD); // @const axdebug|DBGPROP_ATTRIB_STORAGE_FIELD|
	ADD_CONSTANT(DBGPROP_ATTRIB_STORAGE_VIRTUAL); // @const axdebug|DBGPROP_ATTRIB_STORAGE_VIRTUAL|
	ADD_CONSTANT(DBGPROP_ATTRIB_TYPE_IS_CONSTANT); // @const axdebug|DBGPROP_ATTRIB_TYPE_IS_CONSTANT|
	ADD_CONSTANT(DBGPROP_ATTRIB_TYPE_IS_SYNCHRONIZED); // @const axdebug|DBGPROP_ATTRIB_TYPE_IS_SYNCHRONIZED|
	ADD_CONSTANT(DBGPROP_ATTRIB_TYPE_IS_VOLATILE); // @const axdebug|DBGPROP_ATTRIB_TYPE_IS_VOLATILE|
	ADD_CONSTANT(DBGPROP_ATTRIB_HAS_EXTENDED_ATTRIBS); // @const axdebug|DBGPROP_ATTRIB_HAS_EXTENDED_ATTRIBS|

	ADD_CONSTANT(ERRORRESUMEACTION_ReexecuteErrorStatement); // @const axdebug|ERRORRESUMEACTION_ReexecuteErrorStatement|
	ADD_CONSTANT(ERRORRESUMEACTION_AbortCallAndReturnErrorToCaller); // @const axdebug|ERRORRESUMEACTION_AbortCallAndReturnErrorToCaller|
	ADD_CONSTANT(ERRORRESUMEACTION_SkipErrorStatement); // @const axdebug|ERRORRESUMEACTION_SkipErrorStatement|

	ADD_CONSTANT(EX_DBGPROP_INFO_ID); // @const axdebug|EX_DBGPROP_INFO_ID|
	ADD_CONSTANT(EX_DBGPROP_INFO_NTYPE); // @const axdebug|EX_DBGPROP_INFO_NTYPE|
	ADD_CONSTANT(EX_DBGPROP_INFO_NVALUE); // @const axdebug|EX_DBGPROP_INFO_NVALUE|
	ADD_CONSTANT(EX_DBGPROP_INFO_LOCKBYTES); // @const axdebug|EX_DBGPROP_INFO_LOCKBYTES|
	ADD_CONSTANT(EX_DBGPROP_INFO_DEBUGEXTPROP); // @const axdebug|EX_DBGPROP_INFO_DEBUGEXTPROP|

	ADD_CONSTANT(SOURCETEXT_ATTR_KEYWORD);	// @const axdebug|SOURCETEXT_ATTR_KEYWORD|
	ADD_CONSTANT(SOURCETEXT_ATTR_COMMENT);	// @const axdebug|SOURCETEXT_ATTR_COMMENT|
	ADD_CONSTANT(SOURCETEXT_ATTR_NONSOURCE);	// @const axdebug|SOURCETEXT_ATTR_NONSOURCE|
	ADD_CONSTANT(SOURCETEXT_ATTR_OPERATOR);	// @const axdebug|SOURCETEXT_ATTR_OPERATOR|
	ADD_CONSTANT(SOURCETEXT_ATTR_NUMBER);	// @const axdebug|SOURCETEXT_ATTR_NUMBER|
	ADD_CONSTANT(SOURCETEXT_ATTR_STRING);	// @const axdebug|SOURCETEXT_ATTR_STRING|
	ADD_CONSTANT(SOURCETEXT_ATTR_FUNCTION_START);	// @const axdebug|SOURCETEXT_ATTR_FUNCTION_START|

	ADD_CONSTANT(TEXT_DOC_ATTR_READONLY); // @const axdebug|TEXT_DOC_ATTR_READONLY|Indicates that the document is read-only.


//	ADD_CONSTANT();
	
}
