# Classes which describe interfaces.

from win32com.server.exception import Exception
from win32com.server.util import ListEnumeratorGateway
from win32com.axdebug import axdebug
from win32com import pythoncom
import win32com.server.connect
import winerror
import string

class EnumDebugCodeContexts(ListEnumeratorGateway):
	"""A class to expose a Python sequence as an EnumDebugCodeContexts

	Create an instance of this class passing a sequence (list, tuple, or
	any sequence protocol supporting object) and it will automatically
	support the EnumDebugCodeContexts interface for the object.

	"""
	_com_interfaces_ = [ axdebug.IID_IEnumDebugCodeContexts ]

class EnumDebugStackFrames(ListEnumeratorGateway):
	"""A class to expose a Python sequence as an EnumDebugStackFrames

	Create an instance of this class passing a sequence (list, tuple, or
	any sequence protocol supporting object) and it will automatically
	support the EnumDebugStackFrames interface for the object.

	"""
	_com_interfaces_ = [ axdebug.IID_IEnumDebugStackFrames ]

class EnumDebugApplicationNodes(ListEnumeratorGateway):
	"""A class to expose a Python sequence as an EnumDebugStackFrames

	Create an instance of this class passing a sequence (list, tuple, or
	any sequence protocol supporting object) and it will automatically
	support the EnumDebugApplicationNodes interface for the object.

	"""
	_com_interfaces_ = [ axdebug.IID_IEnumDebugApplicationNodes ]

class EnumRemoteDebugApplications(ListEnumeratorGateway):
	_com_interfaces_ = [ axdebug.IID_IEnumRemoteDebugApplications ]

class EnumRemoteDebugApplicationThreads(ListEnumeratorGateway):
	_com_interfaces_ = [ axdebug.IID_IEnumRemoteDebugApplicationThreads ]

class DebugDocumentInfo:
	_public_methods_ = ["GetName", "GetDocumentClassId"]
	_com_interfaces_ = [axdebug.IID_IDebugDocumentInfo]
	def __init__(self):
		pass
	def GetName(self, dnt):
		""" Get the one of the name of the document
		    dnt -- int DOCUMENTNAMETYPE
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetDocumentClassId(self):
		"""
		    Result must be an IID object (or string representing one).
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
		
class DebugDocumentProvider(DebugDocumentInfo):
	_public_methods_ = DebugDocumentInfo._public_methods_ + ["GetDocument"]
	_com_interfaces_ = DebugDocumentInfo._com_interfaces_ + [axdebug.IID_IDebugDocumentProvider]
	def GetDocument(self):
		raise Exception(scode=winerror.E_NOTIMPL)

class DebugApplicationNode(DebugDocumentProvider):
	"""Provides the functionality of IDebugDocumentProvider, plus a context within a project tree.
	"""
	_public_methods_ = string.split("""EnumChildren GetParent SetDocumentProvider 
			Close Attach Detach""") + \
		DebugDocumentProvider._public_methods_
	_com_interfaces_ = [axdebug.IID_IDebugDocumentProvider] + \
		DebugDocumentProvider._com_interfaces_
	def __init__(self):
		DebugDocumentProvider.__init__(self)
 	def EnumChildren(self):
		# Result is type PyIEnumDebugApplicationNodes
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetParent(self):
		# result is type PyIDebugApplicationNode
		raise Exception(scode=winerror.E_NOTIMPL)
	def SetDocumentProvider(self, pddp): # PyIDebugDocumentProvider pddp
		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)
	def Close(self):
		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)
	def Attach(self, parent): # PyIDebugApplicationNode
     		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)
	def Detach(self):
		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)

class DebugApplicationNodeEvents:
	"""Event interface for DebugApplicationNode object.
	"""
	_public_methods_ = string.split("onAddChild onRemoveChild onDetach")
	_com_interfaces_ = [axdebug.IID_IDebugApplicationNodeEvents]
	def __init__(self):
		pass
	def onAddChild(self, child): # PyIDebugApplicationNode
     		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onRemoveChild(self, child): # PyIDebugApplicationNode
		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onDetach(self):
		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onAttach(self, parent): # PyIDebugApplicationNode
		# void result.
		raise Exception(scode=winerror.E_NOTIMPL)

class DebugDocument(DebugDocumentInfo):
	"""The base interface to all debug documents.  
	"""
	_public_methods_ = DebugDocumentInfo._public_methods_
	_com_interfaces_ = [axdebug.IID_IDebugDocument] + DebugDocumentInfo._com_interfaces_

class DebugDocumentText(DebugDocument):
	"""The interface to a text only debug document.
	"""
	_com_interfaces_ = [axdebug.IID_IDebugDocumentText] + \
		             DebugDocument._com_interfaces_
	_public_methods_ = ["GetDocumentAttributes", "GetSize",
	                    "GetPositionOfLine", "GetLineOfPosition", "GetText",
	                    "GetPositionOfContext", "GetContextOfPosition"] + \
		             DebugDocument._public_methods_ 
	def __init__(self):
		pass
	# IDebugDocumentText
	def GetDocumentAttributes(self):
		# Result is int (TEXT_DOC_ATTR)
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetSize(self):
		# Result is (numLines, numChars)
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetPositionOfLine(self, cLineNumber):
		# Result is int char position
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetLineOfPosition(self, charPos):
		# Result is int, int (lineNo, offset)
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetText(self, charPos, maxChars, wantAttr):
		"""Params
		charPos -- integer
		maxChars -- integer
		wantAttr -- Should the function compute attributes.

		Return value must be (string, attribtues).  attributes may be
		None if(not wantAttr)
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetPositionOfContext(self, debugDocumentContext):
		"""Params
		debugDocumentContext -- a PyIDebugDocumentContext object.
	
		Return value must be (charPos, numChars)
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetContextOfPosition(self, charPos, maxChars):
		"""Params are integers.
		Return value must be PyIDebugDocumentContext object
		"""
		raise Exception(scode=winerror.E_NOTIMPL)

class DebugDocumentTextExternalAuthor:
	"""Allow external editors to edit file-based debugger documents, and to notify the document when the source file has been changed.
	"""
	_public_methods_ = ["GetPathName", "GetFileName", "NotifyChanged"]
	_com_interfaces_ = [axdebug.IID_IDebugDocumentTextExternalAuthor]
	def __init__(self):
		pass
	def GetPathName(self):
		"""Return the full path (including file name) to the document's source file.
		
		Result must be (filename, fIsOriginal), where
		- if fIsOriginalPath is TRUE if the path refers to the original file for the document.
		- if fIsOriginalPath is FALSE if the path refers to a newly created temporary file.

		raise Exception(winerror.E_FAIL) if no source file can be created/determined.  
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def GetFileName(self):
		"""Return just the name of the document, with no path information.  (Used for "Save As...")

		Result is a string
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def NotifyChanged(self):
		""" Notify the host that the document's source file has been saved and  
		that its contents should be refreshed.
		"""
		raise Exception(scode=winerror.E_NOTIMPL)


class DebugDocumentTextEvents:
	_public_methods_ = string.split("""onDestroy onInsertText onRemoveText 
	          onReplaceText onUpdateTextAttributes onUpdateDocumentAttributes""")
	_com_interfaces_ = [ axdebug.IID_IDebugDocumentTextEvents ]
	def __init__(self):
		pass
	def onDestroy(self):
		# Result is void.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onInsertText(self, cCharacterPosition, cNumToInsert):
		# Result is void.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onRemoveText(self, cCharacterPosition, cNumToRemove):
		# Result is void.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onReplaceText(self, cCharacterPosition, cNumToReplace):
		# Result is void.
		raise Exception(scode=winerror.E_NOTIMPL)
	def onUpdateTextAttributes(self, cCharacterPosition, cNumToUpdate):
		# Result is void.
		raise Exception(scode=winerror.E_NOTIMPL)
  	def onUpdateDocumentAttributes(self,textdocattr): # TEXT_DOC_ATTR
		# Result is void.
		raise Exception(scode=winerror.E_NOTIMPL)

class DebugDocumentContext:
	_public_methods_ = [ 'GetDocument', 'EnumCodeContexts']
	_com_interfaces_ = [ axdebug.IID_IDebugDocumentContext ]
	def __init__(self):
		pass
	def GetDocument(self):
		"""Return value must be a PyIDebugDocument object
		"""
		raise Exception(scode=winerror.E_NOTIMPL)

	def EnumCodeContexts(self):
		"""Return value must be a PyIEnumDebugCodeContexts object
		"""
		raise Exception(scode=winerror.E_NOTIMPL)


class DebugCodeContext:
	_public_methods_ = [ 'GetDocumentContext', 'SetBreakPoint']
	_com_interfaces_ = [ axdebug.IID_IDebugCodeContext ]
	def __init__(self):
		pass
	def GetDocumentContext(self):
		"""Return value must be a PyIDebugDocumentContext object
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def SetBreakPoint(self, bps):
		"""bps -- an integer with flags.
		"""
		raise Exception(scode=winerror.E_NOTIMPL)


class DebugStackFrame:
	"""Abstraction representing a logical stack frame on the stack of a thread."""
	_public_methods_ = [ 'GetCodeContext', 'GetDescriptionString', 'GetLanguageString', 'GetThread']
	_com_interfaces_ = [ axdebug.IID_IDebugStackFrame ]
	def __init__(self):
		pass
	def GetCodeContext(self):
		"""Returns the current code context associated with the stack frame.

		Return value must be a IDebugCodeContext object
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetDescriptionString(self, fLong):
		"""Returns a textual description of the stack frame.
		
		fLong -- A flag indicating if the long name is requested.
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetLanguageString(self):
		"""Returns a short or long textual description of the language.
		
		fLong -- A flag indicating if the long name is requested.
		"""
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetThread(self):
		""" Returns the thread associated with this stack frame.

		Result must be a IDebugApplicationThread
		"""
		raise Exception(scode=winerror.E_NOTIMPL)


class DebugDocumentHost:
	"""The interface from the IDebugDocumentHelper back to  
	the smart host or language engine.  This interface  
	exposes host specific functionality such as syntax coloring.
	"""
	_public_methods_ = [ 'GetDeferredText', 'GetScriptTextAttributes', 'OnCreateDocumentContext', 'GetPathName', 'GetFileName', 'NotifyChanged']
	_com_interfaces_ = [ axdebug.IID_IDebugDocumentHost ]
	def __init__(self):
		pass
	def GetDeferredText(self, dwTextStartCookie,  maxChars, bWantAttr):
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def GetScriptTextAttributes(self, codeText, delimterText, flags):
		# Result must be an attribute sequence of same "length" as the code.	
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def OnCreateDocumentContext(self): 
		# Result must be a PyIUnknown
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def GetPathName(self):
		# Result must be (string, int) where the int is a BOOL
		# - TRUE if the path refers to the original file for the document.
		# - FALSE if the path refers to a newly created temporary file.
		# - raise Exception(scode=E_FAIL) if no source file can be created/determined.  
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def GetFileName(self):
		# Result is a string with just the name of the document, no path information.  
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def NotifyChanged(self):
		raise Exception(scode=winerror.E_NOTIMPL)

# Additional gateway related functions.

class DebugDocumentTextConnectServer:
	_public_methods_ = win32com.server.connect.IConnectionPointContainer_methods + win32com.server.connect.IConnectionPoint_methods
	_com_interfaces_ = [win32com.pythoncom.IID_IConnectionPoint, win32com.pythoncom.IID_IConnectionPointContainer]
	# IConnectionPoint interfaces
	def __init__(self):
		self.cookieNo = -1
		self.connections = {}
	def EnumConnections(self):
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetConnectionInterface(self):
		raise Exception(scode=winerror.E_NOTIMPL)
	def GetConnectionPointContainer(self):
		return __.__.server.util.wrap(self)
	def Advise(self, pUnk):
		# Creates a connection to the client.  Simply allocate a new cookie,
		# find the clients interface, and store it in a dictionary.
		interface = pUnk.QueryInterface(axdebug.IID_IDebugDocumentTextEvents,1)
		self.cookieNo = self.cookieNo + 1
		self.connections[self.cookieNo] = interface
		return self.cookieNo
	def Unadvise(self, cookie):
		# Destroy a connection - simply delete interface from the map.
		try:
			del self.connections[cookie]
		except KeyError:
			return Exception(scode=winerror.E_UNEXPECTED)
	# IConnectionPointContainer interfaces
	def EnumConnectionPoints(self):
		raise Exception(scode=winerror.E_NOTIMPL)
	def FindConnectionPoint(self, iid):
		# Find a connection we support.  Only support the single event interface.
		if iid==axdebug.IID_IDebugDocumentTextEvents:
			return __.__.server.util.wrap(self)
		raise Exception(scode=winerror.E_NOINTERFACE) # ??

class RemoteDebugApplicationEvents:
	_public_methods_ = ["OnConnectDebugger","OnDisconnectDebugger","OnSetName","OnDebugOutput","OnClose","OnEnterBreakPoint","OnLeaveBreakPoint","OnCreateThread","OnDestroyThread","OnBreakFlagChange"]
	_com_interfaces_ = [axdebug.IID_IRemoteDebugApplicationEvents]
	def OnConnectDebugger(self, appDebugger):
		"""appDebugger -- a PyIApplicationDebugger
		"""
		pass
	def OnDisconnectDebugger(self):
		pass
	def OnSetName(self, name):
		pass
	def OnDebugOutput(self, string):
		pass
	def OnClose(self):
		pass
	def OnEnterBreakPoint(self, rdat):
		"""rdat -- PyIRemoteDebugApplicationThread
		"""
	def OnLeaveBreakPoint(self, rdat):
		"""rdat -- PyIRemoteDebugApplicationThread
		"""
	def OnCreateThread(self, rdat):
		"""rdat -- PyIRemoteDebugApplicationThread
		"""
	def OnDestroyThread(self, rdat):
		"""rdat -- PyIRemoteDebugApplicationThread
		"""
	def OnBreakFlagChange(self, abf, rdat):
		"""abf -- int - one of the axdebug.APPBREAKFLAGS constants
		rdat -- PyIRemoteDebugApplicationThread
		"""

