""" A module for managing the AXDebug I*Contexts

"""
import gateways, axdebug
import win32com.server.util

# Utility function for wrapping object created by this module.
from util import _wrap, _wrap_remove

class DebugDocumentContext(gateways.DebugDocumentContext):
	def __init__(self, doc, charPos, maxChars):
		"""Initialise the context.

		doc -- A Python instance implementing the AXDebug document for this context
		charPos -- The charPos within the document
		maxChars -- The number of characters.
		"""
		gateways.DebugDocumentContext.__init__(self)
		self.doc = doc
		self.charPos = charPos
		self.maxChars = maxChars
		self.codeContext = self._MakeCodeContext()
	def _Close(self):
		_wrap_remove(self)
		self.doc = None
		self.codeContext._Close()
	def _MakeCodeContext(self):
		return DebugCodeContext(self, _wrap(self, axdebug.IID_IDebugDocumentContext))
	def GetDocument(self):
#		print "DebugDocumentContext.GetDocument returning (wrapped)",self.doc
		return _wrap(self.doc, axdebug.IID_IDebugDocument)
	def EnumCodeContexts(self):
		return _wrap(EnumDebugCodeContexts([self.codeContext]), axdebug.IID_IEnumDebugCodeContexts, 0)

	def _OnSetBreakPoint(self, codeContext, bps):
		self.doc._OnSetBreakPoint(self, codeContext, bps)
		

class EnumDebugCodeContexts(gateways.EnumDebugCodeContexts):
	def _wrap(self, obj):
		return _wrap(obj, axdebug.IID_IDebugCodeContext)

class DebugCodeContext(gateways.DebugCodeContext):
	def __init__(self, docContext):
		self.docContext = docContext
		gateways.DebugCodeContext.__init__(self)
		self.breakPointState = 0
	def _Close(self):
		self.docContext = None
		_wrap_remove(self)
	def GetDocumentContext(self):
		return self.docContext
	def SetBreakPoint(self, bps):
		print "DebugCodeContext.SetBreakPoint", bps
#		self.docContext._OnSetBreakPoint(self, bps)
		self.breakPointState = bps

