#ifndef __PROPBAG_H__
#define __PROPBAG_H__

#include "PyIPersist.h"

/*-------------------------------------------------------------------------
**
** CLIENT SIDE INTERFACE OBJECTS
**
*/
class PyIPropertyBag : public PyIUnknown
{
public:
	MAKE_PYCOM_CTOR(PyIPropertyBag);
	static IPropertyBag *GetI(PyObject *self);
	static PyComTypeObject type;

	// The Python methods
	static PyObject *Read(PyObject *self, PyObject *args);
	static PyObject *Write(PyObject *self, PyObject *args);

protected:
	PyIPropertyBag(IUnknown *pdisp);
	~PyIPropertyBag();
};

class PyIPersistPropertyBag : public PyIUnknown
{
public:
	MAKE_PYCOM_CTOR(PyIPersistPropertyBag);
	static IPersistPropertyBag *GetI(PyObject *self);
	static PyComTypeObject type;

	// The Python methods
	static PyObject *InitNew(PyObject *self, PyObject *args);
	static PyObject *Load(PyObject *self, PyObject *args);
	static PyObject *Save(PyObject *self, PyObject *args);

protected:
	PyIPersistPropertyBag(IUnknown *pdisp);
	~PyIPersistPropertyBag();
};

class PyIErrorLog : public PyIUnknown
{
public:
	MAKE_PYCOM_CTOR(PyIErrorLog);
	static IErrorLog *GetI(PyObject *self);
	static PyComTypeObject type;

	// The Python methods
	static PyObject *AddError(PyObject *self, PyObject *args);

protected:
	PyIErrorLog(IUnknown *pdisp);
	~PyIErrorLog();
};

/*-------------------------------------------------------------------------
**
** SERVER SIDE GATEWAY OBJECTS
**
*/

class PyGPropertyBag : public PyGatewayBase, public IPropertyBag
{
protected:
	PyGPropertyBag(PyObject *instance) : PyGatewayBase(instance) { ; }
	PYGATEWAY_MAKE_SUPPORT(PyGPropertyBag, IPropertyBag, IID_IPropertyBag)

	// IUnknown and IDispatch
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// IPropertyBag
	STDMETHOD(Read)(
            /* [in] */ LPCOLESTR pszPropName,
            /* [out][in] */ VARIANT __RPC_FAR *pVar,
            /* [in] */ IErrorLog __RPC_FAR *pErrorLog);

	STDMETHOD(Write)(
            /* [in] */ LPCOLESTR pszPropName,
            /* [in] */ VARIANT __RPC_FAR *pVar);
};

class PyGPersistPropertyBag : public PyGPersist, public IPersistPropertyBag
{
protected:
	PyGPersistPropertyBag(PyObject *instance) : PyGPersist(instance) { ; }
	PYGATEWAY_MAKE_SUPPORT(PyGPersistPropertyBag, IPersistPropertyBag, IID_IPersistPropertyBag)

	// IUnknown and IDispatch
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// IPersist
	STDMETHOD(GetClassID)(CLSID FAR *pClassID);

	// IPersistPropertyBag
	STDMETHOD(InitNew)(void);

	STDMETHOD(Load)(
            /* [in] */ IPropertyBag __RPC_FAR *pPropBag,
            /* [in] */ IErrorLog __RPC_FAR *pErrorLog);

	STDMETHOD(Save)(
            /* [in] */ IPropertyBag __RPC_FAR *pPropBag,
            /* [in] */ BOOL fClearDirty,
            /* [in] */ BOOL fSaveAllProperties);
};

class PyGErrorLog : public PyGatewayBase, public IErrorLog
{
protected:
	PyGErrorLog(PyObject *instance) : PyGatewayBase(instance) { ; }
	PYGATEWAY_MAKE_SUPPORT(PyGErrorLog, IErrorLog, IID_IErrorLog)

	// IUnknown and IDispatch
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// IErrorLog
	STDMETHOD(AddError)(
            /* [in] */ LPCOLESTR pszPropName,
            /* [in] */ EXCEPINFO __RPC_FAR *pExcepInfo);
};

#endif /* __PROPBAG_H__ */
