#ifndef __PYIPERSISTSTREAMINIT_H__
#define __PYIPERSISTSTREAMINIT_H__

#include "PythonCOM.h"
#include "PythonCOMServer.h"

#include "PyIPersistStream.h"

class PYCOM_EXPORT PyIPersistStreamInit : public PyIPersistStream
{
public:
	MAKE_PYCOM_CTOR(PyIPersistStreamInit);
	static PyComTypeObject type;
	static IPersistStreamInit *GetI(PyObject *self);

	static PyObject *InitNew(PyObject *self, PyObject *args);

protected:
	PyIPersistStreamInit(IUnknown *);
	~PyIPersistStreamInit();
};

class PyGPersistStreamInit : public PyGPersistStream, public IPersistStreamInit
{
protected:
	PyGPersistStreamInit(PyObject *instance) : PyGPersistStream(instance) { ; }
	PYGATEWAY_MAKE_SUPPORT(PyGPersistStreamInit, IPersistStreamInit, IID_IPersistStreamInit)

	// IUnknown and IDispatch
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// IPersist
	STDMETHOD(GetClassID)(CLSID FAR *pClassID);

	// IPersistStream
	STDMETHOD(IsDirty)(void);

	STDMETHOD(Load)(
            /* [unique][in] */ IStream __RPC_FAR *pStm);

	STDMETHOD(Save)(
            /* [unique][in] */ IStream __RPC_FAR *pStm,
            /* [in] */ BOOL fClearDirty);

	STDMETHOD(GetSizeMax)(
            /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbSize);

	// IPersistStreamInit
	STDMETHOD(InitNew)(void);
};

#endif __PYIPERSISTSTREAMINIT_H__
