#ifndef __PYIPERSISTSTREAM_H__
#define __PYIPERSISTSTREAM_H__

#include "PythonCOM.h"
#include "PythonCOMServer.h"

#include "PyIPersist.h"

class PYCOM_EXPORT PyIPersistStream : public PyIPersist
{
public:
	MAKE_PYCOM_CTOR(PyIPersistStream);
	static PyComTypeObject type;
	static IPersistStream *GetI(PyObject *self);

	static PyObject *IsDirty(PyObject *self, PyObject *args);
	static PyObject *Load(PyObject *self, PyObject *args);
	static PyObject *Save(PyObject *self, PyObject *args);
	static PyObject *GetSizeMax(PyObject *self, PyObject *args);

protected:
	PyIPersistStream(IUnknown *);
	~PyIPersistStream();
};

class PyGPersistStream : public PyGPersist, public IPersistStream
{
protected:
	PyGPersistStream(PyObject *instance) : PyGPersist(instance) { ; }
	PYGATEWAY_MAKE_SUPPORT(PyGPersistStream, IPersistStream, IID_IPersistStream)

	// IUnknown and IDispatch
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// IPersist
	STDMETHOD(GetClassID)(CLSID FAR *pClassID);

	// IPersistStream
	STDMETHOD(IsDirty)(
		void);

	STDMETHOD(Load)(
            /* [unique][in] */ IStream __RPC_FAR *pStm);

	STDMETHOD(Save)(
            /* [unique][in] */ IStream __RPC_FAR *pStm,
            /* [in] */ BOOL fClearDirty);

	STDMETHOD(GetSizeMax)(
            /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbSize);

};

#endif __PYIPERSISTSTREAM_H__
