// This file implements the IStorage Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIStorage.h"
#include "PyWinObjects.h" // Until this uses the new PyTime API...

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIStorage::PyIStorage(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIStorage::~PyIStorage()
{
}

/* static */ IStorage *PyIStorage::GetI(PyObject *self)
{
	return (IStorage *)PyIUnknown::GetI(self);
}

// @pymethod <o PyIStream>|PyIStorage|CreateStream|Description of CreateStream.
PyObject *PyIStorage::CreateStream(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||Name of the new stream
	// @pyparm int|grfMode||Specifies the access mode to use when opening the newly created stream.
	// @pyparm int|reserved1|0|Description for reserved1
	// @pyparm int|reserved2|0|Description for reserved2
	USES_CONVERSION;
	char *szpwcsName;
	DWORD grfMode;
	DWORD reserved1 = 0;
	DWORD reserved2 = 0;
	if ( !PyArg_ParseTuple(args, "si|ii:CreateStream", &szpwcsName, &grfMode, &reserved1, &reserved2) )
		return NULL;
	IStream *ppstm;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = A2COLE(szpwcsName);
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->CreateStream( pwcsName, grfMode, reserved1, reserved2, &ppstm );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyCom_PyObjectFromIUnknown(ppstm, IID_IStream, FALSE);
}

// @pymethod <o PyIStream>|PyIStorage|OpenStream|Description of OpenStream.
PyObject *PyIStorage::OpenStream(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||Description for pwcsName
	// @pyparm object|reserved1||A reserved param.  Always pass None.  NULL is always passed to the COM function
	// @pyparm int|grfMode||Description for grfMode
	// @pyparm int|reserved2|0|Description for reserved2
	USES_CONVERSION;
	char *szpwcsName;
	DWORD grfMode;
	char *szreserved1;
	DWORD reserved2 = 0;
	if ( !PyArg_ParseTuple(args, "szi|i:OpenStream", &szpwcsName, &szreserved1, &grfMode, &reserved2) )
		return NULL;
	IStream *ppstm;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = A2COLE(szpwcsName);
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->OpenStream( pwcsName, NULL, grfMode, reserved2, &ppstm );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyCom_PyObjectFromIUnknown(ppstm, IID_IStream, FALSE);
}

// @pymethod <o PyIStorage>|PyIStorage|CreateStorage|Description of CreateStorage.
PyObject *PyIStorage::CreateStorage(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||The name of the newly created stream.
	// @pyparm int|grfMode||Specifies the access mode to use when opening the newly created storage object.
	// @pyparm int|dwStgFmt||Documented as "reserved"!
	// @pyparm int|reserved2|0|Description for reserved2
	USES_CONVERSION;
	char *szpwcsName;
	DWORD grfMode;
	DWORD dwStgFmt;
	DWORD reserved2 = 0;
	if ( !PyArg_ParseTuple(args, "sii|i:CreateStorage", &szpwcsName, &grfMode, &dwStgFmt, &reserved2) )
		return NULL;
	IStorage *ppstg;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = A2COLE(szpwcsName);
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->CreateStorage( pwcsName, grfMode, dwStgFmt, reserved2, &ppstg );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *obppstg = PyCom_PyObjectFromIUnknown(ppstg, IID_IStorage, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppstg);
	Py_XDECREF(obppstg);
	return pyretval;
}

// @pymethod <o PyIStorage>|PyIStorage|OpenStorage|Description of OpenStorage.
PyObject *PyIStorage::OpenStorage(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||Name of the storage, or None.
	// @pyparm <o PyIStorage>|pstgPriority||If the pstgPriority parameter is not None, it is a <o PyIStorage> object to a previous opening of an element of the storage object, 
	// usually one that was opened in priority mode. The storage object should be closed and re-opened 
	// according to grfMode. When the <om PyIStorage.OpenStorage> method returns, pstgPriority is no longer valid - use the result value. 
	// If the pstgPriority parameter is None, it is ignored.
	// @pyparm int|grfMode||Specifies the access mode to use when opening the storage object.
	// @pyparm <o SNB>|snbExclude||Reserved for later - Must be None
	// @pyparm int|reserved|0|Reserved integer param.
	USES_CONVERSION;
	char *szpwcsName;
	PyObject *obpstgPriority;
	DWORD grfMode;
	DWORD reserved = 0;
	char *temp = NULL;
	if ( !PyArg_ParseTuple(args, "zOi|zi:OpenStorage", &szpwcsName, &obpstgPriority, &grfMode, &temp, &reserved) )
		return NULL;
	IStorage *pstgPriority;
	IStorage *ppstg;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = szpwcsName ? A2COLE(szpwcsName) : NULL;
	if (!PyCom_InterfaceFromPyObject(obpstgPriority, IID_IStorage, (void **)&pstgPriority, TRUE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->OpenStorage( pwcsName, pstgPriority, grfMode, NULL, reserved, &ppstg );
	pstgPriority->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *obppstg = PyCom_PyObjectFromIUnknown(ppstg, IID_IStorage, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppstg);
	Py_XDECREF(obppstg);
	return pyretval;
}

// @pymethod |PyIStorage|CopyTo|Description of CopyTo.
PyObject *PyIStorage::CopyTo(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm [<o PyIID>,]|rgiidExclude||List of IID's to be excluded.
	// @pyparm <o SNB>|snbExclude||Reserved for later - Must be None
	// @pyparm <o PyIStorage>|pstgDest||Description for pstgDest
	DWORD ciidExclude = 0;
	PyObject *obSeqExclude;
	PyObject *obpstgDest;
	char *temp;
	if ( !PyArg_ParseTuple(args, "OzO:CopyTo", &obSeqExclude, &temp, &obpstgDest) )
		return NULL;
	IID *pExclude;
	if (obSeqExclude==Py_None)
		pExclude = NULL;
	else {
		if (!PySequence_Check(obSeqExclude))
			return OleSetTypeError("Argument 1 must be a sequence of IID's, or None");
		ciidExclude = PySequence_Length(obSeqExclude);
		pExclude = new IID[ciidExclude];
		if (pExclude==NULL) 
			return OleSetMemoryError("Allocating array of IID's");
		for (DWORD i=0;i<ciidExclude;i++) {
			PyObject *ob = PySequence_GetItem(obSeqExclude, (int)i);
			BOOL ok = PyCom_CLSIDFromPyObject(ob, pExclude+i);
			Py_XDECREF(ob);
			if (!ok) {
				delete [] pExclude;
				return NULL;
			}
		}
	}
	IStorage *pstgDest;
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyObject(obpstgDest, IID_IStorage, (void **)&pstgDest, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) {
		return NULL;
		delete [] pExclude;
	}
	HRESULT hr = pIS->CopyTo( ciidExclude, pExclude, NULL, pstgDest );
	delete [] pExclude;
	pstgDest->Release();

	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIStorage|MoveElementTo|Description of MoveElementTo.
PyObject *PyIStorage::MoveElementTo(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||Description for pwcsName
	// @pyparm <o PyIStorage>|pstgDest||Description for pstgDest
	// @pyparm string|pwcsNewName||Description for pwcsNewName
	// @pyparm int|grfFlags||Description for grfFlags
	USES_CONVERSION;
	char *szpwcsName;
	PyObject *obpstgDest;
	char *szpwcsNewName;
	DWORD grfFlags;
	if ( !PyArg_ParseTuple(args, "sOsi:MoveElementTo", &szpwcsName, &obpstgDest, &szpwcsNewName, &grfFlags) )
		return NULL;
	IStorage *pstgDest;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = A2COLE(szpwcsName);
	const OLECHAR *pwcsNewName = A2COLE(szpwcsNewName);
	if (!PyCom_InterfaceFromPyObject(obpstgDest, IID_IStorage, (void **)&pstgDest, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->MoveElementTo( pwcsName, pstgDest, pwcsNewName, grfFlags );
	pstgDest->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyIStorage|Commit|Description of Commit.
PyObject *PyIStorage::Commit(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm int|grfCommitFlags||Description for grfCommitFlags
	DWORD grfCommitFlags;
	if ( !PyArg_ParseTuple(args, "i:Commit", &grfCommitFlags) )
		return NULL;
	HRESULT hr = pIS->Commit( grfCommitFlags );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyIStorage|Revert|Description of Revert.
PyObject *PyIStorage::Revert(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":Revert") )
		return NULL;
	HRESULT hr = pIS->Revert( );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod <o PyIEnumSTATSTG>|PyIStorage|EnumElements|Description of EnumElements.
PyObject *PyIStorage::EnumElements(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm int|reserved1|0|Description for reserved1
	// @pyparm object|reserved2|None|A reserved param.  Always pass None.  NULL is always passed to the COM function
	// @pyparm int|reserved3|0|Description for reserved3
	DWORD reserved1 = 0;
	char *szreserved2 = NULL;
	DWORD reserved3 = 0;
	if ( !PyArg_ParseTuple(args, "|izi:EnumElements", &reserved1, &szreserved2, &reserved3) )
		return NULL;
	IEnumSTATSTG *ppenum;
	HRESULT hr = pIS->EnumElements( reserved1, NULL, reserved3, &ppenum );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *obppenum = PyCom_PyObjectFromIUnknown(ppenum, IID_IEnumSTATSTG, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppenum);
	Py_XDECREF(obppenum);
	return pyretval;
}

// @pymethod |PyIStorage|DestroyElement|Description of DestroyElement.
PyObject *PyIStorage::DestroyElement(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||Description for pwcsName
	USES_CONVERSION;
	char *szpwcsName;
	if ( !PyArg_ParseTuple(args, "s:DestroyElement", &szpwcsName) )
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = A2COLE(szpwcsName);
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->DestroyElement( pwcsName );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyIStorage|RenameElement|Description of RenameElement.
PyObject *PyIStorage::RenameElement(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsOldName||Description for pwcsOldName
	// @pyparm string|pwcsNewName||Description for pwcsNewName
	USES_CONVERSION;
	char *szpwcsOldName;
	char *szpwcsNewName;
	if ( !PyArg_ParseTuple(args, "ss:RenameElement", &szpwcsOldName, &szpwcsNewName) )
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsOldName = A2COLE(szpwcsOldName);
	const OLECHAR *pwcsNewName = A2COLE(szpwcsNewName);
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->RenameElement( pwcsOldName, pwcsNewName );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyIStorage|SetElementTimes|Description of SetElementTimes.
PyObject *PyIStorage::SetElementTimes(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm string|pwcsName||Description for pwcsName
	// @pyparm <o PyTime>|pctime||Description for pctime
	// @pyparm <o PyTime>|patime||Description for patime
	// @pyparm <o PyTime>|pmtime||Description for pmtime
	USES_CONVERSION;
	char *szpwcsName;
	PyObject *obpctime;
	PyObject *obpatime;
	PyObject *obpmtime;
	if ( !PyArg_ParseTuple(args, "sOOO:SetElementTimes", &szpwcsName, &obpctime, &obpatime, &obpmtime) )
		return NULL;
	FILETIME pctime;
	FILETIME patime;
	FILETIME pmtime;
	BOOL bPythonIsHappy = TRUE;
	const OLECHAR *pwcsName = A2COLE(szpwcsName);
	if (!PyTime_Check(obpctime)) {
		OleSetTypeError("The argument must be a PyTime object");
		bPythonIsHappy = FALSE;
	}
	if (!((PyTime *)obpctime)->GetTime(&pctime)) bPythonIsHappy = FALSE;
	if (!PyTime_Check(obpatime)) {
		OleSetTypeError("The argument must be a PyTime object");
		bPythonIsHappy = FALSE;
	}
	if (!((PyTime *)obpatime)->GetTime(&patime)) bPythonIsHappy = FALSE;
	if (!PyTime_Check(obpmtime)) {
		OleSetTypeError("The argument must be a PyTime object");
		bPythonIsHappy = FALSE;
	}
	if (!((PyTime *)obpmtime)->GetTime(&pmtime)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->SetElementTimes( pwcsName, &pctime, &patime, &pmtime );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyIStorage|SetClass|Description of SetClass.
PyObject *PyIStorage::SetClass(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm <o PyIID>|clsid||Description for clsid
	PyObject *obclsid;
	if ( !PyArg_ParseTuple(args, "O:SetClass", &obclsid) )
		return NULL;
	IID clsid;
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_CLSIDFromPyObject(obclsid, &clsid)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pIS->SetClass( clsid );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyIStorage|SetStateBits|Description of SetStateBits.
PyObject *PyIStorage::SetStateBits(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm int|grfStateBits||Description for grfStateBits
	// @pyparm int|grfMask||Description for grfMask
	DWORD grfStateBits;
	DWORD grfMask;
	if ( !PyArg_ParseTuple(args, "ii:SetStateBits", &grfStateBits, &grfMask) )
		return NULL;
	HRESULT hr = pIS->SetStateBits( grfStateBits, grfMask );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod <o STATSTG>|PyIStorage|Stat|Returns information about the storage
PyObject *PyIStorage::Stat(PyObject *self, PyObject *args)
{
	IStorage *pIS = GetI(self);
	if ( pIS == NULL )
		return NULL;
	// @pyparm int|grfStatFlag||Description for grfStatFlag
	DWORD grfStatFlag = 0;
	if ( !PyArg_ParseTuple(args, "|i:Stat", &grfStatFlag) )
		return NULL;
	STATSTG pstatstg;
	HRESULT hr = pIS->Stat( &pstatstg, grfStatFlag );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *obpstatstg = PyCom_PyObjectFromSTATSTG(&pstatstg);
	// STATSTG doco says our responsibility to free
	if ((pstatstg).pwcsName) CoTaskMemFree((pstatstg).pwcsName);
	return obpstatstg;
}

// @object PyIStorage|Description of the interface
static struct PyMethodDef PyIStorage_methods[] =
{
	{ "CreateStream", PyIStorage::CreateStream, 1 }, // @pymeth CreateStream|Description of CreateStream
	{ "OpenStream", PyIStorage::OpenStream, 1 }, // @pymeth OpenStream|Description of OpenStream
	{ "CreateStorage", PyIStorage::CreateStorage, 1 }, // @pymeth CreateStorage|Description of CreateStorage
	{ "OpenStorage", PyIStorage::OpenStorage, 1 }, // @pymeth OpenStorage|Description of OpenStorage
	{ "CopyTo", PyIStorage::CopyTo, 1 }, // @pymeth CopyTo|Description of CopyTo
	{ "MoveElementTo", PyIStorage::MoveElementTo, 1 }, // @pymeth MoveElementTo|Description of MoveElementTo
	{ "Commit", PyIStorage::Commit, 1 }, // @pymeth Commit|Description of Commit
	{ "Revert", PyIStorage::Revert, 1 }, // @pymeth Revert|Description of Revert
	{ "EnumElements", PyIStorage::EnumElements, 1 }, // @pymeth EnumElements|Description of EnumElements
	{ "DestroyElement", PyIStorage::DestroyElement, 1 }, // @pymeth DestroyElement|Description of DestroyElement
	{ "RenameElement", PyIStorage::RenameElement, 1 }, // @pymeth RenameElement|Description of RenameElement
	{ "SetElementTimes", PyIStorage::SetElementTimes, 1 }, // @pymeth SetElementTimes|Description of SetElementTimes
	{ "SetClass", PyIStorage::SetClass, 1 }, // @pymeth SetClass|Description of SetClass
	{ "SetStateBits", PyIStorage::SetStateBits, 1 }, // @pymeth SetStateBits|Description of SetStateBits
	{ "Stat", PyIStorage::Stat, 1 }, // @pymeth Stat|Returns information about a storage
	{ NULL }
};

PyComTypeObject PyIStorage::type("PyIStorage",
		&PyIUnknown::type,
		sizeof(PyIStorage),
		PyIStorage_methods,
		GET_PYCOM_CTOR(PyIStorage));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGStorage::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGStorage::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGStorage::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGStorage::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGStorage::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGStorage::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGStorage::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGStorage::CreateStream(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsName,
		/* [in] */ DWORD grfMode,
		/* [in] */ DWORD reserved1,
		/* [in] */ DWORD reserved2,
		/* [out] */ IStream __RPC_FAR *__RPC_FAR * ppstm)
{
	PY_GATEWAY_METHOD;
	if (ppstm==NULL) return E_POINTER;
	USES_CONVERSION;
	PyObject *result;
	char *szpwcsName = OLE2T(pwcsName);
	HRESULT hr=InvokeViaPolicy("CreateStream", &result, "siii", szpwcsName, grfMode, reserved1, reserved2);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppstm;
	if (!PyArg_Parse(result, "O" , &obppstm)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyObject(obppstm, IID_IStream, (void **)ppstm, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGStorage::OpenStream(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsName,
		/* [unique][in] */ void __RPC_FAR * reserved1,
		/* [in] */ DWORD grfMode,
		/* [in] */ DWORD reserved2,
		/* [out] */ IStream __RPC_FAR *__RPC_FAR * ppstm)
{
	PY_GATEWAY_METHOD;
	if (ppstm==NULL) return E_POINTER;
	USES_CONVERSION;
	PyObject *result;
	char *szpwcsName = OLE2T(pwcsName);
	HRESULT hr=InvokeViaPolicy("OpenStream", &result, "szii", szpwcsName, NULL, grfMode, reserved2);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppstm;
	if (!PyArg_Parse(result, "O" , &obppstm)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyObject(obppstm, IID_IStream, (void **)ppstm, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGStorage::CreateStorage(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsName,
		/* [in] */ DWORD grfMode,
		/* [in] */ DWORD dwStgFmt,
		/* [in] */ DWORD reserved2,
		/* [out] */ IStorage __RPC_FAR *__RPC_FAR * ppstg)
{
	PY_GATEWAY_METHOD;
	if (ppstg==NULL) return E_POINTER;
	USES_CONVERSION;
	PyObject *result;
	char *szpwcsName = OLE2T(pwcsName);
	HRESULT hr=InvokeViaPolicy("CreateStorage", &result, "siii", szpwcsName, grfMode, dwStgFmt, reserved2);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppstg;
	if (!PyArg_Parse(result, "O" , &obppstg)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyObject(obppstg, IID_IStorage, (void **)ppstg, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGStorage::OpenStorage(
		/* [string][unique][in] */ const OLECHAR __RPC_FAR * pwcsName,
		/* [unique][in] */ IStorage __RPC_FAR * pstgPriority,
		/* [in] */ DWORD grfMode,
		/* [unique][in] */ SNB snbExclude,
		/* [in] */ DWORD reserved,
		/* [out] */ IStorage __RPC_FAR *__RPC_FAR * ppstg)
{
	PY_GATEWAY_METHOD;
// *** The input argument snbExclude of type "SNB" was not processed ***
//   - None will always be passed to the Python function as a placeholder
//   - The type 'SNB' (snbExclude) is unknown.
	if (ppstg==NULL) return E_POINTER;
	USES_CONVERSION;
	PyObject *obpstgPriority = PyCom_PyObjectFromIUnknown(pstgPriority, IID_IStorage, TRUE);
	PyObject *result;
	char *szpwcsName = OLE2T(pwcsName);
	HRESULT hr=InvokeViaPolicy("OpenStorage", &result, "sOizi", szpwcsName, obpstgPriority, grfMode, NULL, reserved);
	Py_XDECREF(obpstgPriority);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppstg;
	if (!PyArg_Parse(result, "O" , &obppstg)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyObject(obppstg, IID_IStorage, (void **)ppstg, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGStorage::CopyTo(
		/* [in] */ DWORD ciidExclude,
		/* [size_is][unique][in] */ const IID __RPC_FAR * rgiidExclude,
		/* [unique][in] */ SNB snbExclude,
		/* [unique][in] */ IStorage __RPC_FAR * pstgDest)
{
	PY_GATEWAY_METHOD;
// *** The input argument snbExclude of type "SNB" was not processed ***
//   - None will always be passed to the Python function as a placeholder
//   - The type 'SNB' (snbExclude) is unknown.
	PyObject *obrgiidExclude = PyCom_PyIIDObjectFromIID(*rgiidExclude);
	PyObject *obpstgDest = PyCom_PyObjectFromIUnknown(pstgDest, IID_IStorage, TRUE);
	HRESULT hr=InvokeViaPolicy("CopyTo", NULL, "iOzO", ciidExclude, obrgiidExclude, NULL, obpstgDest);
	Py_XDECREF(obrgiidExclude);
	Py_XDECREF(obpstgDest);
	return hr;
}

STDMETHODIMP PyGStorage::MoveElementTo(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsName,
		/* [unique][in] */ IStorage __RPC_FAR * pstgDest,
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsNewName,
		/* [in] */ DWORD grfFlags)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	PyObject *obpstgDest = PyCom_PyObjectFromIUnknown(pstgDest, IID_IStorage, TRUE);
	char *szpwcsName = OLE2T(pwcsName);
	char *szpwcsNewName = OLE2T(pwcsNewName);
	HRESULT hr=InvokeViaPolicy("MoveElementTo", NULL, "sOsi", szpwcsName, obpstgDest, szpwcsNewName, grfFlags);
	Py_XDECREF(obpstgDest);
	return hr;
}

STDMETHODIMP PyGStorage::Commit(
		/* [in] */ DWORD grfCommitFlags)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("Commit", NULL, "i", grfCommitFlags);
	return hr;
}

STDMETHODIMP PyGStorage::Revert(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("Revert", NULL, "i");
	return hr;
}

STDMETHODIMP PyGStorage::EnumElements(
		/* [in] */ DWORD reserved1,
		/* [size_is][unique][in] */ void __RPC_FAR * reserved2,
		/* [in] */ DWORD reserved3,
		/* [out] */ IEnumSTATSTG __RPC_FAR *__RPC_FAR * ppenum)
{
	PY_GATEWAY_METHOD;
	if (ppenum==NULL) return E_POINTER;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("EnumElements", &result, "izi", reserved1, NULL, reserved3);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppenum;
	if (!PyArg_Parse(result, "O" , &obppenum)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyObject(obppenum, IID_IEnumSTATSTG, (void **)ppenum, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGStorage::DestroyElement(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsName)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	char *szpwcsName = OLE2T(pwcsName);
	HRESULT hr=InvokeViaPolicy("DestroyElement", NULL, "s", szpwcsName);
	return hr;
}

STDMETHODIMP PyGStorage::RenameElement(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsOldName,
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsNewName)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	char *szpwcsOldName = OLE2T(pwcsOldName);
	char *szpwcsNewName = OLE2T(pwcsNewName);
	HRESULT hr=InvokeViaPolicy("RenameElement", NULL, "ss", szpwcsOldName, szpwcsNewName);
	return hr;
}

STDMETHODIMP PyGStorage::SetElementTimes(
		/* [string][in] */ const OLECHAR __RPC_FAR * pwcsName,
		/* [in] */ const FILETIME __RPC_FAR * pctime,
		/* [in] */ const FILETIME __RPC_FAR * patime,
		/* [in] */ const FILETIME __RPC_FAR * pmtime)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	PyObject *obpctime = new PyTime(*pctime);
	PyObject *obpatime = new PyTime(*patime);
	PyObject *obpmtime = new PyTime(*pmtime);
	char *szpwcsName = OLE2T(pwcsName);
	HRESULT hr=InvokeViaPolicy("SetElementTimes", NULL, "sOOO", szpwcsName, obpctime, obpatime, obpmtime);
	Py_XDECREF(obpctime);
	Py_XDECREF(obpatime);
	Py_XDECREF(obpmtime);
	return hr;
}

STDMETHODIMP PyGStorage::SetClass(
		/* [in] */ REFCLSID clsid)
{
	PY_GATEWAY_METHOD;
	PyObject *obclsid = PyCom_PyIIDObjectFromIID(clsid);
	HRESULT hr=InvokeViaPolicy("SetClass", NULL, "O", obclsid);
	Py_XDECREF(obclsid);
	return hr;
}

STDMETHODIMP PyGStorage::SetStateBits(
		/* [in] */ DWORD grfStateBits,
		/* [in] */ DWORD grfMask)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("SetStateBits", NULL, "ii", grfStateBits, grfMask);
	return hr;
}

STDMETHODIMP PyGStorage::Stat(
		/* [out] */ STATSTG __RPC_FAR * pstatstg,
		/* [in] */ DWORD grfStatFlag)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("Stat", &result, "i", grfStatFlag);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obpstatstg;
	if (!PyArg_Parse(result, "O" , &obpstatstg)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_PyObjectAsSTATSTG(obpstatstg, pstatstg, 0/*flags*/)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

